/*
 * Decompiled with CFR 0.152.
 */
package dev.nokee.runtime.base.internal.repositories;

import dev.nokee.runtime.base.internal.repositories.AbstractRouteHandler;
import dev.nokee.runtime.base.internal.repositories.JettyEmbeddedHttpServer;
import dev.nokee.runtime.base.internal.repositories.RouteHandler;
import dev.nokee.runtime.base.internal.tools.CommandLineToolLocator;
import dev.nokee.runtime.base.internal.tools.ToolRepository;
import java.net.URI;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.SetProperty;
import org.gradle.api.services.BuildService;
import org.gradle.api.services.BuildServiceParameters;
import org.gradle.internal.Cast;

public abstract class NokeeServerService
implements BuildService<Parameters>,
AutoCloseable {
    public static final String NOKEE_LOCAL_REPOSITORY_NAME = "Nokee Local Repository";
    private static final Logger LOGGER = Logger.getLogger(NokeeServerService.class.getName());
    private final Object lock = new Object();
    private final Server server;

    @Inject
    public NokeeServerService() {
        ToolRepository toolRepository = this.newToolRepository();
        Map<String, RouteHandler> routeMapping = ((Set)((Parameters)this.getParameters()).getRouteHandlers().get()).stream().map(it -> (AbstractRouteHandler)this.getObjects().newInstance(NokeeServerService.toClass(AbstractRouteHandler.class, it), new Object[]{toolRepository})).collect(Collectors.toMap(NokeeServerService::getContextPath, Function.identity()));
        LOGGER.info(() -> String.format("Nokee server will handle %d routes:%n%s", routeMapping.size(), routeMapping.entrySet().stream().map(it -> " * Routing " + (String)it.getKey() + " to " + ((RouteHandler)it.getValue()).getClass().getCanonicalName()).collect(Collectors.joining("\n"))));
        this.server = new Server(0);
        this.server.setHandler((Handler)new JettyEmbeddedHttpServer(routeMapping));
        this.server.setStopAtShutdown(true);
        try {
            this.server.start();
            LOGGER.info("Nokee server started on port " + this.server.getURI().getPort());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private ToolRepository newToolRepository() {
        ToolRepository result = new ToolRepository();
        ((Set)((Parameters)this.getParameters()).getToolLocators().get()).stream().map(it -> (CommandLineToolLocator)this.getObjects().newInstance(NokeeServerService.toClass(CommandLineToolLocator.class, it), new Object[0])).forEach(locator -> locator.getKnownTools().forEach(knownTool -> result.register((String)knownTool, (CommandLineToolLocator)locator)));
        return result;
    }

    private static String getContextPath(AbstractRouteHandler route) {
        return route.getContextPath();
    }

    private static <T> Class<T> toClass(Class<T> baseType, String classname) {
        try {
            Class<?> clazz = Class.forName(classname);
            if (baseType.isAssignableFrom(clazz)) {
                return (Class)Cast.uncheckedCast(clazz);
            }
            throw new RuntimeException("Bad class base");
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    @Inject
    protected abstract ObjectFactory getObjects();

    public URI getUri() {
        URI uri = this.server.getURI();
        return new URI(uri.getScheme(), uri.getUserInfo(), "127.0.0.1", uri.getPort(), uri.getPath(), uri.getFragment(), uri.getQuery());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws Exception {
        Object object = this.lock;
        synchronized (object) {
            this.server.stop();
            this.server.join();
            this.server.destroy();
            LOGGER.info("Nokee server stopped");
        }
    }

    public static interface Parameters
    extends BuildServiceParameters {
        public SetProperty<String> getRouteHandlers();

        public SetProperty<String> getToolLocators();
    }
}

