/*
 * Decompiled with CFR 0.152.
 */
package dev.makth.sets.vectors;

import dev.makth.interfaces.Value;
import dev.makth.numbers.reals.Real;
import dev.makth.operations.Sum;
import dev.makth.resolvables.Context;
import dev.makth.resolvables.variables.Variable;
import dev.makth.sets.matrixes.Matrix;
import dev.makth.sets.vectors.VectorFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010(\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\n\bg\u0018\u00002\u00020\u0001J\u0010\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u001d\u001a\u00020\u00042\u0006\u0010\u001e\u001a\u00020\u0004H\u0016J\u0010\u0010\u001f\u001a\u00020\u00042\u0006\u0010\u001e\u001a\u00020\u0004H\u0016R\u0018\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u001a\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00040\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000e\u001a\u00020\u000f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0012\u001a\u00020\u000f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0011R\u001a\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u00158VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018R \u0010\u0019\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u00030\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u0006R \u0010\u001b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u00030\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u0006\u00a8\u0006 "}, d2={"Ldev/makth/sets/vectors/Vector;", "Ldev/makth/sets/matrixes/Matrix;", "elements", "", "Ldev/makth/interfaces/Value;", "getElements", "()Ljava/util/List;", "iterator", "", "getIterator", "()Ljava/util/Iterator;", "compute", "context", "Ldev/makth/resolvables/Context;", "rawString", "", "getRawString", "()Ljava/lang/String;", "laTeXString", "getLaTeXString", "variables", "", "Ldev/makth/resolvables/variables/Variable;", "getVariables", "()Ljava/util/Set;", "rows", "getRows", "columns", "getColumns", "sum", "right", "multiply", "makth"})
public interface Vector
extends Matrix {
    @NotNull
    public List<Value> getElements();

    @Override
    @NotNull
    public Iterator<Value> getIterator();

    @Override
    @NotNull
    public Value compute(@NotNull Context var1);

    @Override
    @NotNull
    public String getRawString();

    @Override
    @NotNull
    public String getLaTeXString();

    @Override
    @NotNull
    public Set<Variable> getVariables();

    @Override
    @NotNull
    public List<List<Value>> getRows();

    @Override
    @NotNull
    public List<List<Value>> getColumns();

    @Override
    @NotNull
    public Value sum(@NotNull Value var1);

    @Override
    @NotNull
    public Value multiply(@NotNull Value var1);

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    @SourceDebugExtension(value={"SMAP\nVector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Vector.kt\ndev/makth/sets/vectors/Vector$DefaultImpls\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,88:1\n1557#2:89\n1628#2,3:90\n1368#2:93\n1454#2,5:94\n1557#2:99\n1628#2,3:100\n1557#2:103\n1628#2,3:104\n1557#2:107\n1628#2,3:108\n*S KotlinDebug\n*F\n+ 1 Vector.kt\ndev/makth/sets/vectors/Vector$DefaultImpls\n*L\n36#1:89\n36#1:90,3\n51#1:93\n51#1:94,5\n58#1:99\n58#1:100,3\n73#1:103\n73#1:104,3\n82#1:107\n82#1:108,3\n*E\n"})
    public static final class DefaultImpls {
        @NotNull
        public static Iterator<Value> getIterator(@NotNull Vector $this) {
            return $this.getElements().iterator();
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public static Value compute(@NotNull Vector $this, @NotNull Context context) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Iterable iterable = $this.getElements();
            VectorFactory vectorFactory = VectorFactory.INSTANCE;
            boolean $i$f$map = false;
            void var4_5 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                Value value = (Value)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.compute(context));
            }
            return vectorFactory.instantiate((List)destination$iv$iv);
        }

        @NotNull
        public static String getRawString(@NotNull Vector $this) {
            return CollectionsKt.joinToString$default((Iterable)$this.getElements(), (CharSequence)"; ", (CharSequence)"(", (CharSequence)")", (int)0, null, DefaultImpls::_get_rawString_$lambda$1, (int)24, null);
        }

        @NotNull
        public static String getLaTeXString(@NotNull Vector $this) {
            return CollectionsKt.joinToString$default((Iterable)$this.getElements(), (CharSequence)" \\\\ ", (CharSequence)"\\begin{pmatrix} ", (CharSequence)" \\end{pmatrix}", (int)0, null, DefaultImpls::_get_laTeXString_$lambda$2, (int)24, null);
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public static Set<Variable> getVariables(@NotNull Vector $this) {
            void $this$flatMapTo$iv$iv;
            Iterable $this$flatMap$iv = $this.getElements();
            boolean $i$f$flatMap = false;
            Iterable iterable = $this$flatMap$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                Value it = (Value)element$iv$iv;
                boolean bl = false;
                Iterable list$iv$iv = it.getVariables();
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            return CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public static List<List<Value>> getRows(@NotNull Vector $this) {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = $this.getElements();
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                Value value = (Value)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(CollectionsKt.listOf((Object)it));
            }
            return (List)destination$iv$iv;
        }

        @NotNull
        public static List<List<Value>> getColumns(@NotNull Vector $this) {
            return CollectionsKt.listOf($this.getElements());
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public static Value sum(@NotNull Vector $this, @NotNull Value right) {
            Intrinsics.checkNotNullParameter((Object)right, (String)"right");
            if (right instanceof Vector) {
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                if (((Collection)$this.getElements()).size() != ((Collection)((Vector)right).getElements()).size()) {
                    throw new UnsupportedOperationException("Cannot sum vectors of different sizes");
                }
                Iterable iterable = CollectionsKt.zip((Iterable)$this.getElements(), (Iterable)((Vector)right).getElements());
                VectorFactory vectorFactory = VectorFactory.INSTANCE;
                boolean $i$f$map = false;
                void var4_5 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void pair;
                    Pair pair2 = (Pair)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(new Sum((Value)pair.getFirst(), (Value)pair.getSecond()).compute(new Context(null, null, 3, null)));
                }
                return vectorFactory.instantiate((List)destination$iv$iv);
            }
            return Matrix.DefaultImpls.sum($this, right);
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public static Value multiply(@NotNull Vector $this, @NotNull Value right) {
            Intrinsics.checkNotNullParameter((Object)right, (String)"right");
            if (right instanceof Real) {
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                Iterable iterable = $this.getElements();
                VectorFactory vectorFactory = VectorFactory.INSTANCE;
                boolean $i$f$map = false;
                void var4_5 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    Value value = (Value)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(it.multiply(right));
                }
                return vectorFactory.instantiate((List)destination$iv$iv);
            }
            return Matrix.DefaultImpls.multiply($this, right);
        }

        @NotNull
        public static Matrix transpose(@NotNull Vector $this) {
            return Matrix.DefaultImpls.transpose($this);
        }

        public static boolean equals(@NotNull Vector $this, @NotNull Value right) {
            Intrinsics.checkNotNullParameter((Object)right, (String)"right");
            return Matrix.DefaultImpls.equals($this, right);
        }

        @NotNull
        public static String getAlgorithmString(@NotNull Vector $this) {
            return Matrix.DefaultImpls.getAlgorithmString($this);
        }

        public static int getMainPrecedence(@NotNull Vector $this) {
            return Matrix.DefaultImpls.getMainPrecedence($this);
        }

        public static boolean lessThan(@NotNull Vector $this, @NotNull Value right) {
            Intrinsics.checkNotNullParameter((Object)right, (String)"right");
            return Matrix.DefaultImpls.lessThan($this, right);
        }

        @NotNull
        public static Value divide(@NotNull Vector $this, @NotNull Value right) {
            Intrinsics.checkNotNullParameter((Object)right, (String)"right");
            return Matrix.DefaultImpls.divide($this, right);
        }

        @NotNull
        public static Value remainder(@NotNull Vector $this, @NotNull Value right) {
            Intrinsics.checkNotNullParameter((Object)right, (String)"right");
            return Matrix.DefaultImpls.remainder($this, right);
        }

        @NotNull
        public static Value raise(@NotNull Vector $this, @NotNull Value right) {
            Intrinsics.checkNotNullParameter((Object)right, (String)"right");
            return Matrix.DefaultImpls.raise($this, right);
        }

        private static CharSequence _get_rawString_$lambda$1(Value it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return it.getRawString();
        }

        private static CharSequence _get_laTeXString_$lambda$2(Value it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return it.getLaTeXString();
        }
    }
}

