/*
 * Decompiled with CFR 0.152.
 */
package dev.makth.lexers;

import dev.makth.extensions.StringValue;
import dev.makth.interfaces.Value;
import dev.makth.lexers.AlgorithmLexer;
import dev.makth.numbers.integers.IntegerFactory;
import dev.makth.operations.OperationFactory;
import dev.makth.resolvables.Context;
import dev.makth.resolvables.variables.VariableFactory;
import java.util.ArrayList;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\f\n\u0002\b\u000e\b\u0007\u0018\u00002\u00020\u0001:\u0003\u001e\u001f B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u000fJ\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\b\u0010\u0014\u001a\u00020\u0011H\u0002J\b\u0010\u0015\u001a\u00020\u0011H\u0002J\b\u0010\u0016\u001a\u00020\u0011H\u0002J\u0010\u0010\u0017\u001a\u00020\u00112\u0006\u0010\u0018\u001a\u00020\fH\u0002J\u0010\u0010\u0019\u001a\u00020\u00112\u0006\u0010\u001a\u001a\u00020\u0003H\u0002J\n\u0010\u001b\u001a\u0004\u0018\u00010\fH\u0002J\b\u0010\u001c\u001a\u00020\fH\u0002J\n\u0010\u001d\u001a\u0004\u0018\u00010\u0003H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0006\u001a\u0012\u0012\u0004\u0012\u00020\u00030\u0007j\b\u0012\u0004\u0012\u00020\u0003`\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u000b\u001a\u0012\u0012\u0004\u0012\u00020\f0\u0007j\b\u0012\u0004\u0012\u00020\f`\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Ldev/makth/lexers/MathLexer;", "", "content", "", "<init>", "(Ljava/lang/String;)V", "operators", "Ljava/util/ArrayList;", "Lkotlin/collections/ArrayList;", "i", "", "values", "Ldev/makth/interfaces/Value;", "execute", "context", "Ldev/makth/resolvables/Context;", "parseString", "", "delimiter", "", "parseBlock", "parseNumber", "parseVariable", "insertValue", "value", "insertOperation", "op", "createValue", "getFirstTokenAndRemove", "getFirstOperationAndRemove", "NoValueFoundException", "UnknownOperatorException", "Constants", "makth"})
public final class MathLexer {
    @NotNull
    private final String content;
    @NotNull
    private ArrayList<String> operators;
    private int i;
    @NotNull
    private ArrayList<Value> values;

    public MathLexer(@NotNull String content) {
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        this.content = content;
        this.operators = new ArrayList();
        this.values = new ArrayList();
    }

    @NotNull
    public final Value execute(@NotNull Context context) throws AlgorithmLexer.SyntaxException {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        while (this.i < this.content.length()) {
            char c = this.content.charAt(this.i);
            if (c != ' ') {
                if (c == '\"') {
                    this.parseString('\"');
                } else if (c == '$') {
                    this.parseString('$');
                } else if (c == '(') {
                    this.parseBlock();
                } else if (StringsKt.contains$default((CharSequence)"0123456789", (char)c, (boolean)false, (int)2, null)) {
                    this.parseNumber();
                } else if (StringsKt.contains$default((CharSequence)"abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ\u0391\u03b1\u0392\u03b2\u0393\u03b3\u0394\u03b4\u0395\u03b5\u0396\u03b6\u0397\u03b7\u0398\u03b8\u0399\u03b9\u039a\u03ba\u039b\u03bb\u039c\u03bc\u039d\u03bd\u039e\u03be\u039f\u03bf\u03a0\u03c0\u03a3\u03c3\u03c2\u03f9\u03f2\u03a4\u03c4\u03a5\u03c5\u03a6\u03c6\u03a7\u03c7\u03a8\u03c8\u03a9\u03c9_0123456789", (char)c, (boolean)false, (int)2, null)) {
                    this.parseVariable();
                } else {
                    this.insertOperation(String.valueOf(this.content.charAt(this.i)));
                }
            }
            c = this.i;
            this.i = c + 1;
        }
        while (!((Collection)this.operators).isEmpty()) {
            Value value = this.createValue();
            if (value == null) continue;
            this.insertValue(value);
        }
        if (((Collection)this.values).size() == 1) {
            return this.values.get(0).compute(context);
        }
        throw new NoValueFoundException();
    }

    private final void parseString(char delimiter) {
        StringBuilder string = new StringBuilder();
        int n = this.i;
        this.i = n + 1;
        while (this.i < ((CharSequence)this.content).length() && this.content.charAt(this.i) != delimiter) {
            if (this.content.charAt(this.i) == '\\' && this.i < ((CharSequence)this.content).length() - 1) {
                n = this.i;
                this.i = n + 1;
            }
            string.append(this.content.charAt(this.i));
            n = this.i;
            this.i = n + 1;
        }
        String string2 = string.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
        this.insertValue(new StringValue(string2, delimiter == '$'));
    }

    private final void parseBlock() {
        int n = this.i;
        this.i = n + 1;
        StringBuilder subContent = new StringBuilder();
        int count = 0;
        while (this.i < this.content.length() && (this.content.charAt(this.i) != ')' || count != 0)) {
            subContent.append(this.content.charAt(this.i));
            switch (this.content.charAt(this.i)) {
                case '(': {
                    ++count;
                    break;
                }
                case ')': {
                    --count;
                }
            }
            int n2 = this.i;
            this.i = n2 + 1;
        }
        String string = subContent.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        this.insertValue(new MathLexer(string).execute(new Context(null, null, 3, null)));
    }

    private final void parseNumber() {
        int n;
        long value = 0L;
        long powerOfTen = 0L;
        while (this.i < this.content.length() && StringsKt.contains$default((CharSequence)"0123456789", (char)this.content.charAt(this.i), (boolean)false, (int)2, null)) {
            value = value * (long)10 + Long.parseLong(String.valueOf(this.content.charAt(this.i)));
            n = this.i;
            this.i = n + 1;
        }
        if (this.i < this.content.length() - 1 && this.content.charAt(this.i) == '.') {
            n = this.i;
            this.i = n + 1;
            while (this.i < this.content.length() && StringsKt.contains$default((CharSequence)"0123456789", (char)this.content.charAt(this.i), (boolean)false, (int)2, null)) {
                value = value * (long)10 + Long.parseLong(String.valueOf(this.content.charAt(this.i)));
                int n2 = this.i;
                this.i = n2 + 1;
                long l = powerOfTen;
                powerOfTen = l + 1L;
            }
        }
        if (powerOfTen > 0L) {
            String string = "Power not implemented!";
            throw new NotImplementedError("An operation is not implemented: " + string);
        }
        this.insertValue(IntegerFactory.INSTANCE.instantiate(value));
        int n3 = this.i;
        this.i = n3 + -1;
    }

    private final void parseVariable() {
        StringBuilder name = new StringBuilder();
        name.append(this.content.charAt(this.i));
        while (this.i < this.content.length() - 1 && StringsKt.contains$default((CharSequence)"abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ\u0391\u03b1\u0392\u03b2\u0393\u03b3\u0394\u03b4\u0395\u03b5\u0396\u03b6\u0397\u03b7\u0398\u03b8\u0399\u03b9\u039a\u03ba\u039b\u03bb\u039c\u03bc\u039d\u03bd\u039e\u03be\u039f\u03bf\u03a0\u03c0\u03a3\u03c3\u03c2\u03f9\u03f2\u03a4\u03c4\u03a5\u03c5\u03a6\u03c6\u03a7\u03c7\u03a8\u03c8\u03a9\u03c9_0123456789", (char)this.content.charAt(this.i + 1), (boolean)false, (int)2, null)) {
            name.append(this.content.charAt(this.i + 1));
            int n = this.i;
            this.i = n + 1;
        }
        String string = name.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        this.insertValue(VariableFactory.INSTANCE.instantiate(string));
    }

    private final void insertValue(Value value) {
        this.values.add(0, value);
    }

    private final void insertOperation(String op) throws AlgorithmLexer.SyntaxException {
        while (!((Collection)this.operators).isEmpty()) {
            String string = this.operators.get(0);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"get(...)");
            if (OperationFactory.INSTANCE.getPrecedence$makth(string) < OperationFactory.INSTANCE.getPrecedence$makth(op)) break;
            Value value = this.createValue();
            if (value == null) continue;
            this.insertValue(value);
        }
        if (Intrinsics.areEqual((Object)op, (Object)"-") && this.values.isEmpty()) {
            this.insertValue(IntegerFactory.INSTANCE.instantiate(0L));
        }
        if (this.i < this.content.length() - 1 && this.content.charAt(this.i + 1) == '=') {
            this.operators.add(0, op + "=");
            int n = this.i;
            this.i = n + 1;
        } else {
            this.operators.add(0, op);
        }
    }

    private final Value createValue() throws AlgorithmLexer.SyntaxException {
        Value right = this.getFirstTokenAndRemove();
        Value left = this.getFirstTokenAndRemove();
        String op = this.getFirstOperationAndRemove();
        return op != null ? OperationFactory.INSTANCE.initialize(op, left, right) : null;
    }

    private final Value getFirstTokenAndRemove() throws AlgorithmLexer.SyntaxException {
        if (!((Collection)this.values).isEmpty()) {
            Value value = this.values.remove(0);
            Intrinsics.checkNotNullExpressionValue((Object)value, (String)"removeAt(...)");
            return value;
        }
        throw new NoValueFoundException();
    }

    private final String getFirstOperationAndRemove() {
        if (!((Collection)this.operators).isEmpty()) {
            return this.operators.remove(0);
        }
        return null;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Ldev/makth/lexers/MathLexer$Constants;", "", "<init>", "()V", "NUMBERS", "", "VARIABLES", "makth"})
    public static final class Constants {
        @NotNull
        public static final Constants INSTANCE = new Constants();
        @NotNull
        public static final String NUMBERS = "0123456789";
        @NotNull
        public static final String VARIABLES = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ\u0391\u03b1\u0392\u03b2\u0393\u03b3\u0394\u03b4\u0395\u03b5\u0396\u03b6\u0397\u03b7\u0398\u03b8\u0399\u03b9\u039a\u03ba\u039b\u03bb\u039c\u03bc\u039d\u03bd\u039e\u03be\u039f\u03bf\u03a0\u03c0\u03a3\u03c3\u03c2\u03f9\u03f2\u03a4\u03c4\u03a5\u03c5\u03a6\u03c6\u03a7\u03c7\u03a8\u03c8\u03a9\u03c9_0123456789";

        private Constants() {
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0016\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0004"}, d2={"Ldev/makth/lexers/MathLexer$NoValueFoundException;", "Ldev/makth/lexers/AlgorithmLexer$SyntaxException;", "<init>", "()V", "makth"})
    public static class NoValueFoundException
    extends AlgorithmLexer.SyntaxException {
        public NoValueFoundException() {
            super("No value found");
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0016\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Ldev/makth/lexers/MathLexer$UnknownOperatorException;", "Ldev/makth/lexers/AlgorithmLexer$SyntaxException;", "operator", "", "<init>", "(Ljava/lang/String;)V", "getOperator", "()Ljava/lang/String;", "makth"})
    public static class UnknownOperatorException
    extends AlgorithmLexer.SyntaxException {
        @NotNull
        private final String operator;

        public UnknownOperatorException(@NotNull String operator) {
            Intrinsics.checkNotNullParameter((Object)operator, (String)"operator");
            super("Unknown operator: " + operator);
            this.operator = operator;
        }

        @NotNull
        public final String getOperator() {
            return this.operator;
        }
    }
}

