/*
 * Decompiled with CFR 0.152.
 */
package dev.makth.extensions;

import dev.makth.interfaces.Value;
import dev.makth.resolvables.Context;
import dev.makth.resolvables.variables.Variable;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0087\b\u0018\u00002\u00020\u0001B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\f\u001a\u00020\u00012\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u001a\u001a\u00020\u00052\u0006\u0010\u001b\u001a\u00020\u0001H\u0016J\t\u0010\u001c\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001d\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u001e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u001a\u001a\u00020\u00052\b\u0010\u001f\u001a\u0004\u0018\u00010 H\u00d6\u0003J\t\u0010!\u001a\u00020\"H\u00d6\u0001J\t\u0010#\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\u000f\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\tR\u0014\u0010\u0011\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\tR\u0014\u0010\u0013\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\tR\u001a\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u00168VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019\u00a8\u0006$"}, d2={"Ldev/makth/extensions/StringValue;", "Ldev/makth/interfaces/Value;", "value", "", "latex", "", "<init>", "(Ljava/lang/String;Z)V", "getValue", "()Ljava/lang/String;", "getLatex", "()Z", "compute", "context", "Ldev/makth/resolvables/Context;", "algorithmString", "getAlgorithmString", "rawString", "getRawString", "laTeXString", "getLaTeXString", "variables", "", "Ldev/makth/resolvables/variables/Variable;", "getVariables", "()Ljava/util/Set;", "equals", "right", "component1", "component2", "copy", "other", "", "hashCode", "", "toString", "makth"})
public final class StringValue
implements Value {
    @NotNull
    private final String value;
    private final boolean latex;

    public StringValue(@NotNull String value, boolean latex) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.value = value;
        this.latex = latex;
    }

    public /* synthetic */ StringValue(String string, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            bl = false;
        }
        this(string, bl);
    }

    @NotNull
    public final String getValue() {
        return this.value;
    }

    public final boolean getLatex() {
        return this.latex;
    }

    @Override
    @NotNull
    public Value compute(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return this;
    }

    @Override
    @NotNull
    public String getAlgorithmString() {
        String string = this.latex ? "$" : "\"";
        return string + StringsKt.replace$default((String)this.value, (String)String.valueOf(string), (String)("\\" + string), (boolean)false, (int)4, null) + string;
    }

    @Override
    @NotNull
    public String getRawString() {
        return this.value;
    }

    @Override
    @NotNull
    public String getLaTeXString() {
        return this.latex ? StringsKt.replace$default((String)this.value, (String)"$", (String)"\\$", (boolean)false, (int)4, null) : "\\text{" + StringsKt.replace$default((String)StringsKt.replace$default((String)this.value, (String)"{", (String)"\\{", (boolean)false, (int)4, null), (String)"}", (String)"\\}", (boolean)false, (int)4, null) + "}";
    }

    @Override
    @NotNull
    public Set<Variable> getVariables() {
        return SetsKt.emptySet();
    }

    @Override
    public boolean equals(@NotNull Value right) {
        Intrinsics.checkNotNullParameter((Object)right, (String)"right");
        if (right instanceof StringValue) {
            return Intrinsics.areEqual((Object)this.value, (Object)((StringValue)right).value);
        }
        return Value.DefaultImpls.equals(this, right);
    }

    @NotNull
    public final String component1() {
        return this.value;
    }

    public final boolean component2() {
        return this.latex;
    }

    @NotNull
    public final StringValue copy(@NotNull String value, boolean latex) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        return new StringValue(value, latex);
    }

    public static /* synthetic */ StringValue copy$default(StringValue stringValue, String string, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            string = stringValue.value;
        }
        if ((n & 2) != 0) {
            bl = stringValue.latex;
        }
        return stringValue.copy(string, bl);
    }

    @NotNull
    public String toString() {
        return "StringValue(value=" + this.value + ", latex=" + this.latex + ")";
    }

    public int hashCode() {
        int result = this.value.hashCode();
        result = result * 31 + Boolean.hashCode(this.latex);
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof StringValue)) {
            return false;
        }
        StringValue stringValue = (StringValue)other;
        if (!Intrinsics.areEqual((Object)this.value, (Object)stringValue.value)) {
            return false;
        }
        return this.latex == stringValue.latex;
    }

    @Override
    public int getMainPrecedence() {
        return Value.DefaultImpls.getMainPrecedence(this);
    }

    @Override
    public boolean lessThan(@NotNull Value right) {
        return Value.DefaultImpls.lessThan(this, right);
    }

    @Override
    @NotNull
    public Value sum(@NotNull Value right) {
        return Value.DefaultImpls.sum(this, right);
    }

    @Override
    @NotNull
    public Value multiply(@NotNull Value right) {
        return Value.DefaultImpls.multiply(this, right);
    }

    @Override
    @NotNull
    public Value divide(@NotNull Value right) {
        return Value.DefaultImpls.divide(this, right);
    }

    @Override
    @NotNull
    public Value remainder(@NotNull Value right) {
        return Value.DefaultImpls.remainder(this, right);
    }

    @Override
    @NotNull
    public Value raise(@NotNull Value right) {
        return Value.DefaultImpls.raise(this, right);
    }
}

