/*
 * Decompiled with CFR 0.152.
 */
package dev.makth.actions;

import dev.makth.exceptions.ExecutionException;
import dev.makth.exceptions.NotABooleanException;
import dev.makth.exceptions.UnknownVariablesException;
import dev.makth.extensions.BooleanValue;
import dev.makth.extensions.StringValueKt;
import dev.makth.interfaces.Action;
import dev.makth.interfaces.Value;
import dev.makth.lexers.AlgorithmLexer;
import dev.makth.resolvables.Context;
import dev.makth.resolvables.variables.Variable;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\b\u0087\b\u0018\u0000 \u001d2\u00020\u0001:\u0001\u001dB\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00010\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\rH\u0016J\t\u0010\u0013\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00010\u0005H\u00c6\u0003J#\u0010\u0015\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00010\u0005H\u00c6\u0001J\u0013\u0010\u0016\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u00d6\u0003J\t\u0010\u001a\u001a\u00020\u001bH\u00d6\u0001J\t\u0010\u001c\u001a\u00020\u0010H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\u000f\u001a\u00020\u00108VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u001e"}, d2={"Ldev/makth/actions/WhileAction;", "Ldev/makth/interfaces/Action;", "condition", "Ldev/makth/interfaces/Value;", "actions", "", "<init>", "(Ldev/makth/interfaces/Value;Ljava/util/List;)V", "getCondition", "()Ldev/makth/interfaces/Value;", "getActions", "()Ljava/util/List;", "execute", "Ldev/makth/resolvables/Context;", "context", "algorithmString", "", "getAlgorithmString", "()Ljava/lang/String;", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "", "toString", "Companion", "makth"})
@SourceDebugExtension(value={"SMAP\nWhileAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WhileAction.kt\ndev/makth/actions/WhileAction\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,76:1\n1#2:77\n*E\n"})
public final class WhileAction
implements Action {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Value condition;
    @NotNull
    private final List<Action> actions;

    public WhileAction(@NotNull Value condition, @NotNull List<? extends Action> actions) {
        Intrinsics.checkNotNullParameter((Object)condition, (String)"condition");
        Intrinsics.checkNotNullParameter(actions, (String)"actions");
        this.condition = condition;
        this.actions = actions;
    }

    @NotNull
    public final Value getCondition() {
        return this.condition;
    }

    @NotNull
    public final List<Action> getActions() {
        return this.actions;
    }

    @Override
    @NotNull
    public Context execute(@NotNull Context context) throws ExecutionException {
        Set<Variable> set;
        Set<Variable> set2;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Value evaluatedCondition = this.condition.compute(context);
        Set<Variable> it = set2 = evaluatedCondition.getVariables();
        boolean bl = false;
        Set<Variable> set3 = set = !((Collection)it).isEmpty() ? set2 : null;
        if (set != null) {
            it = set;
            boolean bl2 = false;
            throw new UnknownVariablesException((Action)this, context, it);
        }
        if (!(evaluatedCondition instanceof BooleanValue)) {
            throw new NotABooleanException((Action)this, context, evaluatedCondition);
        }
        return ((BooleanValue)evaluatedCondition).getValue() ? context.execute(this.actions).execute(this) : context;
    }

    @Override
    @NotNull
    public String getAlgorithmString() {
        StringBuilder builder = new StringBuilder();
        builder.append("while (");
        builder.append(this.condition.getAlgorithmString());
        builder.append(") {");
        for (Action action : this.actions) {
            builder.append("\n");
            builder.append(StringValueKt.getIndentedLines(action.getAlgorithmString()));
        }
        builder.append("\n}");
        String string = builder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    @NotNull
    public final Value component1() {
        return this.condition;
    }

    @NotNull
    public final List<Action> component2() {
        return this.actions;
    }

    @NotNull
    public final WhileAction copy(@NotNull Value condition, @NotNull List<? extends Action> actions) {
        Intrinsics.checkNotNullParameter((Object)condition, (String)"condition");
        Intrinsics.checkNotNullParameter(actions, (String)"actions");
        return new WhileAction(condition, actions);
    }

    public static /* synthetic */ WhileAction copy$default(WhileAction whileAction, Value value, List list, int n, Object object) {
        if ((n & 1) != 0) {
            value = whileAction.condition;
        }
        if ((n & 2) != 0) {
            list = whileAction.actions;
        }
        return whileAction.copy(value, list);
    }

    @NotNull
    public String toString() {
        return "WhileAction(condition=" + this.condition + ", actions=" + this.actions + ")";
    }

    public int hashCode() {
        int result = this.condition.hashCode();
        result = result * 31 + ((Object)this.actions).hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof WhileAction)) {
            return false;
        }
        WhileAction whileAction = (WhileAction)other;
        if (!Intrinsics.areEqual((Object)this.condition, (Object)whileAction.condition)) {
            return false;
        }
        return Intrinsics.areEqual(this.actions, whileAction.actions);
    }

    @JvmStatic
    @NotNull
    public static final Action handler(@NotNull List<? extends Value> args) {
        return Companion.handler(args);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0007\u00a8\u0006\t"}, d2={"Ldev/makth/actions/WhileAction$Companion;", "", "<init>", "()V", "handler", "Ldev/makth/interfaces/Action;", "args", "", "Ldev/makth/interfaces/Value;", "makth"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final Action handler(@NotNull List<? extends Value> args) {
            Intrinsics.checkNotNullParameter(args, (String)"args");
            if (((Collection)args).size() != 1) {
                throw new AlgorithmLexer.IncorrectArgumentCountException("while", ((Collection)args).size(), 1);
            }
            return new WhileAction(args.get(0), CollectionsKt.emptyList());
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

