/*
 * Decompiled with CFR 0.152.
 */
package dev.makth.actions;

import dev.makth.exceptions.ExecutionException;
import dev.makth.exceptions.NotABooleanException;
import dev.makth.exceptions.UnknownVariablesException;
import dev.makth.extensions.BooleanValue;
import dev.makth.extensions.StringValueKt;
import dev.makth.interfaces.Action;
import dev.makth.interfaces.Value;
import dev.makth.lexers.AlgorithmLexer;
import dev.makth.resolvables.Context;
import dev.makth.resolvables.variables.Variable;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\b\u0087\b\u0018\u0000  2\u00020\u0001:\u0001 B/\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00010\u0005\u0012\u000e\b\u0002\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00010\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000fH\u0016J\t\u0010\u0015\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00010\u0005H\u00c6\u0003J\u000f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00010\u0005H\u00c6\u0003J3\u0010\u0018\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00010\u00052\u000e\b\u0002\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00010\u0005H\u00c6\u0001J\u0013\u0010\u0019\u001a\u00020\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u001cH\u00d6\u0003J\t\u0010\u001d\u001a\u00020\u001eH\u00d6\u0001J\t\u0010\u001f\u001a\u00020\u0012H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\fR\u0014\u0010\u0011\u001a\u00020\u00128VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006!"}, d2={"Ldev/makth/actions/IfAction;", "Ldev/makth/interfaces/Action;", "condition", "Ldev/makth/interfaces/Value;", "actions", "", "elseActions", "<init>", "(Ldev/makth/interfaces/Value;Ljava/util/List;Ljava/util/List;)V", "getCondition", "()Ldev/makth/interfaces/Value;", "getActions", "()Ljava/util/List;", "getElseActions", "execute", "Ldev/makth/resolvables/Context;", "context", "algorithmString", "", "getAlgorithmString", "()Ljava/lang/String;", "component1", "component2", "component3", "copy", "equals", "", "other", "", "hashCode", "", "toString", "Companion", "makth"})
@SourceDebugExtension(value={"SMAP\nIfAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IfAction.kt\ndev/makth/actions/IfAction\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,90:1\n1#2:91\n*E\n"})
public final class IfAction
implements Action {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Value condition;
    @NotNull
    private final List<Action> actions;
    @NotNull
    private final List<Action> elseActions;

    @JvmOverloads
    public IfAction(@NotNull Value condition, @NotNull List<? extends Action> actions, @NotNull List<? extends Action> elseActions) {
        Intrinsics.checkNotNullParameter((Object)condition, (String)"condition");
        Intrinsics.checkNotNullParameter(actions, (String)"actions");
        Intrinsics.checkNotNullParameter(elseActions, (String)"elseActions");
        this.condition = condition;
        this.actions = actions;
        this.elseActions = elseActions;
    }

    public /* synthetic */ IfAction(Value value, List list, List list2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            list2 = CollectionsKt.emptyList();
        }
        this(value, list, list2);
    }

    @NotNull
    public final Value getCondition() {
        return this.condition;
    }

    @NotNull
    public final List<Action> getActions() {
        return this.actions;
    }

    @NotNull
    public final List<Action> getElseActions() {
        return this.elseActions;
    }

    @Override
    @NotNull
    public Context execute(@NotNull Context context) throws ExecutionException {
        Set<Variable> set;
        Set<Variable> set2;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Value evaluatedCondition = this.condition.compute(context);
        Set<Variable> it = set2 = evaluatedCondition.getVariables();
        boolean bl = false;
        Set<Variable> set3 = set = !((Collection)it).isEmpty() ? set2 : null;
        if (set != null) {
            it = set;
            boolean bl2 = false;
            throw new UnknownVariablesException((Action)this, context, it);
        }
        if (!(evaluatedCondition instanceof BooleanValue)) {
            throw new NotABooleanException((Action)this, context, evaluatedCondition);
        }
        return ((BooleanValue)evaluatedCondition).getValue() ? context.execute(this.actions) : context.execute(this.elseActions);
    }

    @Override
    @NotNull
    public String getAlgorithmString() {
        StringBuilder builder = new StringBuilder();
        builder.append("if (");
        builder.append(this.condition.getAlgorithmString());
        builder.append(") {");
        for (Action action : this.actions) {
            builder.append("\n");
            builder.append(StringValueKt.getIndentedLines(action.getAlgorithmString()));
        }
        if (!((Collection)this.elseActions).isEmpty()) {
            builder.append("\n} else {");
            for (Action action : this.elseActions) {
                builder.append("\n");
                builder.append(StringValueKt.getIndentedLines(action.getAlgorithmString()));
            }
        }
        builder.append("\n}");
        String string = builder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    @NotNull
    public final Value component1() {
        return this.condition;
    }

    @NotNull
    public final List<Action> component2() {
        return this.actions;
    }

    @NotNull
    public final List<Action> component3() {
        return this.elseActions;
    }

    @NotNull
    public final IfAction copy(@NotNull Value condition, @NotNull List<? extends Action> actions, @NotNull List<? extends Action> elseActions) {
        Intrinsics.checkNotNullParameter((Object)condition, (String)"condition");
        Intrinsics.checkNotNullParameter(actions, (String)"actions");
        Intrinsics.checkNotNullParameter(elseActions, (String)"elseActions");
        return new IfAction(condition, actions, elseActions);
    }

    public static /* synthetic */ IfAction copy$default(IfAction ifAction, Value value, List list, List list2, int n, Object object) {
        if ((n & 1) != 0) {
            value = ifAction.condition;
        }
        if ((n & 2) != 0) {
            list = ifAction.actions;
        }
        if ((n & 4) != 0) {
            list2 = ifAction.elseActions;
        }
        return ifAction.copy(value, list, list2);
    }

    @NotNull
    public String toString() {
        return "IfAction(condition=" + this.condition + ", actions=" + this.actions + ", elseActions=" + this.elseActions + ")";
    }

    public int hashCode() {
        int result = this.condition.hashCode();
        result = result * 31 + ((Object)this.actions).hashCode();
        result = result * 31 + ((Object)this.elseActions).hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof IfAction)) {
            return false;
        }
        IfAction ifAction = (IfAction)other;
        if (!Intrinsics.areEqual((Object)this.condition, (Object)ifAction.condition)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.actions, ifAction.actions)) {
            return false;
        }
        return Intrinsics.areEqual(this.elseActions, ifAction.elseActions);
    }

    @JvmOverloads
    public IfAction(@NotNull Value condition, @NotNull List<? extends Action> actions) {
        Intrinsics.checkNotNullParameter((Object)condition, (String)"condition");
        Intrinsics.checkNotNullParameter(actions, (String)"actions");
        this(condition, actions, null, 4, null);
    }

    @JvmStatic
    @NotNull
    public static final Action handler(@NotNull List<? extends Value> args) {
        return Companion.handler(args);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0007\u00a8\u0006\t"}, d2={"Ldev/makth/actions/IfAction$Companion;", "", "<init>", "()V", "handler", "Ldev/makth/interfaces/Action;", "args", "", "Ldev/makth/interfaces/Value;", "makth"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final Action handler(@NotNull List<? extends Value> args) {
            Intrinsics.checkNotNullParameter(args, (String)"args");
            if (((Collection)args).size() != 1) {
                throw new AlgorithmLexer.IncorrectArgumentCountException("if", ((Collection)args).size(), 1);
            }
            return new IfAction(args.get(0), CollectionsKt.emptyList(), null, 4, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

