/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.mcp.client;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import dev.langchain4j.agent.tool.ToolSpecification;
import dev.langchain4j.model.chat.request.json.JsonArraySchema;
import dev.langchain4j.model.chat.request.json.JsonBooleanSchema;
import dev.langchain4j.model.chat.request.json.JsonEnumSchema;
import dev.langchain4j.model.chat.request.json.JsonIntegerSchema;
import dev.langchain4j.model.chat.request.json.JsonNumberSchema;
import dev.langchain4j.model.chat.request.json.JsonObjectSchema;
import dev.langchain4j.model.chat.request.json.JsonSchemaElement;
import dev.langchain4j.model.chat.request.json.JsonStringSchema;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

class ToolSpecificationHelper {
    ToolSpecificationHelper() {
    }

    static List<ToolSpecification> toolSpecificationListFromMcpResponse(ArrayNode array) {
        ArrayList<ToolSpecification> result = new ArrayList<ToolSpecification>();
        for (JsonNode tool : array) {
            ToolSpecification.Builder builder = ToolSpecification.builder();
            builder.name(tool.get("name").asText());
            if (tool.has("description")) {
                builder.description(tool.get("description").asText());
            }
            builder.parameters((JsonObjectSchema)ToolSpecificationHelper.jsonNodeToJsonSchemaElement(tool.get("inputSchema")));
            result.add(builder.build());
        }
        return result;
    }

    static JsonSchemaElement jsonNodeToJsonSchemaElement(JsonNode node) {
        String nodeType = node.get("type").asText();
        if (nodeType.equals("object")) {
            JsonNode properties;
            JsonNode description;
            JsonObjectSchema.Builder builder = JsonObjectSchema.builder();
            JsonNode required = node.get("required");
            if (required != null) {
                builder.required(ToolSpecificationHelper.toStringArray((ArrayNode)required));
            }
            if (node.has("additionalProperties")) {
                builder.additionalProperties(Boolean.valueOf(node.get("additionalProperties").asBoolean(false)));
            }
            if ((description = node.get("description")) != null) {
                builder.description(description.asText());
            }
            if ((properties = node.get("properties")) != null) {
                ObjectNode propertiesObject = (ObjectNode)properties;
                for (Map.Entry property : propertiesObject.properties()) {
                    builder.addProperty((String)property.getKey(), ToolSpecificationHelper.jsonNodeToJsonSchemaElement((JsonNode)property.getValue()));
                }
            }
            return builder.build();
        }
        if (nodeType.equals("string")) {
            if (node.has("enum")) {
                JsonEnumSchema.Builder builder = JsonEnumSchema.builder();
                if (node.has("description")) {
                    builder.description(node.get("description").asText());
                }
                builder.enumValues(ToolSpecificationHelper.toStringArray((ArrayNode)node.get("enum")));
                return builder.build();
            }
            JsonStringSchema.Builder builder = JsonStringSchema.builder();
            if (node.has("description")) {
                builder.description(node.get("description").asText());
            }
            return builder.build();
        }
        if (nodeType.equals("number")) {
            JsonNumberSchema.Builder builder = JsonNumberSchema.builder();
            if (node.has("description")) {
                builder.description(node.get("description").asText());
            }
            return builder.build();
        }
        if (nodeType.equals("integer")) {
            JsonIntegerSchema.Builder builder = JsonIntegerSchema.builder();
            if (node.has("description")) {
                builder.description(node.get("description").asText());
            }
            return builder.build();
        }
        if (nodeType.equals("boolean")) {
            JsonBooleanSchema.Builder builder = JsonBooleanSchema.builder();
            if (node.has("description")) {
                builder.description(node.get("description").asText());
            }
            return builder.build();
        }
        if (nodeType.equals("array")) {
            JsonArraySchema.Builder builder = JsonArraySchema.builder();
            if (node.has("description")) {
                builder.description(node.get("description").asText());
            }
            builder.items(ToolSpecificationHelper.jsonNodeToJsonSchemaElement(node.get("items")));
            return builder.build();
        }
        throw new IllegalArgumentException("Unknown element type: " + nodeType);
    }

    private static String[] toStringArray(ArrayNode jsonArray) {
        String[] result = new String[jsonArray.size()];
        for (int i = 0; i < jsonArray.size(); ++i) {
            result[i] = jsonArray.get(i).asText();
        }
        return result;
    }
}

