/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.mcp.client;

import com.fasterxml.jackson.databind.JsonNode;
import dev.langchain4j.mcp.client.BlobResourceContents;
import dev.langchain4j.mcp.client.IllegalResponseException;
import dev.langchain4j.mcp.client.ResourceContents;
import dev.langchain4j.mcp.client.ResourceRef;
import dev.langchain4j.mcp.client.ResourceResponse;
import dev.langchain4j.mcp.client.ResourceTemplateRef;
import dev.langchain4j.mcp.client.TextResourceContents;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ResourcesHelper {
    private static final Logger log = LoggerFactory.getLogger(ResourcesHelper.class);

    ResourcesHelper() {
    }

    static List<ResourceRef> parseResourceRefs(JsonNode mcpMessage) {
        if (mcpMessage.has("result")) {
            JsonNode resultNode = mcpMessage.get("result");
            if (resultNode.has("resources")) {
                ArrayList<ResourceRef> resourceRefs = new ArrayList<ResourceRef>();
                for (JsonNode resourceNode : resultNode.get("resources")) {
                    resourceRefs.add(ResourcesHelper.parseResource(resourceNode));
                }
                return resourceRefs;
            }
            log.warn("Result does not contain 'resources' element: {}", (Object)resultNode);
            throw new IllegalResponseException("Result does not contain 'resources' element");
        }
        log.warn("Result does not contain 'result' element: {}", (Object)mcpMessage);
        throw new IllegalResponseException("Result does not contain 'result' element");
    }

    private static ResourceRef parseResource(JsonNode resourceNode) {
        String uri = resourceNode.get("uri").asText();
        String name = resourceNode.get("name").asText();
        JsonNode description = resourceNode.get("description");
        String descriptionString = description != null ? description.asText() : null;
        JsonNode mimeType = resourceNode.get("mimeType");
        String mimeTypeString = mimeType != null ? mimeType.asText() : null;
        return new ResourceRef(uri, name, descriptionString, mimeTypeString);
    }

    public static ResourceResponse parseResourceContents(JsonNode mcpMessage) {
        if (mcpMessage.has("result")) {
            JsonNode resultNode = mcpMessage.get("result");
            if (resultNode.has("contents")) {
                ArrayList<ResourceContents> resourceContentsList = new ArrayList<ResourceContents>();
                for (JsonNode resourceNode : resultNode.get("contents")) {
                    String mimeType;
                    String uri = resourceNode.get("uri").asText();
                    String string = mimeType = resourceNode.get("mimeType") != null ? resourceNode.get("mimeType").asText() : null;
                    if (resourceNode.has("text")) {
                        resourceContentsList.add(new TextResourceContents(uri, resourceNode.get("text").asText(), mimeType));
                        continue;
                    }
                    if (!resourceNode.has("blob")) continue;
                    resourceContentsList.add(new BlobResourceContents(uri, resourceNode.get("blob").asText(), mimeType));
                }
                return new ResourceResponse(resourceContentsList);
            }
            log.warn("Result does not contain 'contents' element: {}", (Object)resultNode);
            throw new IllegalResponseException("Result does not contain 'resources' element");
        }
        log.warn("Result does not contain 'result' element: {}", (Object)mcpMessage);
        throw new IllegalResponseException("Result does not contain 'result' element");
    }

    public static List<ResourceTemplateRef> parseResourceTemplateRefs(JsonNode mcpMessage) {
        if (mcpMessage.has("result")) {
            JsonNode resultNode = mcpMessage.get("result");
            if (resultNode.has("resourceTemplates")) {
                ArrayList<ResourceTemplateRef> resourceTemplateRefs = new ArrayList<ResourceTemplateRef>();
                for (JsonNode resourceTemplateNode : resultNode.get("resourceTemplates")) {
                    resourceTemplateRefs.add(ResourcesHelper.parseResourceTemplate(resourceTemplateNode));
                }
                return resourceTemplateRefs;
            }
            log.warn("Result does not contain 'resourceTemplates' element: {}", (Object)resultNode);
            throw new IllegalResponseException("Result does not contain 'resourceTemplates' element");
        }
        log.warn("Result does not contain 'result' element: {}", (Object)mcpMessage);
        throw new IllegalResponseException("Result does not contain 'result' element");
    }

    private static ResourceTemplateRef parseResourceTemplate(JsonNode resourceTemplateNode) {
        String uriTemplate = resourceTemplateNode.get("uriTemplate").asText();
        String name = resourceTemplateNode.get("name").asText();
        JsonNode description = resourceTemplateNode.get("description");
        String descriptionString = description != null ? description.asText() : null;
        JsonNode mimeType = resourceTemplateNode.get("mimeType");
        String mimeTypeString = mimeType != null ? mimeType.asText() : null;
        return new ResourceTemplateRef(uriTemplate, name, descriptionString, mimeTypeString);
    }
}

