/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.store.embedding.cassandra;

import com.datastax.oss.driver.api.core.CqlSession;
import com.datastax.oss.driver.api.core.CqlSessionBuilder;
import com.datastax.oss.driver.api.core.cql.Statement;
import com.datastax.oss.driver.api.querybuilder.SchemaBuilder;
import com.datastax.oss.driver.api.querybuilder.schema.CreateKeyspace;
import com.dtsx.astra.sdk.cassio.MetadataVectorCassandraTable;
import com.dtsx.astra.sdk.cassio.SimilarityMetric;
import dev.langchain4j.store.embedding.cassandra.CassandraEmbeddingConfiguration;
import dev.langchain4j.store.embedding.cassandra.CassandraEmbeddingStoreSupport;
import java.net.InetSocketAddress;
import java.util.Arrays;

public class CassandraEmbeddingStore
extends CassandraEmbeddingStoreSupport {
    public CassandraEmbeddingStore(CassandraEmbeddingConfiguration config) {
        CqlSessionBuilder sessionBuilder = this.createCqlSessionBuilder(config);
        this.createKeyspaceIfNotExist(sessionBuilder, config.getKeyspace());
        sessionBuilder.withKeyspace(config.getKeyspace());
        this.embeddingTable = new MetadataVectorCassandraTable((CqlSession)sessionBuilder.build(), config.getKeyspace(), config.getTable(), config.getDimension().intValue(), SimilarityMetric.COS);
    }

    private CqlSessionBuilder createCqlSessionBuilder(CassandraEmbeddingConfiguration config) {
        CqlSessionBuilder cqlSessionBuilder = CqlSession.builder();
        cqlSessionBuilder.withLocalDatacenter(config.getLocalDataCenter());
        if (config.getUserName() != null && config.getPassword() != null) {
            cqlSessionBuilder.withAuthCredentials(config.getUserName(), config.getPassword());
        }
        config.getContactPoints().forEach(cp -> {
            CqlSessionBuilder cfr_ignored_0 = (CqlSessionBuilder)cqlSessionBuilder.addContactPoint(new InetSocketAddress((String)cp, (int)config.getPort()));
        });
        return cqlSessionBuilder;
    }

    private void createKeyspaceIfNotExist(CqlSessionBuilder cqlSessionBuilder, String keyspace) {
        try (CqlSession adminSession = (CqlSession)cqlSessionBuilder.build();){
            adminSession.execute((Statement)((CreateKeyspace)((CreateKeyspace)SchemaBuilder.createKeyspace((String)keyspace).ifNotExists().withSimpleStrategy(1)).withDurableWrites(true)).build());
        }
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private final CassandraEmbeddingConfiguration.CassandraEmbeddingConfigurationBuilder conf = CassandraEmbeddingConfiguration.builder();

        public Builder port(int port) {
            this.conf.port(port);
            return this;
        }

        public Builder contactPoints(String ... hosts) {
            this.conf.contactPoints(Arrays.asList(hosts));
            return this;
        }

        public Builder vectorDimension(int dimension) {
            this.conf.dimension(dimension);
            return this;
        }

        public Builder localDataCenter(String dc) {
            this.conf.localDataCenter(dc);
            return this;
        }

        public Builder table(String keyspace, String table) {
            this.conf.keyspace(keyspace);
            this.conf.table(table);
            return this;
        }

        public CassandraEmbeddingStore build() {
            return new CassandraEmbeddingStore(this.conf.build());
        }
    }
}

