/*
 * Decompiled with CFR 0.152.
 */
package dev.blaauwendraad.masker.json.util;

import dev.blaauwendraad.masker.json.util.AsciiCharacter;

public final class Utf8Util {
    private Utf8Util() {
    }

    public static int getCodePointByteLength(byte input) {
        int shift = 7;
        int mostSignificantBitValue = input >> shift & 1;
        if (mostSignificantBitValue == 0) {
            return 1;
        }
        if ((input >> --shift & 1) == 0) {
            return 0;
        }
        --shift;
        while (shift > 2) {
            int bitValue = input >> shift & 1;
            if (bitValue == 0) {
                return 7 - shift;
            }
            --shift;
        }
        throw new IllegalArgumentException("Input byte is not using UTF-8 encoding");
    }

    public static char unicodeHexToChar(byte b1, byte b2, byte b3, byte b4) {
        int value = Character.digit(Utf8Util.validateHex(b1), 16);
        value = value << 4 | Character.digit(Utf8Util.validateHex(b2), 16);
        value = value << 4 | Character.digit(Utf8Util.validateHex(b3), 16);
        value = value << 4 | Character.digit(Utf8Util.validateHex(b4), 16);
        return (char)value;
    }

    private static byte validateHex(byte hexByte) {
        if (hexByte >= 48 && hexByte <= 57) {
            return hexByte;
        }
        if (hexByte >= 65 && hexByte <= 70) {
            return hexByte;
        }
        if (hexByte >= 97 && hexByte <= 102) {
            return hexByte;
        }
        throw new IllegalArgumentException("Invalid hex character '%s'".formatted(Character.valueOf((char)hexByte)));
    }

    public static int countNonVisibleCharacters(byte[] message, int fromIndex, int length) {
        int toIndex = fromIndex + length;
        boolean isEscapeCharacter = false;
        int nonVisibleCharacterCount = 0;
        for (int index = fromIndex; index < toIndex; ++index) {
            byte currentByte = message[index];
            if (isEscapeCharacter) {
                ++nonVisibleCharacterCount;
                if (AsciiCharacter.isLowercaseU(currentByte)) {
                    nonVisibleCharacterCount += 4;
                    index += 4;
                }
            } else {
                int codePointByteLength = Utf8Util.getCodePointByteLength(currentByte);
                if (codePointByteLength > 1) {
                    nonVisibleCharacterCount += codePointByteLength - 1;
                }
            }
            isEscapeCharacter = !isEscapeCharacter && AsciiCharacter.isEscapeCharacter(currentByte);
        }
        return nonVisibleCharacterCount;
    }

    public static String jsonEncode(String value, boolean includeQuotes) {
        StringBuilder encoded = new StringBuilder();
        if (includeQuotes) {
            encoded.append("\"");
        }
        block8: for (int i = 0; i < value.length(); ++i) {
            char character = value.charAt(i);
            switch (character) {
                case '\b': {
                    encoded.append("\\b");
                    continue block8;
                }
                case '\t': {
                    encoded.append("\\t");
                    continue block8;
                }
                case '\n': {
                    encoded.append("\\n");
                    continue block8;
                }
                case '\f': {
                    encoded.append("\\f");
                    continue block8;
                }
                case '\r': {
                    encoded.append("\\r");
                    continue block8;
                }
                case '\"': 
                case '\\': {
                    encoded.append('\\').append(character);
                    continue block8;
                }
                default: {
                    if (character <= '\u001f') {
                        encoded.append("\\u%04X".formatted(character));
                        continue block8;
                    }
                    encoded.append(character);
                }
            }
        }
        if (includeQuotes) {
            encoded.append("\"");
        }
        return encoded.toString();
    }
}

