/*
 * Decompiled with CFR 0.152.
 */
package dev.blaauwendraad.masker.json.util;

public enum AsciiCharacter {
    ASTERISK(42),
    BACK_SLASH(92),
    CARRIAGE_RETURN(13),
    COLON(58),
    COMMA(44),
    CURLY_BRACKET_CLOSE(125),
    CURLY_BRACKET_OPEN(123),
    DOUBLE_QUOTE(34),
    HORIZONTAL_TAB(9),
    LINE_FEED(10),
    MINUS(45),
    PERIOD(46),
    PLUS(43),
    SPACE(32),
    SQUARE_BRACKET_OPEN(91),
    SQUARE_BRACKET_CLOSE(93),
    UPPERCASE_E(69),
    LOWERCASE_A(97),
    LOWERCASE_E(101),
    LOWERCASE_F(102),
    LOWERCASE_L(108),
    LOWERCASE_N(110),
    LOWERCASE_R(114),
    LOWERCASE_S(115),
    LOWERCASE_T(116),
    LOWERCASE_U(117),
    ZERO(48),
    ONE(49),
    TWO(50),
    THREE(51),
    FOUR(52),
    FIVE(53),
    SIX(54),
    SEVEN(55),
    EIGHT(56),
    NINE(57);

    final byte byteValue;

    private AsciiCharacter(byte byteValue) {
        this.byteValue = byteValue;
    }

    public static boolean isDoubleQuote(byte inputByte) {
        return DOUBLE_QUOTE.getAsciiByteValue() == inputByte;
    }

    public static boolean isEscapeCharacter(byte inputByte) {
        return BACK_SLASH.getAsciiByteValue() == inputByte;
    }

    public static boolean isLowercaseU(byte inputByte) {
        return LOWERCASE_U.getAsciiByteValue() == inputByte;
    }

    public static boolean isSquareBracketOpen(byte inputByte) {
        return SQUARE_BRACKET_OPEN.getAsciiByteValue() == inputByte;
    }

    public static boolean isSquareBracketClose(byte inputByte) {
        return SQUARE_BRACKET_CLOSE.getAsciiByteValue() == inputByte;
    }

    public static boolean isCurlyBracketOpen(byte inputByte) {
        return CURLY_BRACKET_OPEN.getAsciiByteValue() == inputByte;
    }

    public static boolean isCurlyBracketClose(byte inputByte) {
        return CURLY_BRACKET_CLOSE.getAsciiByteValue() == inputByte;
    }

    public static boolean isLowercaseT(byte inputByte) {
        return LOWERCASE_T.getAsciiByteValue() == inputByte;
    }

    public byte getAsciiByteValue() {
        return this.byteValue;
    }
}

