/*
 * Decompiled with CFR 0.152.
 */
package dev.blaauwendraad.masker.json.config;

import dev.blaauwendraad.masker.json.ValueMasker;
import dev.blaauwendraad.masker.json.ValueMaskers;
import java.util.Objects;
import org.jspecify.annotations.Nullable;

public final class KeyMaskingConfig {
    private final ValueMasker.StringMasker maskStringsWith;
    private final ValueMasker.NumberMasker maskNumbersWith;
    private final ValueMasker.BooleanMasker maskBooleansWith;

    KeyMaskingConfig(Builder builder) {
        this.maskStringsWith = Objects.requireNonNullElseGet(builder.maskStringsWith, () -> ValueMaskers.with("***"));
        this.maskNumbersWith = Objects.requireNonNullElseGet(builder.maskNumbersWith, () -> ValueMaskers.with("###"));
        this.maskBooleansWith = Objects.requireNonNullElseGet(builder.maskBooleansWith, () -> ValueMaskers.with("&&&"));
    }

    public static Builder builder() {
        return new Builder();
    }

    public ValueMasker.StringMasker getStringValueMasker() {
        return this.maskStringsWith;
    }

    public ValueMasker.NumberMasker getNumberValueMasker() {
        return this.maskNumbersWith;
    }

    public ValueMasker.BooleanMasker getBooleanValueMasker() {
        return this.maskBooleansWith;
    }

    public String toString() {
        return "maskStringsWith=%s, maskNumbersWith=%s, maskBooleansWith=%s".formatted(this.maskStringsWith, this.maskNumbersWith, this.maskBooleansWith);
    }

    public static class Builder {
        private  @Nullable ValueMasker.StringMasker maskStringsWith;
        private  @Nullable ValueMasker.NumberMasker maskNumbersWith;
        private  @Nullable ValueMasker.BooleanMasker maskBooleansWith;

        private Builder() {
        }

        public Builder maskStringsWith(String value) {
            this.maskStringsWith(ValueMaskers.with(value));
            return this;
        }

        public Builder maskStringCharactersWith(String value) {
            this.maskStringsWith(ValueMaskers.eachCharacterWith(value));
            return this;
        }

        public Builder maskStringsWith(ValueMasker.StringMasker valueMasker) {
            if (this.maskStringsWith != null) {
                throw new IllegalArgumentException("'maskStringsWith' was already set");
            }
            this.maskStringsWith = valueMasker;
            return this;
        }

        public Builder maskNumbersWith(String value) {
            this.maskNumbersWith(ValueMaskers.with(value));
            return this;
        }

        public Builder maskNumbersWith(int value) {
            this.maskNumbersWith(ValueMaskers.with(value));
            return this;
        }

        public Builder maskNumberDigitsWith(int digit) {
            this.maskNumbersWith(ValueMaskers.eachDigitWith(digit));
            return this;
        }

        public Builder maskNumbersWith(ValueMasker.NumberMasker valueMasker) {
            if (this.maskNumbersWith != null) {
                throw new IllegalArgumentException("'maskNumbersWith' was already set");
            }
            this.maskNumbersWith = valueMasker;
            return this;
        }

        public Builder maskBooleansWith(String value) {
            this.maskBooleansWith(ValueMaskers.with(value));
            return this;
        }

        public Builder maskBooleansWith(boolean value) {
            this.maskBooleansWith(ValueMaskers.with(value));
            return this;
        }

        public Builder maskBooleansWith(ValueMasker.BooleanMasker valueMasker) {
            if (this.maskBooleansWith != null) {
                throw new IllegalArgumentException("'maskBooleansWith' was already set");
            }
            this.maskBooleansWith = valueMasker;
            return this;
        }

        public KeyMaskingConfig build() {
            return new KeyMaskingConfig(this);
        }
    }
}

