/*
 * Decompiled with CFR 0.152.
 */
package dev.blaauwendraad.masker.json;

import dev.blaauwendraad.masker.json.InvalidJsonException;
import dev.blaauwendraad.masker.json.KeyMatcher;
import dev.blaauwendraad.masker.json.ValueMaskerContext;
import dev.blaauwendraad.masker.json.util.Utf8Util;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jspecify.annotations.Nullable;

final class MaskingState
implements ValueMaskerContext {
    private static final int INITIAL_JSONPATH_STACK_CAPACITY = 16;
    private final byte[] message;
    private int currentIndex = 0;
    private final List<ReplacementOperation> replacementOperations = new ArrayList<ReplacementOperation>();
    private int replacementOperationsTotalDifference = 0;
    private @Nullable KeyMatcher.TrieNode[] currentJsonPath = null;
    private int currentJsonPathHeadIndex = -1;
    private int currentValueStartIndex = -1;

    public MaskingState(byte[] message, boolean trackJsonPath) {
        this.message = message;
        if (trackJsonPath) {
            this.currentJsonPath = new KeyMatcher.TrieNode[16];
        }
    }

    public boolean next() {
        return ++this.currentIndex < this.message.length;
    }

    public void incrementIndex(int length) {
        this.currentIndex += length;
    }

    public byte byteAtCurrentIndex() {
        return this.message[this.currentIndex];
    }

    public boolean endOfJson() {
        return this.currentIndex == this.message.length;
    }

    public int currentIndex() {
        return this.currentIndex;
    }

    public byte[] getMessage() {
        return this.message;
    }

    public void replaceTargetValueWith(int startIndex, int length, byte[] mask, int maskRepeat) {
        ReplacementOperation replacementOperation = new ReplacementOperation(startIndex, length, mask, maskRepeat);
        this.replacementOperations.add(replacementOperation);
        this.replacementOperationsTotalDifference += replacementOperation.difference();
    }

    public byte[] flushReplacementOperations() {
        if (this.replacementOperations.isEmpty()) {
            return this.message;
        }
        byte[] newMessage = new byte[this.message.length + this.replacementOperationsTotalDifference];
        int index = 0;
        int offset = 0;
        for (ReplacementOperation replacementOperation : this.replacementOperations) {
            System.arraycopy(this.message, index, newMessage, index + offset, replacementOperation.startIndex - index);
            int length = replacementOperation.mask.length;
            for (int i = 0; i < replacementOperation.maskRepeat; ++i) {
                System.arraycopy(replacementOperation.mask, 0, newMessage, replacementOperation.startIndex + offset + i * length, length);
            }
            index = replacementOperation.startIndex + replacementOperation.length;
            offset += replacementOperation.difference();
        }
        System.arraycopy(this.message, index, newMessage, index + offset, this.message.length - index);
        this.currentIndex = Integer.MAX_VALUE;
        return newMessage;
    }

    boolean jsonPathEnabled() {
        return this.currentJsonPath != null;
    }

    void expandCurrentJsonPath(@Nullable KeyMatcher.TrieNode trieNode) {
        if (this.currentJsonPath != null) {
            this.currentJsonPath[++this.currentJsonPathHeadIndex] = trieNode;
            if (this.currentJsonPathHeadIndex == this.currentJsonPath.length - 1) {
                this.currentJsonPath = Arrays.copyOf(this.currentJsonPath, this.currentJsonPath.length * 2);
            }
        }
    }

    void backtrackCurrentJsonPath() {
        if (this.currentJsonPath != null) {
            this.currentJsonPath[this.currentJsonPathHeadIndex--] = null;
        }
    }

    public @Nullable KeyMatcher.TrieNode getCurrentJsonPathNode() {
        if (this.currentJsonPath != null && this.currentJsonPathHeadIndex != -1) {
            return this.currentJsonPath[this.currentJsonPathHeadIndex];
        }
        return null;
    }

    public int getCurrentValueStartIndex() {
        if (this.currentValueStartIndex == -1) {
            throw new IllegalStateException("No current value index set to mask");
        }
        return this.currentValueStartIndex;
    }

    public void registerValueStartIndex() {
        this.currentValueStartIndex = this.currentIndex;
    }

    public void clearValueStartIndex() {
        this.currentValueStartIndex = -1;
    }

    @Override
    public byte getByte(int index) {
        this.checkCurrentValueBounds(index);
        return this.message[this.getCurrentValueStartIndex() + index];
    }

    @Override
    public int byteLength() {
        return this.currentIndex - this.getCurrentValueStartIndex();
    }

    @Override
    public void replaceBytes(int fromIndex, int length, byte[] mask, int maskRepeat) {
        this.checkCurrentValueBounds(fromIndex);
        this.checkCurrentValueBounds(fromIndex + length - 1);
        this.replaceTargetValueWith(this.getCurrentValueStartIndex() + fromIndex, length, mask, maskRepeat);
    }

    @Override
    public int countNonVisibleCharacters(int fromIndex, int length) {
        this.checkCurrentValueBounds(fromIndex);
        this.checkCurrentValueBounds(fromIndex + length - 1);
        return Utf8Util.countNonVisibleCharacters(this.message, this.getCurrentValueStartIndex() + fromIndex, length);
    }

    @Override
    public String asString(int fromIndex, int length) {
        this.checkCurrentValueBounds(fromIndex);
        this.checkCurrentValueBounds(fromIndex + length - 1);
        int offset = this.getCurrentValueStartIndex();
        return new String(this.message, offset + fromIndex, length, StandardCharsets.UTF_8);
    }

    @Override
    public InvalidJsonException invalidJson(String message, int index) {
        int offset = this.getCurrentValueStartIndex();
        return new InvalidJsonException("%s at index %s".formatted(message, offset + index));
    }

    private void checkCurrentValueBounds(int index) {
        if (index < 0 || index >= this.byteLength()) {
            throw new IndexOutOfBoundsException("Index " + index + " is out of bounds for value of length " + this.byteLength());
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(new String(this.message, Math.max(0, this.currentIndex - 10), Math.min(10, this.currentIndex)));
        sb.append(">");
        if (this.currentIndex == this.message.length) {
            sb.append("<end of json>");
        } else {
            sb.append((char)this.message[this.currentIndex]);
            if (this.currentIndex + 1 < this.message.length) {
                sb.append("<");
                sb.append(new String(this.message, this.currentIndex + 1, Math.min(10, this.message.length - this.currentIndex - 1)));
            }
        }
        return sb.toString();
    }

    private record ReplacementOperation(int startIndex, int length, byte[] mask, int maskRepeat) {
        public int difference() {
            return this.mask.length * this.maskRepeat - this.length;
        }
    }
}

