/*
 * Decompiled with CFR 0.152.
 */
package dev.blaauwendraad.masker.json;

import dev.blaauwendraad.masker.json.config.JsonMaskingConfig;
import dev.blaauwendraad.masker.json.config.KeyMaskingConfig;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import org.jspecify.annotations.Nullable;

final class KeyMatcher {
    private static final int BYTE_OFFSET = 128;
    private static final int SKIP_KEY_LOOKUP = -1;
    private final JsonMaskingConfig maskingConfig;
    private final TrieNode root;
    private final boolean[] knownKeyLengthsInBytes = new boolean[256];

    public KeyMatcher(JsonMaskingConfig maskingConfig) {
        this.maskingConfig = maskingConfig;
        this.root = new TrieNode();
        maskingConfig.getTargetKeys().forEach(key -> this.insert((String)key, false));
        maskingConfig.getTargetJsonPaths().forEach(jsonPath -> this.insert(jsonPath.toString(), false));
        if (maskingConfig.isInAllowMode()) {
            maskingConfig.getKeyConfigs().keySet().forEach(key -> this.insert((String)key, true));
        }
    }

    private void insert(String word, boolean negativeMatch) {
        boolean caseInsensitive = !this.maskingConfig.caseSensitiveTargetKeys();
        byte[] bytes = word.getBytes(StandardCharsets.UTF_8);
        this.knownKeyLengthsInBytes[Math.min((int)bytes.length, (int)255)] = true;
        byte[] lowerBytes = null;
        byte[] upperBytes = null;
        if (caseInsensitive) {
            lowerBytes = word.toLowerCase().getBytes(StandardCharsets.UTF_8);
            upperBytes = word.toUpperCase().getBytes(StandardCharsets.UTF_8);
            if (bytes.length != lowerBytes.length || bytes.length != upperBytes.length) {
                throw new IllegalArgumentException("Case insensitive trie does not support all characters in " + word);
            }
        }
        TrieNode node = this.root;
        for (int i = 0; i < bytes.length; ++i) {
            byte b = bytes[i];
            TrieNode child = node.child(b);
            if (child == null) {
                child = new TrieNode();
                node.add(b, child);
                if (caseInsensitive) {
                    Objects.requireNonNull(lowerBytes);
                    Objects.requireNonNull(upperBytes);
                    node.add(lowerBytes[i], child);
                    node.add(upperBytes[i], child);
                }
            }
            node = child;
        }
        node.keyMaskingConfig = this.maskingConfig.getConfig(word);
        node.endOfWord = true;
        node.negativeMatch = negativeMatch;
    }

    @Nullable KeyMaskingConfig getMaskConfigIfMatched(byte[] bytes, int keyOffset, int keyLength, @Nullable TrieNode currentJsonPathNode) {
        TrieNode node = currentJsonPathNode;
        if (this.maskingConfig.isInMaskMode()) {
            if (node != null && node.endOfWord && !node.negativeMatch) {
                return node.keyMaskingConfig;
            }
            if (keyLength != -1 && (node = this.searchNode(bytes, keyOffset, keyLength)) != null && !node.negativeMatch) {
                return node.keyMaskingConfig;
            }
            return null;
        }
        if (node != null && node.endOfWord) {
            if (node.negativeMatch) {
                return node.keyMaskingConfig;
            }
            return null;
        }
        if (keyLength != -1 && (node = this.searchNode(bytes, keyOffset, keyLength)) != null) {
            if (node.negativeMatch) {
                return node.keyMaskingConfig;
            }
            return null;
        }
        return this.maskingConfig.getDefaultConfig();
    }

    private @Nullable TrieNode searchNode(byte[] bytes, int offset, int length) {
        if (!this.knownKeyLengthsInBytes[Math.min(length, 255)]) {
            return null;
        }
        TrieNode node = this.root;
        for (int i = offset; i < offset + length; ++i) {
            byte b = bytes[i];
            if ((node = node.child(b)) != null) continue;
            return null;
        }
        if (!node.endOfWord) {
            return null;
        }
        return node;
    }

    @Nullable TrieNode getJsonPathRootNode() {
        return this.root.child((byte)36);
    }

    @Nullable TrieNode traverseJsonPathSegment(byte[] bytes, @Nullable TrieNode begin, int keyOffset, int keyLength) {
        if (begin == null) {
            return null;
        }
        TrieNode current = begin.child((byte)46);
        if (current == null) {
            return null;
        }
        TrieNode wildcardLookAhead = current.child((byte)42);
        if (wildcardLookAhead != null && (wildcardLookAhead.endOfWord || wildcardLookAhead.child((byte)46) != null)) {
            return wildcardLookAhead;
        }
        for (int i = keyOffset; i < keyOffset + keyLength; ++i) {
            byte b = bytes[i];
            if ((current = current.child(b)) != null) continue;
            return null;
        }
        return current;
    }

    static class TrieNode {
        final TrieNode[] children = new TrieNode[256];
        boolean endOfWord = false;
        @Nullable KeyMaskingConfig keyMaskingConfig = null;
        boolean negativeMatch = false;

        TrieNode() {
        }

        @Nullable TrieNode child(byte b) {
            return this.children[b + 128];
        }

        void add(byte b, TrieNode child) {
            this.children[b + 128] = child;
        }
    }
}

