/*
 * Decompiled with CFR 0.152.
 */
package dev.blaauwendraad.masker.json;

import dev.blaauwendraad.masker.json.InvalidJsonException;
import dev.blaauwendraad.masker.json.JsonMasker;
import dev.blaauwendraad.masker.json.KeyMatcher;
import dev.blaauwendraad.masker.json.MaskingState;
import dev.blaauwendraad.masker.json.config.JsonMaskingConfig;
import dev.blaauwendraad.masker.json.config.KeyMaskingConfig;
import dev.blaauwendraad.masker.json.util.AsciiCharacter;
import dev.blaauwendraad.masker.json.util.AsciiJsonUtil;
import org.jspecify.annotations.Nullable;

final class KeyContainsMasker
implements JsonMasker {
    private final KeyMatcher keyMatcher;
    private final JsonMaskingConfig maskingConfig;

    KeyContainsMasker(JsonMaskingConfig maskingConfig) {
        this.maskingConfig = maskingConfig;
        this.keyMatcher = new KeyMatcher(maskingConfig);
    }

    @Override
    public byte[] mask(byte[] input) {
        try {
            KeyMaskingConfig keyMaskingConfig;
            MaskingState maskingState = new MaskingState(input, !this.maskingConfig.getTargetJsonPaths().isEmpty());
            KeyMaskingConfig keyMaskingConfig2 = keyMaskingConfig = this.maskingConfig.isInAllowMode() ? this.maskingConfig.getDefaultConfig() : null;
            if (maskingState.jsonPathEnabled()) {
                maskingState.expandCurrentJsonPath(this.keyMatcher.getJsonPathRootNode());
                keyMaskingConfig = this.keyMatcher.getMaskConfigIfMatched(maskingState.getMessage(), -1, -1, maskingState.getCurrentJsonPathNode());
            }
            KeyContainsMasker.stepOverWhitespaceCharacters(maskingState);
            this.visitValue(maskingState, keyMaskingConfig);
            return maskingState.flushReplacementOperations();
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new InvalidJsonException("Invalid JSON input provided: %s".formatted(e.getMessage()), e);
        }
    }

    private void visitValue(MaskingState maskingState, @Nullable KeyMaskingConfig keyMaskingConfig) {
        switch (maskingState.byteAtCurrentIndex()) {
            case 91: {
                this.visitArray(maskingState, keyMaskingConfig);
                break;
            }
            case 123: {
                this.visitObject(maskingState, keyMaskingConfig);
                break;
            }
            case 45: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: {
                if (keyMaskingConfig != null) {
                    this.maskNumber(maskingState, keyMaskingConfig);
                    break;
                }
                KeyContainsMasker.stepOverNumericValue(maskingState);
                break;
            }
            case 34: {
                if (keyMaskingConfig != null) {
                    this.maskString(maskingState, keyMaskingConfig);
                    break;
                }
                KeyContainsMasker.stepOverStringValue(maskingState);
                break;
            }
            case 116: {
                if (keyMaskingConfig != null) {
                    this.maskBoolean(maskingState, keyMaskingConfig);
                    break;
                }
                maskingState.incrementIndex(4);
                break;
            }
            case 102: {
                if (keyMaskingConfig != null) {
                    this.maskBoolean(maskingState, keyMaskingConfig);
                    break;
                }
                maskingState.incrementIndex(5);
                break;
            }
            case 110: {
                maskingState.incrementIndex(4);
                break;
            }
        }
    }

    private void visitArray(MaskingState maskingState, @Nullable KeyMaskingConfig keyMaskingConfig) {
        maskingState.expandCurrentJsonPath(this.keyMatcher.traverseJsonPathSegment(maskingState.getMessage(), maskingState.getCurrentJsonPathNode(), -1, -1));
        while (maskingState.next()) {
            KeyContainsMasker.stepOverWhitespaceCharacters(maskingState);
            if (maskingState.byteAtCurrentIndex() == 93) break;
            this.visitValue(maskingState, keyMaskingConfig);
            KeyContainsMasker.stepOverWhitespaceCharacters(maskingState);
            if (maskingState.byteAtCurrentIndex() != 93) continue;
        }
        maskingState.next();
        maskingState.backtrackCurrentJsonPath();
    }

    private void visitObject(MaskingState maskingState, @Nullable KeyMaskingConfig parentKeyMaskingConfig) {
        while (maskingState.next()) {
            boolean valueAllowed;
            KeyContainsMasker.stepOverWhitespaceCharacters(maskingState);
            if (maskingState.byteAtCurrentIndex() == 125) break;
            int openingQuoteIndex = maskingState.currentIndex();
            KeyContainsMasker.stepOverStringValue(maskingState);
            int afterClosingQuoteIndex = maskingState.currentIndex();
            int keyLength = afterClosingQuoteIndex - openingQuoteIndex - 2;
            maskingState.expandCurrentJsonPath(this.keyMatcher.traverseJsonPathSegment(maskingState.getMessage(), maskingState.getCurrentJsonPathNode(), openingQuoteIndex + 1, keyLength));
            KeyMaskingConfig keyMaskingConfig = this.keyMatcher.getMaskConfigIfMatched(maskingState.getMessage(), openingQuoteIndex + 1, keyLength, maskingState.getCurrentJsonPathNode());
            KeyContainsMasker.stepOverWhitespaceCharacters(maskingState);
            maskingState.next();
            KeyContainsMasker.stepOverWhitespaceCharacters(maskingState);
            boolean bl = valueAllowed = this.maskingConfig.isInAllowMode() && keyMaskingConfig == null;
            if (valueAllowed) {
                KeyContainsMasker.stepOverValue(maskingState);
            } else {
                if (parentKeyMaskingConfig != null && (keyMaskingConfig == null || keyMaskingConfig == this.maskingConfig.getDefaultConfig())) {
                    keyMaskingConfig = parentKeyMaskingConfig;
                }
                this.visitValue(maskingState, keyMaskingConfig);
            }
            maskingState.backtrackCurrentJsonPath();
            KeyContainsMasker.stepOverWhitespaceCharacters(maskingState);
            if (maskingState.byteAtCurrentIndex() != 125) continue;
            break;
        }
        maskingState.next();
    }

    private void maskString(MaskingState maskingState, KeyMaskingConfig keyMaskingConfig) {
        maskingState.registerValueStartIndex();
        KeyContainsMasker.stepOverStringValue(maskingState);
        keyMaskingConfig.getStringValueMasker().maskValue(maskingState);
        maskingState.clearValueStartIndex();
    }

    private void maskNumber(MaskingState maskingState, KeyMaskingConfig keyMaskingConfig) {
        maskingState.registerValueStartIndex();
        KeyContainsMasker.stepOverNumericValue(maskingState);
        keyMaskingConfig.getNumberValueMasker().maskValue(maskingState);
        maskingState.clearValueStartIndex();
    }

    private void maskBoolean(MaskingState maskingState, KeyMaskingConfig keyMaskingConfig) {
        maskingState.registerValueStartIndex();
        maskingState.incrementIndex(AsciiCharacter.isLowercaseT(maskingState.byteAtCurrentIndex()) ? 4 : 5);
        keyMaskingConfig.getBooleanValueMasker().maskValue(maskingState);
        maskingState.clearValueStartIndex();
    }

    private static void stepOverValue(MaskingState maskingState) {
        switch (maskingState.byteAtCurrentIndex()) {
            case 34: {
                KeyContainsMasker.stepOverStringValue(maskingState);
                break;
            }
            case 45: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: {
                KeyContainsMasker.stepOverNumericValue(maskingState);
                break;
            }
            case 110: 
            case 116: {
                maskingState.incrementIndex(4);
                break;
            }
            case 102: {
                maskingState.incrementIndex(5);
                break;
            }
            case 123: {
                KeyContainsMasker.stepOverObject(maskingState);
                break;
            }
            case 91: {
                KeyContainsMasker.stepOverArray(maskingState);
                break;
            }
        }
    }

    private static void stepOverWhitespaceCharacters(MaskingState maskingState) {
        while (!maskingState.endOfJson() && AsciiJsonUtil.isWhiteSpace(maskingState.byteAtCurrentIndex())) {
            maskingState.next();
        }
    }

    private static void stepOverNumericValue(MaskingState maskingState) {
        do {
            maskingState.next();
        } while (maskingState.currentIndex() < maskingState.getMessage().length && AsciiJsonUtil.isNumericCharacter(maskingState.byteAtCurrentIndex()));
    }

    private static void stepOverStringValue(MaskingState maskingState) {
        boolean isEscapeCharacter = false;
        while (maskingState.next()) {
            if (!isEscapeCharacter && maskingState.byteAtCurrentIndex() == 34) {
                maskingState.next();
                break;
            }
            isEscapeCharacter = !isEscapeCharacter && maskingState.byteAtCurrentIndex() == 92;
        }
    }

    private static void stepOverObject(MaskingState maskingState) {
        maskingState.next();
        int objectDepth = 1;
        while (objectDepth > 0) {
            if (AsciiCharacter.isDoubleQuote(maskingState.byteAtCurrentIndex())) {
                KeyContainsMasker.stepOverStringValue(maskingState);
                continue;
            }
            if (AsciiCharacter.isCurlyBracketOpen(maskingState.byteAtCurrentIndex())) {
                ++objectDepth;
            } else if (AsciiCharacter.isCurlyBracketClose(maskingState.byteAtCurrentIndex())) {
                --objectDepth;
            }
            maskingState.next();
        }
    }

    private static void stepOverArray(MaskingState maskingState) {
        maskingState.next();
        int arrayDepth = 1;
        while (arrayDepth > 0) {
            if (AsciiCharacter.isDoubleQuote(maskingState.byteAtCurrentIndex())) {
                KeyContainsMasker.stepOverStringValue(maskingState);
                continue;
            }
            if (AsciiCharacter.isSquareBracketOpen(maskingState.byteAtCurrentIndex())) {
                ++arrayDepth;
            } else if (AsciiCharacter.isSquareBracketClose(maskingState.byteAtCurrentIndex())) {
                --arrayDepth;
            }
            maskingState.next();
        }
    }
}

