package de.knightsoftnet.validators.shared.data;

import java.util.HashMap;
import java.util.Map;

public class TinMapConstantsPropertiesImpl implements CreateTinMapConstantsClass.TinMapConstantsProperties {

  private final Map<String, String> propertiesMap;

  private void fillMap0() {
    propertiesMap.put("DE", "^[1-9]\\d{10}$");
    propertiesMap.put("BE", "^\\d{11}$");
    propertiesMap.put("FI", "^\\d{6}[+\\-A]\\d{3}[0-9A-Z]$");
    propertiesMap.put("PT", "^\\d{9}$");
    propertiesMap.put("BG", "^\\d{10}$");
    propertiesMap.put("DK", "^\\d{10}$");
    propertiesMap.put("LT", "^\\d{11}$");
    propertiesMap.put("LU", "^\\d{13}$");
    propertiesMap.put("HR", "^\\d{11}$");
    propertiesMap.put("LV", "^[0-3]\\d[01]\\d{8}$");
    propertiesMap.put("FR", "^[0-3]\\d{12}$");
    propertiesMap.put("HU", "^\\d{10}$");
    propertiesMap.put("SE", "^\\d{10}$");
    propertiesMap.put("SI", "^\\d{8}$");
    propertiesMap.put("UK", "^(\\d{10}|[A-Z]{2}\\d{6}[ABCD])$");
    propertiesMap.put("ME", "^[0-3]\\d[01]\\d{10}$");
    propertiesMap.put("SK", "^[0-3]\\d\\.[01]\\d.\\d{4}$");
    propertiesMap.put("IE", "^\\d{7}[A-Z]{1,2}$");
    propertiesMap.put("MK", "^[0-3]\\d[01]\\d{10}$");
    propertiesMap.put("EE", "^\\d{11}$");
    propertiesMap.put("MT", "^(\\d{3}[MGAPLHBZ]|\\d{7}[MGAPLHBZ]|\\d{9})$");
    propertiesMap.put("GR", "^\\d{9}$");
    propertiesMap.put("IT", "^[A-Z]{6}\\d{2}[A-Z]\\d{2}[A-Z]\\d{3}[A-Z]$");
    propertiesMap.put("ES", "^(\\d{8}[A-Z]|[ABCDEFGHJKLMNPQRSUVW]\\d{7}[0-9A-J]|[XYZ]\\d{7,8}[A-Z])$");
    propertiesMap.put("AT", "^\\d{9}$");
    propertiesMap.put("CY", "^\\d{8}[A-Z]$");
    propertiesMap.put("CZ", "^\\d{9,10}$");
    propertiesMap.put("PL", "^\\d{10,11}$");
    propertiesMap.put("RO", "^\\d{13}$");
    propertiesMap.put("NL", "^\\d{9}$");
    propertiesMap.put("BA", "^[0-3]\\d[01]\\d{10}$");
  }

  public TinMapConstantsPropertiesImpl() {
    propertiesMap = new HashMap<>();
    fillMap0();
  }

  @Override
  public Map<String, String> properties() {
    return propertiesMap;
  }
}
