/*
 * Decompiled with CFR 0.152.
 */
package de.knightsoftnet.validators.annotation.processor;

import de.knightsoftnet.validators.annotation.processor.ApUtils;
import de.knightsoftnet.validators.annotation.processor.TypeUtils;
import de.knightsoftnet.validators.client.GwtValidation;
import jakarta.validation.GroupSequence;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.List;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import javax.tools.Diagnostic;
import javax.tools.JavaFileObject;

public class ValidatorCreator {
    public void writeClass(String packageName, String interfaceName, String factoryClass, GwtValidation gwtValidation, ProcessingEnvironment processingEnv) {
        try {
            JavaFileObject builderFile = processingEnv.getFiler().createSourceFile(packageName + "." + interfaceName + "Impl", new Element[0]);
            try (PrintWriter out = new PrintWriter(builderFile.openWriter());){
                this.writeClassHeader(out, packageName, interfaceName, factoryClass);
                out.println();
                this.writeConstructor(out, interfaceName, gwtValidation, processingEnv);
                out.println();
                this.writeCreateValidationGroupsMetadata(out, gwtValidation);
                out.println();
                this.writeCreateValidatorForInstanceClass(out, gwtValidation, processingEnv);
                this.writeClassFooter(out);
            }
        }
        catch (IOException e) {
            processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, e.getMessage());
            e.printStackTrace();
        }
    }

    private void writeClassHeader(PrintWriter out, String packageName, String interfaceName, String factoryClass) {
        out.print("package ");
        out.print(packageName);
        out.println(";");
        out.println();
        out.println("import de.knightsoftnet.validators.client.impl.AbstractGwtSpecificValidator;");
        out.println("import de.knightsoftnet.validators.client.impl.AbstractGwtValidator;");
        out.println("import de.knightsoftnet.validators.client.impl.GwtBeanDescriptor;");
        out.println("import de.knightsoftnet.validators.client.impl.GwtSpecificValidator;");
        out.println("import de.knightsoftnet.validators.client.impl.GwtValidationContext;");
        out.println("import de.knightsoftnet.validators.client.impl.metadata.ValidationGroupsMetadata;");
        out.println();
        out.println("import java.util.HashMap;");
        out.println("import java.util.HashSet;");
        out.println("import java.util.Map;");
        out.println("import java.util.Set;");
        out.println("import java.util.stream.Collectors;");
        out.println("import java.util.stream.Stream;");
        out.println();
        out.println("import jakarta.validation.groups.Default;");
        out.println("import jakarta.validation.ConstraintViolation;");
        out.println("import jakarta.validation.metadata.BeanDescriptor;");
        out.println();
        out.print("public class ");
        out.print(interfaceName);
        out.print("Impl extends AbstractGwtValidator implements ");
        out.print(factoryClass);
        out.print(".");
        out.print(interfaceName);
        out.println(" {");
    }

    private void writeConstructor(PrintWriter out, String interfaceName, GwtValidation gwtValidation, ProcessingEnvironment processingEnv) {
        out.print("  public ");
        out.print(interfaceName);
        out.println("Impl() {");
        out.println("    super(Stream.of(new Object[][] {");
        ApUtils.getTypeMirrorFromAnnotationValue(gwtValidation::value).forEach(typeMirror -> {
            out.println("        {" + typeMirror.toString() + ".class,");
            out.println("            " + TypeUtils.getValidationInstanceForType(typeMirror, processingEnv.getTypeUtils(), processingEnv.getElementUtils()) + "},");
        });
        out.println("    }).collect(Collectors.toMap(data -> (Class<?>) data[0],");
        out.println("        data -> (AbstractGwtSpecificValidator<?>) data[1])), createValidationGroupsMetadata());");
        out.println("  }");
    }

    private void writeCreateValidationGroupsMetadata(PrintWriter out, GwtValidation gwtValidation) {
        out.println("  private static ValidationGroupsMetadata createValidationGroupsMetadata() {");
        out.println("    return ValidationGroupsMetadata.builder()");
        for (TypeMirror typeMirror : ApUtils.getTypeMirrorFromAnnotationValue(gwtValidation::groups)) {
            List<String> groups;
            GroupSequence sequenceAnnotation = typeMirror.getAnnotation(GroupSequence.class);
            if (sequenceAnnotation == null) {
                out.print("        .addGroup(");
                out.print(typeMirror.toString() + ".class");
                List<? extends TypeMirror> interfaces = ((TypeElement)((DeclaredType)typeMirror).asElement()).getInterfaces();
                groups = interfaces.stream().map(inter -> inter.toString() + ".class").toList();
            } else {
                out.print("        .addSequence(");
                out.print(typeMirror.getClass().getCanonicalName() + ".class");
                groups = Arrays.stream(sequenceAnnotation.value()).map(clazz -> clazz.getCanonicalName() + ".class").toList();
            }
            for (String clazz2 : groups) {
                out.print(", ");
                out.print(clazz2);
            }
            out.println(")");
        }
        out.println("        .build();");
        out.println("  }");
    }

    private void writeCreateValidatorForInstanceClass(PrintWriter out, GwtValidation gwtValidation, ProcessingEnvironment processingEnv) {
        out.println("  @Override");
        out.println("  protected <T> AbstractGwtSpecificValidator<T> getValidatorForInstanceClass(");
        out.println("      final Object object) {");
        ApUtils.getTypeMirrorFromAnnotationValue(gwtValidation::value).forEach(typeMirror -> {
            out.println("    if (object instanceof " + typeMirror.toString() + ") {");
            out.println("      return (AbstractGwtSpecificValidator<T>) " + TypeUtils.getValidationInstanceForType(typeMirror, processingEnv.getTypeUtils(), processingEnv.getElementUtils()) + ";");
            out.println("    }");
        });
        out.println("    return null;");
        out.println("  }");
    }

    private void writeClassFooter(PrintWriter out) {
        out.println("}");
    }
}

