/*
 * Decompiled with CFR 0.152.
 */
package de.knightsoftnet.validators.annotation.processor;

import de.knightsoftnet.validators.annotation.processor.TypeElementConstraintDescriptor;
import de.knightsoftnet.validators.annotation.processor.TypeElementConstraintDescriptorImpl;
import de.knightsoftnet.validators.annotation.processor.TypeElementPropertyDescriptor;
import java.util.Collections;
import java.util.List;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import org.hibernate.validator.internal.metadata.location.ConstraintLocation;

public class TypeElementPropertyDescriptorImpl
implements TypeElementPropertyDescriptor {
    private final String propertyName;
    private final Element typeElement;
    private final TypeMirror elementType;
    private final List<TypeElementConstraintDescriptor<?>> constraintDescriptors;
    private final ConstraintLocation.ConstraintLocationKind constraintLocationKind;

    public TypeElementPropertyDescriptorImpl(Element typeElement, DeclaredType beanType, ProcessingEnvironment processingEnv, ConstraintLocation.ConstraintLocationKind constraintLocationKind) {
        this.typeElement = typeElement;
        this.elementType = switch (typeElement.getKind()) {
            case ElementKind.METHOD -> ((ExecutableElement)typeElement).getReturnType();
            case ElementKind.FIELD -> processingEnv.getTypeUtils().asMemberOf(beanType, typeElement);
            default -> typeElement.asType();
        };
        this.constraintLocationKind = constraintLocationKind;
        this.propertyName = constraintLocationKind == ConstraintLocation.ConstraintLocationKind.TYPE ? "this" : typeElement.getSimpleName().toString();
        this.constraintDescriptors = TypeElementConstraintDescriptorImpl.createComposingConstraintsForElement(typeElement, processingEnv.getElementUtils(), constraintLocationKind, Collections.emptyMap());
    }

    @Override
    public String getPropertyName() {
        return this.propertyName;
    }

    @Override
    public TypeMirror getElementType() {
        return this.elementType;
    }

    @Override
    public List<TypeElementConstraintDescriptor<?>> getConstraintDescriptors() {
        return this.constraintLocationKind == ConstraintLocation.ConstraintLocationKind.TYPE ? Collections.emptyList() : this.constraintDescriptors;
    }

    @Override
    public boolean isCascaded() {
        return this.typeElement.getAnnotationMirrors().stream().filter(annotationMirror -> "jakarta.validation.Valid".contentEquals(annotationMirror.getAnnotationType().toString())).count() != 0L;
    }

    @Override
    public List<TypeElementConstraintDescriptor<?>> getConstrainedContainerElementTypes() {
        return this.constraintLocationKind == ConstraintLocation.ConstraintLocationKind.TYPE ? this.constraintDescriptors : Collections.emptyList();
    }
}

