/*
 * Decompiled with CFR 0.152.
 */
package de.knightsoftnet.validators.annotation.processor;

import de.knightsoftnet.validators.annotation.processor.TypeElementConstraintDescriptor;
import de.knightsoftnet.validators.annotation.processor.TypeUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.hibernate.validator.internal.metadata.core.ConstraintOrigin;
import org.hibernate.validator.internal.metadata.location.ConstraintLocation;

public class TypeElementConstraintDescriptorImpl<T extends AnnotationMirror>
implements TypeElementConstraintDescriptor<T> {
    private static final String CONSTRAINT = "jakarta.validation.Constraint";
    private static final String REPORT_AS_SINGLETON = "jakarta.validation.ReportAsSingleViolation";
    private static final String DEFAULT_GROUP = "jakarta.validation.groups.Default";
    private static final Map<String, List<String>> FALLBACK;
    private final AnnotationMirror annotation;
    private final Map<String, Map.Entry<? extends ExecutableElement, ? extends AnnotationValue>> attributes;
    private final List<TypeMirror> constraintValidatorClasses;
    private final Set<TypeMirror> groups;
    private final List<TypeElementConstraintDescriptor<?>> composingConstraints;
    private final boolean reportAsSingleViolation;
    private final ConstraintLocation.ConstraintLocationKind constraintLocationKind;

    public TypeElementConstraintDescriptorImpl(AnnotationMirror annotation, Elements elementUtils, ConstraintLocation.ConstraintLocationKind constraintLocationKind) {
        this(annotation, elementUtils, constraintLocationKind, null);
    }

    public TypeElementConstraintDescriptorImpl(AnnotationMirror annotation, Elements elementUtils, ConstraintLocation.ConstraintLocationKind constraintLocationKind, Map<String, Map.Entry<? extends ExecutableElement, ? extends AnnotationValue>> overrideFromParent) {
        this.annotation = annotation;
        HashMap<String, Map<String, Map.Entry<? extends ExecutableElement, ? extends AnnotationValue>>> overridesMap = new HashMap<String, Map<String, Map.Entry<? extends ExecutableElement, ? extends AnnotationValue>>>();
        this.reportAsSingleViolation = TypeElementConstraintDescriptorImpl.filterConstraint(annotation, REPORT_AS_SINGLETON).isPresent();
        this.constraintValidatorClasses = this.createConctraintValidatorClasses(annotation, elementUtils);
        this.attributes = this.createAttributes(annotation, elementUtils, overrideFromParent, overridesMap);
        this.groups = this.createGroups(this.attributes, elementUtils);
        this.composingConstraints = constraintLocationKind == ConstraintLocation.ConstraintLocationKind.TYPE ? Collections.emptyList() : TypeElementConstraintDescriptorImpl.createComposingConstraintsForElement(annotation.getAnnotationType().asElement(), elementUtils, constraintLocationKind, overridesMap);
        this.constraintLocationKind = constraintLocationKind;
    }

    private List<TypeMirror> createConctraintValidatorClasses(AnnotationMirror annotation, Elements elementUtils) {
        ArrayList<TypeMirror> constraintValidatorClasses = new ArrayList<TypeMirror>();
        Optional<AnnotationMirror> optionalConstraint = TypeElementConstraintDescriptorImpl.filterConstraint(annotation, CONSTRAINT);
        if (optionalConstraint.isPresent()) {
            constraintValidatorClasses.addAll(((List)((AnnotationValue)optionalConstraint.get().getElementValues().values().stream().collect(Collectors.toList()).get(0)).getValue()).stream().map(object -> this.createTypeMirror(object.toString(), elementUtils)).collect(Collectors.toList()));
            if (constraintValidatorClasses.isEmpty() && FALLBACK.containsKey(annotation.getAnnotationType().toString())) {
                constraintValidatorClasses.addAll(FALLBACK.get(annotation.getAnnotationType().toString()).stream().map(entry -> elementUtils.getTypeElement((CharSequence)entry) == null ? null : elementUtils.getTypeElement((CharSequence)entry).asType()).filter(Objects::nonNull).collect(Collectors.toList()));
            }
        }
        return constraintValidatorClasses;
    }

    private Map<String, Map.Entry<? extends ExecutableElement, ? extends AnnotationValue>> createAttributes(AnnotationMirror annotation, Elements elementUtils, Map<String, Map.Entry<? extends ExecutableElement, ? extends AnnotationValue>> overrideFromParent, Map<String, Map<String, Map.Entry<? extends ExecutableElement, ? extends AnnotationValue>>> overridesMap) {
        HashMap<String, Map.Entry<? extends ExecutableElement, ? extends AnnotationValue>> attributes = new HashMap<String, Map.Entry<? extends ExecutableElement, ? extends AnnotationValue>>();
        for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> element : elementUtils.getElementValuesWithDefaults(annotation).entrySet()) {
            String elementName = element.getKey().getSimpleName().toString();
            Optional<AnnotationMirror> override = TypeUtils.getMethod(annotation.getAnnotationType(), elementName).get().getAnnotationMirrors().stream().filter(mirror -> "jakarta.validation.OverridesAttribute".equals(((TypeElement)mirror.getAnnotationType().asElement()).getQualifiedName().toString())).findFirst();
            if (override.isPresent()) {
                String constraint = null;
                String name = null;
                for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> overrideElement : elementUtils.getElementValuesWithDefaults(override.get()).entrySet()) {
                    String overrideElementName = overrideElement.getKey().getSimpleName().toString();
                    if ("constraint".equals(overrideElementName)) {
                        constraint = overrideElement.getValue().getValue().toString();
                        continue;
                    }
                    if (!"name".equals(overrideElementName)) continue;
                    name = overrideElement.getValue().getValue().toString();
                }
                Map overrideEntry = (Map)ObjectUtils.defaultIfNull(overridesMap.get(constraint), new HashMap());
                overrideEntry.put(name, element);
                overridesMap.put(constraint, overrideEntry);
            }
            if (overrideFromParent == null || overrideFromParent.get(elementName) == null) {
                attributes.put(elementName, element);
                continue;
            }
            attributes.put(elementName, new AbstractMap.SimpleEntry<ExecutableElement, AnnotationValue>(element.getKey(), overrideFromParent.get(elementName).getValue()));
        }
        return attributes;
    }

    private Set<TypeMirror> createGroups(Map<String, Map.Entry<? extends ExecutableElement, ? extends AnnotationValue>> attributes, Elements elementUtils) {
        Set<TypeMirror> groups;
        if (CollectionUtils.isEmpty((Collection)((List)attributes.get("groups").getValue().getValue()))) {
            groups = new HashSet<TypeMirror>();
            groups.add(this.createTypeMirror(DEFAULT_GROUP, elementUtils));
        } else {
            groups = ((List)attributes.get("groups").getValue().getValue()).stream().map(group -> this.createTypeMirror(group.toString(), elementUtils)).collect(Collectors.toSet());
        }
        return groups;
    }

    public static List<TypeElementConstraintDescriptor<?>> createComposingConstraintsForElement(Element element, Elements elementUtils, ConstraintLocation.ConstraintLocationKind constraintLocationKind, Map<String, Map<String, Map.Entry<? extends ExecutableElement, ? extends AnnotationValue>>> overridesMap) {
        ArrayList composingConstraints = new ArrayList();
        for (AnnotationMirror annotationMirror : elementUtils.getAllAnnotationMirrors(element)) {
            for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry : annotationMirror.getElementValues().entrySet()) {
                String methodName = entry.getKey().getSimpleName().toString();
                if (!"value".equals(methodName) || !(entry.getValue().getValue() instanceof List)) continue;
                for (Object annotationMirror2 : (List)entry.getValue().getValue()) {
                    if (!(annotationMirror2 instanceof AnnotationMirror) || !TypeElementConstraintDescriptorImpl.filterConstraint((AnnotationMirror)annotationMirror2, CONSTRAINT).isPresent()) continue;
                    composingConstraints.add(new TypeElementConstraintDescriptorImpl((AnnotationMirror)annotationMirror2, elementUtils, constraintLocationKind, TypeElementConstraintDescriptorImpl.buildOverrides((AnnotationMirror)annotationMirror2, overridesMap)));
                }
            }
        }
        composingConstraints.addAll(element.getAnnotationMirrors().stream().filter(subannotation -> TypeElementConstraintDescriptorImpl.filterConstraint(subannotation, CONSTRAINT).isPresent()).map(subannotation -> new TypeElementConstraintDescriptorImpl((AnnotationMirror)subannotation, elementUtils, constraintLocationKind, (Map<String, Map.Entry<ExecutableElement, AnnotationValue>>)TypeElementConstraintDescriptorImpl.buildOverrides(subannotation, overridesMap))).collect(Collectors.toList()));
        return composingConstraints;
    }

    private static Map<String, Map.Entry<? extends ExecutableElement, ? extends AnnotationValue>> buildOverrides(AnnotationMirror annotation, Map<String, Map<String, Map.Entry<? extends ExecutableElement, ? extends AnnotationValue>>> overridesMap) {
        return overridesMap.get(annotation.getAnnotationType().toString());
    }

    private static Optional<? extends AnnotationMirror> filterConstraint(AnnotationMirror annotation, String className) {
        return annotation.getAnnotationType().asElement().getAnnotationMirrors().stream().filter(mirror -> className.equals(((TypeElement)mirror.getAnnotationType().asElement()).getQualifiedName().toString())).findAny();
    }

    private TypeMirror createTypeMirror(String name, Elements elementUtils) {
        TypeElement defaultGroup = elementUtils.getTypeElement(StringUtils.removeEnd((String)name, (String)".class"));
        if (defaultGroup == null) {
            return null;
        }
        return defaultGroup.asType();
    }

    @Override
    public T getAnnotation() {
        return (T)this.annotation;
    }

    @Override
    public Map<String, Map.Entry<? extends ExecutableElement, ? extends AnnotationValue>> getAttributes() {
        return this.attributes;
    }

    @Override
    public List<TypeElementConstraintDescriptor<?>> getComposingConstraints() {
        return this.composingConstraints;
    }

    @Override
    public List<TypeMirror> getConstraintValidatorClasses() {
        return this.constraintValidatorClasses;
    }

    @Override
    public Set<TypeMirror> getGroups() {
        return this.groups;
    }

    @Override
    public Set<TypeElement> getPayload() {
        return Collections.emptySet();
    }

    @Override
    public boolean isReportAsSingleViolation() {
        return this.reportAsSingleViolation;
    }

    @Override
    public ConstraintOrigin getDefinedOn() {
        return ConstraintOrigin.DEFINED_LOCALLY;
    }

    @Override
    public ConstraintLocation.ConstraintLocationKind getConstraintLocationKind() {
        return this.constraintLocationKind;
    }

    static {
        ClassLoader loader = TypeElementConstraintDescriptorImpl.class.getClassLoader();
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(loader.getResourceAsStream("validatorResolve.properties"), StandardCharsets.UTF_8));){
            FALLBACK = reader.lines().filter(StringUtils::isNotBlank).map(line -> StringUtils.split((String)line, (char)'=')).filter(array -> ((String[])array).length == 2).collect(Collectors.toMap(array -> array[0], array -> Arrays.asList(StringUtils.split((String)array[1], (char)','))));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

