/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.util.iterator;

import com.sqlapp.data.interval.Interval;
import com.sqlapp.util.iterator.AbstractObjectIterator;
import java.sql.Time;
import java.util.Date;

final class TimeIntervalIterator
extends AbstractObjectIterator<Time, Interval> {
    private static final long serialVersionUID = 1L;

    public TimeIntervalIterator(Time start, Time end, Interval step) {
        super(start, end, step);
    }

    @Override
    public boolean hasNext() {
        if (((Interval)this.step).isPositive()) {
            if (((Time)this.start).compareTo((Date)this.next) >= 0) {
                return false;
            }
            if (((Time)this.next).compareTo((Date)this.end) < 0) {
                return true;
            }
        } else {
            if (((Time)this.start).compareTo((Date)this.next) <= 0) {
                return false;
            }
            if (((Time)this.next).compareTo((Date)this.end) > 0) {
                return true;
            }
        }
        return false;
    }

    @Override
    protected Time getNext() {
        return ((Interval)this.step).add((Time)this.start, (int)this.count);
    }

    public TimeIntervalIterator clone() {
        TimeIntervalIterator clone = new TimeIntervalIterator((Time)this.start, (Time)this.end, (Interval)this.step);
        return clone;
    }
}

