/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.util.iterator;

import com.sqlapp.util.ToStringBuilder;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Iterator;

final class StringArrayIterator
implements Iterator<String>,
Serializable,
Cloneable {
    private static final long serialVersionUID = 1L;
    private final String[] args;
    private int pos = 0;

    public StringArrayIterator(String ... args) {
        assert (args != null);
        this.args = args;
    }

    @Override
    public boolean hasNext() {
        return this.pos < this.args.length;
    }

    @Override
    public String next() {
        if (this.hasNext()) {
            String val = this.args[this.pos];
            ++this.pos;
            return val;
        }
        return null;
    }

    @Override
    public void remove() {
    }

    public String toString() {
        ToStringBuilder builder = new ToStringBuilder(StringArrayIterator.class);
        builder.add(Arrays.toString(this.args));
        return builder.toString();
    }

    public int hashCode() {
        return Arrays.hashCode(this.args);
    }

    public StringArrayIterator clone() {
        StringArrayIterator clone = new StringArrayIterator(this.args);
        return clone;
    }
}

