/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.util.iterator;

import com.sqlapp.util.iterator.AbstractObjectIterator;
import java.time.OffsetTime;

final class OffsetTimeIterator
extends AbstractObjectIterator<OffsetTime, Integer> {
    private static final long serialVersionUID = 1L;

    public OffsetTimeIterator(OffsetTime start, OffsetTime end) {
        this(start, end, 3600);
    }

    public OffsetTimeIterator(OffsetTime start, OffsetTime end, Integer step) {
        super(start, end, step);
    }

    @Override
    public boolean hasNext() {
        if ((Integer)this.step > 0) {
            if (((OffsetTime)this.start).compareTo((OffsetTime)this.next) >= 0) {
                return false;
            }
            if (((OffsetTime)this.next).compareTo((OffsetTime)this.end) < 0) {
                return true;
            }
        } else {
            if (((OffsetTime)this.start).compareTo((OffsetTime)this.next) <= 0) {
                return false;
            }
            if (((OffsetTime)this.next).compareTo((OffsetTime)this.end) > 0) {
                return true;
            }
        }
        return false;
    }

    @Override
    protected OffsetTime getNext() {
        return ((OffsetTime)this.current).plusSeconds(((Integer)this.step).intValue());
    }

    public OffsetTimeIterator clone() {
        OffsetTimeIterator clone = new OffsetTimeIterator((OffsetTime)this.start, (OffsetTime)this.end, (Integer)this.step);
        return clone;
    }
}

