/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.util.iterator;

import com.sqlapp.data.interval.Interval;
import com.sqlapp.util.iterator.AbstractObjectIterator;
import java.time.LocalDate;
import java.time.chrono.ChronoLocalDate;

final class LocalDateIntervalIterator
extends AbstractObjectIterator<LocalDate, Interval> {
    private static final long serialVersionUID = 1L;

    public LocalDateIntervalIterator(LocalDate start, LocalDate end, Interval step) {
        super(start, end, step);
    }

    @Override
    public boolean hasNext() {
        if (((Interval)this.step).isPositive()) {
            return ((LocalDate)this.next).compareTo((ChronoLocalDate)this.end) < 0;
        }
        return ((LocalDate)this.next).compareTo((ChronoLocalDate)this.end) > 0;
    }

    @Override
    protected LocalDate getNext() {
        return ((Interval)this.step).add((LocalDate)this.start, (int)this.count);
    }

    public LocalDateIntervalIterator clone() {
        LocalDateIntervalIterator clone = new LocalDateIntervalIterator((LocalDate)this.start, (LocalDate)this.end, (Interval)this.step);
        return clone;
    }
}

