/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.util.iterator;

import com.sqlapp.data.interval.Interval;
import com.sqlapp.util.iterator.CalendarIntervalIterator;
import com.sqlapp.util.iterator.CalendarIterator;
import com.sqlapp.util.iterator.DateIntervalIterator;
import com.sqlapp.util.iterator.DateIterator;
import com.sqlapp.util.iterator.InstantIntervalIterator;
import com.sqlapp.util.iterator.InstantIterator;
import com.sqlapp.util.iterator.IntegerIterator;
import com.sqlapp.util.iterator.LocalDateIntervalIterator;
import com.sqlapp.util.iterator.LocalDateIterator;
import com.sqlapp.util.iterator.LocalDateTimeIntervalIterator;
import com.sqlapp.util.iterator.LocalDateTimeIterator;
import com.sqlapp.util.iterator.LocalTimeIntervalIterator;
import com.sqlapp.util.iterator.LocalTimeIterator;
import com.sqlapp.util.iterator.LongIterator;
import com.sqlapp.util.iterator.ObjectIterable;
import com.sqlapp.util.iterator.OffsetDateTimeIntervalIterator;
import com.sqlapp.util.iterator.OffsetDateTimeIterator;
import com.sqlapp.util.iterator.OffsetTimeIntervalIterator;
import com.sqlapp.util.iterator.OffsetTimeIterator;
import com.sqlapp.util.iterator.SqlDateIterator;
import com.sqlapp.util.iterator.StringArrayIterator;
import com.sqlapp.util.iterator.TimeIntervalIterator;
import com.sqlapp.util.iterator.TimeIterator;
import com.sqlapp.util.iterator.TimestampIntervalIterator;
import com.sqlapp.util.iterator.TimestampIterator;
import com.sqlapp.util.iterator.ZonedDateTimeIntervalIterator;
import com.sqlapp.util.iterator.ZonedDateTimeIterator;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.ZonedDateTime;
import java.util.Calendar;

public class Iterators {
    public static Iterable<Integer> range(int size) {
        return new ObjectIterable<Integer>(new IntegerIterator(size));
    }

    public static Iterable<Long> range(long size) {
        return new ObjectIterable<Long>(new LongIterator(size));
    }

    public static Iterable<Integer> range(int start, int end) {
        return new ObjectIterable<Integer>(new IntegerIterator(start, end));
    }

    public static ObjectIterable<Long> range(long start, long end) {
        return new ObjectIterable<Long>(new LongIterator(start, end));
    }

    public static Iterable<Integer> range(int start, int end, int step) {
        return new ObjectIterable<Integer>(new IntegerIterator(start, end, step));
    }

    public static Iterable<Long> range(long start, long end, long step) {
        return new ObjectIterable<Long>(new LongIterator(start, end, step));
    }

    public static Iterable<Calendar> range(Calendar start, Calendar end) {
        return new ObjectIterable<Calendar>(new CalendarIterator(start, end, 86400));
    }

    public static Iterable<java.util.Date> range(java.util.Date start, java.util.Date end) {
        return new ObjectIterable<java.util.Date>(new DateIterator(start, end, 86400));
    }

    public static Iterable<Date> range(Date start, Date end) {
        return new ObjectIterable<Date>(new SqlDateIterator(start, end, 86400));
    }

    public static Iterable<java.util.Date> range(java.util.Date start, java.util.Date end, int step) {
        return new ObjectIterable<java.util.Date>(new DateIterator(start, end, step));
    }

    public static Iterable<Date> range(Date start, Date end, int step) {
        return new ObjectIterable<Date>(new SqlDateIterator(start, end, step));
    }

    public static Iterable<Calendar> range(Calendar start, Calendar end, int step) {
        return new ObjectIterable<Calendar>(new CalendarIterator(start, end, step));
    }

    public static Iterable<Calendar> range(Calendar start, Calendar end, Interval interval) {
        return new ObjectIterable<Calendar>(new CalendarIntervalIterator(start, end, interval));
    }

    public static Iterable<java.util.Date> range(java.util.Date start, java.util.Date end, Interval interval) {
        return new ObjectIterable<java.util.Date>(new DateIntervalIterator(start, end, interval));
    }

    public static Iterable<ZonedDateTime> range(ZonedDateTime start, ZonedDateTime end) {
        return new ObjectIterable<ZonedDateTime>(new ZonedDateTimeIterator(start, end));
    }

    public static Iterable<ZonedDateTime> range(ZonedDateTime start, ZonedDateTime end, int step) {
        return new ObjectIterable<ZonedDateTime>(new ZonedDateTimeIterator(start, end, step));
    }

    public static Iterable<ZonedDateTime> range(ZonedDateTime start, ZonedDateTime end, Interval interval) {
        return new ObjectIterable<ZonedDateTime>(new ZonedDateTimeIntervalIterator(start, end, interval));
    }

    public static Iterable<OffsetDateTime> range(OffsetDateTime start, OffsetDateTime end) {
        return new ObjectIterable<OffsetDateTime>(new OffsetDateTimeIterator(start, end));
    }

    public static Iterable<OffsetDateTime> range(OffsetDateTime start, OffsetDateTime end, int step) {
        return new ObjectIterable<OffsetDateTime>(new OffsetDateTimeIterator(start, end, step));
    }

    public static Iterable<OffsetDateTime> range(OffsetDateTime start, OffsetDateTime end, Interval interval) {
        return new ObjectIterable<OffsetDateTime>(new OffsetDateTimeIntervalIterator(start, end, interval));
    }

    public static Iterable<OffsetTime> range(OffsetTime start, OffsetTime end) {
        return new ObjectIterable<OffsetTime>(new OffsetTimeIterator(start, end));
    }

    public static Iterable<OffsetTime> range(OffsetTime start, OffsetTime end, int step) {
        return new ObjectIterable<OffsetTime>(new OffsetTimeIterator(start, end, step));
    }

    public static Iterable<OffsetTime> range(OffsetTime start, OffsetTime end, Interval interval) {
        return new ObjectIterable<OffsetTime>(new OffsetTimeIntervalIterator(start, end, interval));
    }

    public static Iterable<LocalDateTime> range(LocalDateTime start, LocalDateTime end) {
        return new ObjectIterable<LocalDateTime>(new LocalDateTimeIterator(start, end));
    }

    public static Iterable<LocalDateTime> range(LocalDateTime start, LocalDateTime end, int step) {
        return new ObjectIterable<LocalDateTime>(new LocalDateTimeIterator(start, end, step));
    }

    public static Iterable<LocalDateTime> range(LocalDateTime start, LocalDateTime end, Interval interval) {
        return new ObjectIterable<LocalDateTime>(new LocalDateTimeIntervalIterator(start, end, interval));
    }

    public static Iterable<Instant> range(Instant start, Instant end) {
        return new ObjectIterable<Instant>(new InstantIterator(start, end));
    }

    public static Iterable<Instant> range(Instant start, Instant end, int step) {
        return new ObjectIterable<Instant>(new InstantIterator(start, end, step));
    }

    public static Iterable<Instant> range(Instant start, Instant end, Interval interval) {
        return new ObjectIterable<Instant>(new InstantIntervalIterator(start, end, interval));
    }

    public static Iterable<LocalDate> range(LocalDate start, LocalDate end) {
        return new ObjectIterable<LocalDate>(new LocalDateIterator(start, end));
    }

    public static Iterable<LocalDate> range(LocalDate start, LocalDate end, int step) {
        return new ObjectIterable<LocalDate>(new LocalDateIterator(start, end, step));
    }

    public static Iterable<LocalDate> range(LocalDate start, LocalDate end, Interval interval) {
        return new ObjectIterable<LocalDate>(new LocalDateIntervalIterator(start, end, interval));
    }

    public static Iterable<LocalTime> range(LocalTime start, LocalTime end) {
        return new ObjectIterable<LocalTime>(new LocalTimeIterator(start, end));
    }

    public static Iterable<LocalTime> range(LocalTime start, LocalTime end, int step) {
        return new ObjectIterable<LocalTime>(new LocalTimeIterator(start, end, step));
    }

    public static Iterable<LocalTime> range(LocalTime start, LocalTime end, Interval interval) {
        return new ObjectIterable<LocalTime>(new LocalTimeIntervalIterator(start, end, interval));
    }

    public static Iterable<Timestamp> range(Timestamp start, Timestamp end) {
        return new ObjectIterable<Timestamp>(new TimestampIterator(start, end));
    }

    public static Iterable<Timestamp> range(Timestamp start, Timestamp end, int step) {
        return new ObjectIterable<Timestamp>(new TimestampIterator(start, end, step));
    }

    public static Iterable<Timestamp> range(Timestamp start, Timestamp end, Interval interval) {
        return new ObjectIterable<Timestamp>(new TimestampIntervalIterator(start, end, interval));
    }

    public static Iterable<Time> range(Time start, Time end) {
        return new ObjectIterable<Time>(new TimeIterator(start, end, 3600));
    }

    public static Iterable<Time> range(Time start, Time end, int step) {
        return new ObjectIterable<Time>(new TimeIterator(start, end, step));
    }

    public static Iterable<Time> range(Time start, Time end, Interval interval) {
        return new ObjectIterable<Time>(new TimeIntervalIterator(start, end, interval));
    }

    public static Iterable<String> range(String ... args) {
        return new ObjectIterable<String>(new StringArrayIterator(args));
    }
}

