/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.util.iterator;

import com.sqlapp.util.ToStringBuilder;
import java.io.Serializable;
import java.util.Iterator;

final class IntegerIterator
implements Iterator<Integer>,
Serializable,
Cloneable {
    private static final long serialVersionUID = 1L;
    private final int start;
    private final int end;
    private final int step;
    private int current = 0;
    private boolean first = true;

    public IntegerIterator(int end) {
        this(0, end, 1);
    }

    public IntegerIterator(int start, int end) {
        this(start, end, 1);
    }

    public IntegerIterator(int start, int end, int step) {
        assert (step != 0);
        assert (start < end && step > 0 || start > end && step < 0);
        this.start = start;
        this.end = end;
        this.step = step;
        this.current = start;
    }

    @Override
    public boolean hasNext() {
        if (this.step > 0) {
            return this.current + this.step < this.end;
        }
        return this.current + this.step > this.end;
    }

    @Override
    public Integer next() {
        if (this.first) {
            this.first = false;
            return this.current;
        }
        this.current += this.step;
        return this.current;
    }

    @Override
    public void remove() {
    }

    public String toString() {
        ToStringBuilder builder = new ToStringBuilder(IntegerIterator.class);
        builder.add("start", this.start);
        builder.add("end", this.end);
        builder.add("step", this.step);
        builder.add("current", this.current);
        return builder.toString();
    }

    public int hashCode() {
        return this.start ^ this.end ^ this.step ^ this.current;
    }

    public IntegerIterator clone() {
        IntegerIterator clone = new IntegerIterator(this.start, this.end, this.step);
        return clone;
    }
}

