/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.util.iterator;

import com.sqlapp.data.interval.Interval;
import com.sqlapp.util.iterator.AbstractObjectIterator;
import java.time.Instant;

final class InstantIntervalIterator
extends AbstractObjectIterator<Instant, Interval> {
    private static final long serialVersionUID = 1L;

    public InstantIntervalIterator(Instant start, Instant end, Interval step) {
        super(start, end, step);
    }

    @Override
    public boolean hasNext() {
        if (((Interval)this.step).isPositive()) {
            return ((Instant)this.next).compareTo((Instant)this.end) < 0;
        }
        return ((Instant)this.next).compareTo((Instant)this.end) > 0;
    }

    @Override
    protected Instant getNext() {
        return ((Interval)this.step).add((Instant)this.start, (int)this.count);
    }

    public InstantIntervalIterator clone() {
        InstantIntervalIterator clone = new InstantIntervalIterator((Instant)this.start, (Instant)this.end, (Interval)this.step);
        return clone;
    }
}

