/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.util.iterator;

import com.sqlapp.util.DateUtils;
import com.sqlapp.util.iterator.AbstractObjectIterator;
import java.util.Date;

final class DateIterator
extends AbstractObjectIterator<Date, Integer> {
    private static final long serialVersionUID = 1L;

    public DateIterator(Date start, Date end) {
        this(start, end, 86400);
    }

    public DateIterator(Date start, Date end, Integer step) {
        super(start, end, step);
    }

    @Override
    public boolean hasNext() {
        if ((Integer)this.step > 0) {
            return ((Date)this.next).compareTo((Date)this.end) < 0;
        }
        return ((Date)this.next).compareTo((Date)this.end) > 0;
    }

    @Override
    protected Date getNext() {
        return DateUtils.addSeconds((Date)this.current, (int)((Integer)this.step));
    }

    public DateIterator clone() {
        DateIterator clone = new DateIterator((Date)this.start, (Date)this.end, (Integer)this.step);
        return clone;
    }
}

