/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.util.file;

import com.sqlapp.data.schemas.Row;
import com.sqlapp.data.schemas.RowIteratorHandler;
import com.sqlapp.data.schemas.Table;
import com.sqlapp.util.FileUtils;
import com.sqlapp.util.file.AbstractFixedByteLength;
import com.sqlapp.util.file.FixedByteLengthFileSetting;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.function.Consumer;

public class FixedByteLengthWriter
extends AbstractFixedByteLength
implements AutoCloseable {
    private final BufferedOutputStream bos;
    private final byte[] buffer;
    private final FixedByteLengthFileSetting setting;

    public FixedByteLengthWriter(File file, Charset charset, Consumer<FixedByteLengthFileSetting> cons) {
        super(new FixedByteLengthFileSetting(), charset, cons);
        this.bos = FixedByteLengthWriter.toBufferedOutputStream(file);
        this.setting = this.getCharsetSetting().clone();
        this.buffer = this.setting.createBuffer();
    }

    public FixedByteLengthWriter(File file, Charset charset, Table table, Consumer<FixedByteLengthFileSetting> cons, Consumer<FixedByteLengthFileSetting.FixedByteLengthFieldSetting> fieldCons) {
        super(new FixedByteLengthFileSetting(), charset, table, cons, fieldCons);
        this.bos = FixedByteLengthWriter.toBufferedOutputStream(file);
        this.setting = this.getCharsetSetting().clone();
        this.buffer = this.setting.createBuffer();
    }

    public FixedByteLengthWriter(File file, Charset charset, Table table, Consumer<FixedByteLengthFileSetting> cons) {
        super(new FixedByteLengthFileSetting(), charset, table, cons);
        this.bos = FixedByteLengthWriter.toBufferedOutputStream(file);
        this.setting = this.getCharsetSetting().clone();
        this.buffer = this.setting.createBuffer();
    }

    public FixedByteLengthWriter(OutputStream os, Charset charset) {
        super(new FixedByteLengthFileSetting(), charset, (FixedByteLengthFileSetting setting) -> {});
        this.bos = FixedByteLengthWriter.toBufferedOutputStream(os);
        this.setting = this.getCharsetSetting().clone();
        this.buffer = this.setting.createBuffer();
    }

    public FixedByteLengthWriter(OutputStream os, Charset charset, Table table, Consumer<FixedByteLengthFileSetting> cons, Consumer<FixedByteLengthFileSetting.FixedByteLengthFieldSetting> fieldCons) {
        super(new FixedByteLengthFileSetting(), charset, table, cons, fieldCons);
        this.bos = FixedByteLengthWriter.toBufferedOutputStream(os);
        this.setting = this.getCharsetSetting().clone();
        this.buffer = this.setting.createBuffer();
    }

    public FixedByteLengthWriter(OutputStream os, Charset charset, Table table, Consumer<FixedByteLengthFileSetting> cons) {
        super(new FixedByteLengthFileSetting(), charset, table, cons);
        this.bos = FixedByteLengthWriter.toBufferedOutputStream(os);
        this.setting = this.getCharsetSetting().clone();
        this.buffer = this.setting.createBuffer();
    }

    public FixedByteLengthWriter(File file, String charset) {
        super(new FixedByteLengthFileSetting(), Charset.forName(charset), (FixedByteLengthFileSetting setting) -> {});
        this.bos = FixedByteLengthWriter.toBufferedOutputStream(file);
        this.setting = this.getCharsetSetting().clone();
        this.buffer = this.setting.createBuffer();
    }

    public FixedByteLengthWriter(OutputStream os, String charset) {
        super(new FixedByteLengthFileSetting(), Charset.forName(charset), (FixedByteLengthFileSetting setting) -> {});
        this.bos = FixedByteLengthWriter.toBufferedOutputStream(os);
        this.setting = this.getCharsetSetting().clone();
        this.buffer = this.setting.createBuffer();
    }

    private static BufferedOutputStream toBufferedOutputStream(File file) {
        try {
            return new BufferedOutputStream(new FileOutputStream(file));
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    private static BufferedOutputStream toBufferedOutputStream(OutputStream os) {
        if (os instanceof BufferedOutputStream) {
            return (BufferedOutputStream)os;
        }
        return new BufferedOutputStream(os);
    }

    public void writeRow(byte[] arg) throws IOException {
        this.bos.write(arg);
    }

    public void writeRow(Row row) throws IOException {
        this.setting.setByteRow(row, this.buffer);
        this.writeRow(this.buffer);
    }

    public void write(Table table, RowIteratorHandler rowIteratorHandler) throws IOException {
        for (Row row : table.getRows(rowIteratorHandler)) {
            this.setting.setByteRow(row, this.buffer);
            this.writeRow(this.buffer);
        }
    }

    public void write(Table table) throws IOException {
        for (Row row : table.getRows()) {
            this.setting.setByteRow(row, this.buffer);
            this.writeRow(this.buffer);
        }
    }

    @Override
    public void close() {
        FileUtils.close(this.bos);
    }
}

