/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.util.file;

import com.sqlapp.data.converter.Converter;
import com.sqlapp.data.db.datatype.DataType;
import com.sqlapp.data.schemas.Column;
import com.sqlapp.data.schemas.ColumnCollection;
import com.sqlapp.data.schemas.Row;
import com.sqlapp.data.schemas.Table;
import com.sqlapp.util.CommonUtils;
import com.sqlapp.util.PaddingType;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Collectors;

public class FixedByteLengthFileSetting
implements Serializable,
Cloneable {
    private static final long serialVersionUID = -8457129568589208110L;
    private static final FixedByteLengthFieldSetting[] ENPTY_FIELDS = new FixedByteLengthFieldSetting[0];
    private PaddingType paddingType;
    private String padding = " ";
    private String lineBreak = "\n";
    private byte[] paddingBytes;
    private byte[] lineBreakBytes;
    private final String separator = "";
    private byte[] separatorBytes;
    private Charset charset;
    private int bufferSize = 0;
    private Map<String, FixedByteLengthFieldSetting> fixedByteLengthFieldMap = CommonUtils.caseInsensitiveLinkedMap();
    private FixedByteLengthFieldSetting[] fixedByteLengthFields = ENPTY_FIELDS;
    private Table table;

    public FixedByteLengthFileSetting clone() {
        FixedByteLengthFileSetting clone;
        try {
            clone = (FixedByteLengthFileSetting)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
        clone.fixedByteLengthFieldMap = CommonUtils.caseInsensitiveLinkedMap();
        clone.fixedByteLengthFields = new FixedByteLengthFieldSetting[this.fixedByteLengthFields.length];
        for (int i = 0; i < clone.fixedByteLengthFields.length; ++i) {
            clone.fixedByteLengthFields[i] = this.fixedByteLengthFields[i].clone();
            clone.fixedByteLengthFieldMap.put(clone.fixedByteLengthFields[i].getName(), clone.fixedByteLengthFields[i]);
        }
        return clone;
    }

    public void addField(String fieldName, Consumer<FixedByteLengthFieldSetting> cons) {
        FixedByteLengthFieldSetting field = new FixedByteLengthFieldSetting();
        field.setName(fieldName);
        cons.accept(field);
        this.fixedByteLengthFieldMap.put(fieldName, field);
        List<FixedByteLengthFieldSetting> list = this.fixedByteLengthFieldMap.entrySet().stream().map(e -> (FixedByteLengthFieldSetting)e.getValue()).collect(Collectors.toList());
        this.fixedByteLengthFields = list.toArray(new FixedByteLengthFieldSetting[0]);
    }

    public void addField(Column column, Consumer<FixedByteLengthFieldSetting> cons) {
        this.addField(column.getName(), (FixedByteLengthFieldSetting field) -> {
            if (this.table == null) {
                this.table = column.getTable();
            }
            if (this.table != null && this.table != column.getTable()) {
                throw new IllegalArgumentException("Multiple table does not support.");
            }
            field.setColumn(column);
            if (column.getLength() != null) {
                field.setLength(column.getLength().intValue());
            }
            if (column.getDataType() != null && column.getDataType().isCharacter()) {
                field.setPaddingType(PaddingType.RIGHT);
                field.setPadding(" ");
            } else if (column.getDataType() == DataType.UUID) {
                field.setPaddingType(PaddingType.RIGHT);
                field.setLength(36);
            } else if (column.getDataType() != null && column.getDataType().isDateTime()) {
                field.setPaddingType(PaddingType.RIGHT);
                if (column.getDataType() == DataType.DATE) {
                    field.setLength(10);
                } else if (column.getDataType() == DataType.DATETIME) {
                    field.setLength(19);
                }
            } else if (column.getDataType() != null && column.getDataType().isNumeric()) {
                if (column.getDataType() == DataType.UBIGINT) {
                    field.setLength(20);
                } else if (column.getDataType() == DataType.BIGINT || column.getDataType() == DataType.BIGSERIAL) {
                    field.setLength(19);
                } else if (column.getDataType() == DataType.INT || column.getDataType() == DataType.UINT || column.getDataType() == DataType.SERIAL) {
                    field.setLength(10);
                } else if (column.getDataType() == DataType.MEDIUMINT || column.getDataType() == DataType.UMEDIUMINT) {
                    field.setLength(8);
                } else if (column.getDataType() == DataType.USMALLINT) {
                    field.setLength(6);
                } else if (column.getDataType() == DataType.SMALLINT) {
                    field.setLength(5);
                } else if (column.getDataType() == DataType.TINYINT) {
                    field.setLength(3);
                } else if (column.getDataType() == DataType.BOOLEAN || column.getDataType() == DataType.BIT) {
                    field.setLength(1);
                }
                field.setPaddingType(PaddingType.LEFT);
                field.setPadding(" ");
            }
            field.setConverter(column.getConverter());
            cons.accept((FixedByteLengthFieldSetting)field);
        });
    }

    public void addField(Table table, Consumer<FixedByteLengthFieldSetting> cons) {
        this.table = table;
        for (Column column : table.getColumns()) {
            this.addField(column, cons);
        }
    }

    public void addField(ColumnCollection columns, Consumer<FixedByteLengthFieldSetting> cons) {
        for (Column column : columns) {
            this.addField(column, cons);
        }
    }

    protected void initialize(Charset charset) {
        int len = 0;
        this.charset = charset;
        this.paddingBytes = this.padding.getBytes(charset);
        this.separatorBytes = this.separator.getBytes(charset);
        this.lineBreakBytes = this.lineBreak.getBytes(charset);
        boolean first = true;
        for (FixedByteLengthFieldSetting fieldSetting : this.fixedByteLengthFields) {
            if (fieldSetting.getLength() == 0) continue;
            if (!first) {
                len += this.separatorBytes.length;
            }
            fieldSetting.paddingBytes = fieldSetting.padding != null ? fieldSetting.padding.getBytes(charset) : this.paddingBytes;
            len += fieldSetting.length;
            first = false;
        }
        if (!CommonUtils.isEmpty(this.lineBreak)) {
            len += this.lineBreakBytes.length;
        }
        this.bufferSize = len;
    }

    public byte[] createBuffer() {
        return new byte[this.bufferSize];
    }

    protected Row toRow(byte[] buffer) {
        int position = 0;
        Row row = this.table.newRow();
        boolean first = true;
        for (int i = 0; i < this.fixedByteLengthFields.length; ++i) {
            FixedByteLengthFieldSetting fieldSetting = this.fixedByteLengthFields[i];
            if (fieldSetting.getLength() == 0) continue;
            if (!first) {
                position += this.separatorBytes.length;
            }
            String text = fieldSetting.paddingType.toString(buffer, position, fieldSetting.length, fieldSetting.paddingBytes, this.charset);
            Object obj = fieldSetting.getConverter().convertObject(text);
            row.put(fieldSetting.column, obj);
            position += fieldSetting.length;
            first = false;
        }
        return row;
    }

    protected void setByteRow(Row row, byte[] buffer) {
        int position = 0;
        boolean first = true;
        for (int i = 0; i < this.fixedByteLengthFields.length; ++i) {
            FixedByteLengthFieldSetting fieldSetting = this.fixedByteLengthFields[i];
            if (fieldSetting.getLength() == 0) continue;
            if (!first) {
                this.arraycopy(this.separatorBytes, 0, buffer, position, this.separatorBytes.length);
                position += this.separatorBytes.length;
            }
            if (fieldSetting.getLength() == 0) continue;
            Object value = row.get(fieldSetting.getColumn());
            String text = fieldSetting.getConverter().convertString(value);
            byte[] bytes = text.getBytes(this.charset);
            fieldSetting.paddingType.setBytes(bytes, fieldSetting.paddingBytes, position, fieldSetting.length, buffer);
            position += fieldSetting.length;
            first = false;
        }
        this.arraycopy(this.lineBreakBytes, 0, buffer, position, this.lineBreakBytes.length);
    }

    private void arraycopy(byte[] src, int srcPos, byte[] dest, int destPos, int length) {
        PaddingType.arraycopy(src, srcPos, dest, destPos, length);
    }

    protected boolean isLineBreak(byte[] bytes, int size) {
        if (this.lineBreakBytes.length == 0) {
            return false;
        }
        if (size != this.lineBreakBytes.length) {
            return false;
        }
        for (int i = 0; i < this.lineBreakBytes.length; ++i) {
            if (bytes[i] == this.lineBreakBytes[i]) continue;
            return false;
        }
        return true;
    }

    public String getLineBreak() {
        return this.lineBreak;
    }

    public void setLineBreak(String lineBreak) {
        this.lineBreak = lineBreak;
    }

    public PaddingType getPaddingType() {
        return this.paddingType;
    }

    public void setPaddingType(PaddingType paddingType) {
        this.paddingType = paddingType;
    }

    public String getPadding() {
        return this.padding;
    }

    public void setPadding(String padding) {
        this.padding = padding;
    }

    protected Map<String, FixedByteLengthFieldSetting> getFixedByteLengthFieldMap() {
        return this.fixedByteLengthFieldMap;
    }

    protected FixedByteLengthFieldSetting[] getFixedByteLengthFields() {
        return this.fixedByteLengthFields;
    }

    public static class FixedByteLengthFieldSetting
    implements Serializable,
    Cloneable {
        private static final long serialVersionUID = -4720756606761967798L;
        private String name;
        private int length;
        private PaddingType paddingType;
        private String padding;
        private byte[] paddingBytes;
        private Converter<?> converter;
        private Column column;

        public FixedByteLengthFieldSetting clone() {
            try {
                return (FixedByteLengthFieldSetting)super.clone();
            }
            catch (CloneNotSupportedException e) {
                throw new RuntimeException(e);
            }
        }

        public String getName() {
            return this.name;
        }

        public int getLength() {
            return this.length;
        }

        public PaddingType getPaddingType() {
            return this.paddingType;
        }

        public String getPadding() {
            return this.padding;
        }

        public byte[] getPaddingBytes() {
            return this.paddingBytes;
        }

        public Converter<?> getConverter() {
            return this.converter;
        }

        public Column getColumn() {
            return this.column;
        }

        public void setName(String name) {
            this.name = name;
        }

        public void setLength(int length) {
            this.length = length;
        }

        public void setPaddingType(PaddingType paddingType) {
            this.paddingType = paddingType;
        }

        public void setPadding(String padding) {
            this.padding = padding;
        }

        public void setPaddingBytes(byte[] paddingBytes) {
            this.paddingBytes = paddingBytes;
        }

        public void setConverter(Converter<?> converter) {
            this.converter = converter;
        }

        public void setColumn(Column column) {
            this.column = column;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof FixedByteLengthFieldSetting)) {
                return false;
            }
            FixedByteLengthFieldSetting other = (FixedByteLengthFieldSetting)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getLength() != other.getLength()) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            PaddingType this$paddingType = this.getPaddingType();
            PaddingType other$paddingType = other.getPaddingType();
            if (this$paddingType == null ? other$paddingType != null : !((Object)((Object)this$paddingType)).equals((Object)other$paddingType)) {
                return false;
            }
            String this$padding = this.getPadding();
            String other$padding = other.getPadding();
            if (this$padding == null ? other$padding != null : !this$padding.equals(other$padding)) {
                return false;
            }
            if (!Arrays.equals(this.getPaddingBytes(), other.getPaddingBytes())) {
                return false;
            }
            Converter<?> this$converter = this.getConverter();
            Converter<?> other$converter = other.getConverter();
            if (this$converter == null ? other$converter != null : !this$converter.equals(other$converter)) {
                return false;
            }
            Column this$column = this.getColumn();
            Column other$column = other.getColumn();
            return !(this$column == null ? other$column != null : !((Object)this$column).equals(other$column));
        }

        protected boolean canEqual(Object other) {
            return other instanceof FixedByteLengthFieldSetting;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getLength();
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            PaddingType $paddingType = this.getPaddingType();
            result = result * 59 + ($paddingType == null ? 43 : ((Object)((Object)$paddingType)).hashCode());
            String $padding = this.getPadding();
            result = result * 59 + ($padding == null ? 43 : $padding.hashCode());
            result = result * 59 + Arrays.hashCode(this.getPaddingBytes());
            Converter<?> $converter = this.getConverter();
            result = result * 59 + ($converter == null ? 43 : $converter.hashCode());
            Column $column = this.getColumn();
            result = result * 59 + ($column == null ? 43 : ((Object)$column).hashCode());
            return result;
        }

        public String toString() {
            return "FixedByteLengthFileSetting.FixedByteLengthFieldSetting(name=" + this.getName() + ", length=" + this.getLength() + ", paddingType=" + this.getPaddingType() + ", padding=" + this.getPadding() + ", paddingBytes=" + Arrays.toString(this.getPaddingBytes()) + ", converter=" + this.getConverter() + ", column=" + this.getColumn() + ")";
        }
    }
}

