/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.util.file;

import com.sqlapp.util.FileUtils;
import com.univocity.parsers.common.AbstractParser;
import com.univocity.parsers.common.ArgumentUtils;
import com.univocity.parsers.common.CommonParserSettings;
import com.univocity.parsers.common.record.Record;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;

public abstract class AbstractFileParser<T extends AbstractParser<?>, S extends CommonParserSettings<?>>
implements AutoCloseable {
    private final T parser;
    private final Reader reader;
    private boolean startParsing = false;
    private long lineNumber = 0L;

    AbstractFileParser(S settings, Consumer<S> settingConsumer, Function<S, T> parserFunction, Reader reader) {
        settingConsumer.accept(settings);
        this.parser = (AbstractParser)parserFunction.apply(settings);
        this.reader = this.wrap(reader);
    }

    AbstractFileParser(S settings, Consumer<S> settingConsumer, Function<S, T> parserFunction, File file, Charset charset) {
        settingConsumer.accept(settings);
        this.parser = (AbstractParser)parserFunction.apply(settings);
        this.reader = this.wrap(ArgumentUtils.newReader((File)file, (Charset)charset));
    }

    AbstractFileParser(S settings, Consumer<S> settingConsumer, Function<S, T> parserFunction, File file, String charset) {
        settingConsumer.accept(settings);
        this.parser = (AbstractParser)parserFunction.apply(settings);
        this.reader = this.wrap(ArgumentUtils.newReader((File)file, (String)charset));
    }

    AbstractFileParser(S settings, Consumer<S> settingConsumer, Function<S, T> parserFunction, InputStream is, Charset charset) {
        settingConsumer.accept(settings);
        this.parser = (AbstractParser)parserFunction.apply(settings);
        this.reader = this.wrap(ArgumentUtils.newReader((InputStream)is, (Charset)charset));
    }

    AbstractFileParser(S settings, Consumer<S> settingConsumer, Function<S, T> parserFunction, InputStream is, String charset) {
        settingConsumer.accept(settings);
        this.parser = (AbstractParser)parserFunction.apply(settings);
        this.reader = this.wrap(ArgumentUtils.newReader((InputStream)is, (String)charset));
    }

    private Reader wrap(Reader reader) {
        if (reader instanceof BufferedReader) {
            return reader;
        }
        return new BufferedReader(reader);
    }

    public void beginParsing() {
        if (!this.startParsing) {
            this.parser.beginParsing(this.reader);
        }
        this.startParsing = true;
    }

    public String[] parseNext() {
        ++this.lineNumber;
        return this.parser.parseNext();
    }

    public Record parseNextRecord() {
        ++this.lineNumber;
        return this.parser.parseNextRecord();
    }

    public long getLineNumber() {
        return this.lineNumber;
    }

    public void readAll(BiConsumer<String[], Long> cons) throws IOException {
        String[] row;
        this.beginParsing();
        long i = 0L;
        while ((row = this.parser.parseNext()) != null) {
            cons.accept(row, i++);
        }
    }

    public void readAllRecord(BiConsumer<Record, Long> cons) throws IOException {
        this.beginParsing();
        long i = 0L;
        for (Record record : this.parser.iterateRecords(this.reader)) {
            cons.accept(record, i++);
        }
    }

    protected void initialize(S settings) {
        settings.setMaxCharsPerColumn(8192);
    }

    @Override
    public void close() {
        FileUtils.close(this.reader);
        this.parser.stopParsing();
    }
}

