/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.util.eval.script;

import com.sqlapp.data.converter.Converters;
import com.sqlapp.data.parameter.ParametersContext;
import com.sqlapp.util.eval.AbstractEvalExecutor;
import java.util.HashMap;
import java.util.Map;
import javax.script.Bindings;
import javax.script.Compilable;
import javax.script.CompiledScript;
import javax.script.ScriptEngine;
import javax.script.ScriptException;

public class ScriptEvaluator
extends AbstractEvalExecutor {
    private ScriptEngine engine = null;
    private CompiledScript compiledScript = null;

    public ScriptEvaluator(String expression, ScriptEngine engine) {
        super(expression);
        this.engine = engine;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CompiledScript getCompiledScript() {
        if (this.compiledScript == null) {
            ScriptEvaluator scriptEvaluator = this;
            synchronized (scriptEvaluator) {
                if (this.getEngine() instanceof Compilable) {
                    Compilable compilableEngile = (Compilable)((Object)this.engine);
                    try {
                        this.compiledScript = compilableEngile.compile(this.getExpression());
                    }
                    catch (ScriptException e) {
                        throw new RuntimeException(e);
                    }
                }
            }
        }
        return this.compiledScript;
    }

    public ScriptEngine getEngine() {
        return this.engine;
    }

    @Override
    public Object doEval(ParametersContext bindings) throws ScriptException {
        Object result = null;
        result = this.getCompiledScript() != null ? this.getCompiledScript().eval(bindings) : this.engine.eval(this.getExpression(), (Bindings)bindings);
        return result;
    }

    @Override
    public <T> T doEval(ParametersContext bindings, Class<T> clazz) throws ScriptException {
        T val = Converters.getDefault().convertObject(this.doEval(bindings), clazz);
        return val;
    }

    @Override
    public boolean doEvalBoolean(ParametersContext bindings) throws ScriptException {
        return (Boolean)this.doEval(bindings);
    }

    @Override
    public Object doEval(Object val) throws ScriptException {
        if (val instanceof Bindings) {
            return this.evalScript((Bindings)val);
        }
        if (val instanceof Map) {
            BindingsMap bMap = new BindingsMap();
            bMap.putAll((Map)val);
            return this.evalScript(bMap);
        }
        throw new UnsupportedOperationException("ScriptEvaluator.eval(val)");
    }

    private Object evalScript(Bindings val) throws ScriptException {
        return this.engine.eval(this.getExpression(), val);
    }

    @Override
    public boolean doEvalBoolean(Object val) throws ScriptException {
        return (Boolean)this.doEval(val);
    }

    static class BindingsMap
    extends HashMap<String, Object>
    implements Bindings {
        private static final long serialVersionUID = -6082931365315111168L;

        BindingsMap() {
        }
    }
}

