/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.util.eval.mvel;

import com.sqlapp.util.CommonUtils;
import com.sqlapp.util.DateUtils;
import com.sqlapp.util.eval.mvel.MvelUtils;
import com.sqlapp.util.iterator.Iterators;
import java.lang.reflect.Method;
import java.util.List;
import org.mvel2.ParserContext;
import org.mvel2.optimizers.OptimizerFactory;

public class ParserContextFactory {
    private static final ParserContextFactory instance = new ParserContextFactory();

    public static ParserContextFactory getInstance() {
        return instance;
    }

    public ParserContext getParserContext() {
        ParserContext parserContext = new ParserContext();
        try {
            this.addImports(parserContext);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return parserContext;
    }

    protected void addImports(ParserContext parserContext) throws SecurityException, NoSuchMethodException {
        this.addPackageImports(parserContext);
        this.addAllStaticMethodsImport(parserContext, MvelUtils.class);
        this.addDateUtilsImports(parserContext);
        this.addAllStaticMethodsImport(parserContext, Iterators.class);
    }

    protected void addPackageImports(ParserContext parserContext) throws SecurityException, NoSuchMethodException {
    }

    protected void addPackageImports(ParserContext parserContext, Class<?> clazz) {
        parserContext.addPackageImport(clazz.getPackage().getName());
    }

    protected void addStaticMethodsImport(ParserContext parserContext, Class<?> clazz, String methodName, Class<?> ... parameterTypes) {
        try {
            Method method = clazz.getMethod(methodName, parameterTypes);
            this.addImport(parserContext, method);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected void addStaticMethodsImport(ParserContext parserContext, Class<?> clazz, String methodName) {
        List<Method> methods = this.getAllStaticMethods(clazz);
        for (Method method : methods) {
            if (!methodName.equals(method.getName())) continue;
            this.addImport(parserContext, method);
        }
    }

    protected void addAllStaticMethodsImport(ParserContext parserContext, Class<?> clazz) {
        List<Method> methods = this.getAllStaticMethods(clazz);
        for (Method method : methods) {
            this.addImport(parserContext, method);
        }
    }

    private void addImport(ParserContext parserContext, Method method) {
        parserContext.addImport(method.getName(), method);
    }

    private List<Method> getAllStaticMethods(Class<?> clazz) {
        List<Method> list = CommonUtils.list();
        for (Method method : clazz.getMethods()) {
            if ((method.getModifiers() & 8) == 0 || (method.getModifiers() & 1) == 0 || method.getName().equals("forName")) continue;
            list.add(method);
        }
        return list;
    }

    private void addDateUtilsImports(ParserContext parserContext) throws SecurityException, NoSuchMethodException {
        String methodName = null;
        methodName = "toDate";
        this.addStaticMethodsImport(parserContext, DateUtils.class, methodName);
        methodName = "toSqlDate";
        this.addStaticMethodsImport(parserContext, DateUtils.class, methodName);
        methodName = "toTime";
        this.addStaticMethodsImport(parserContext, DateUtils.class, methodName);
        methodName = "toTimestamp";
        this.addStaticMethodsImport(parserContext, DateUtils.class, methodName);
        methodName = "setDate";
        this.addStaticMethodsImport(parserContext, DateUtils.class, methodName);
        methodName = "setMonth";
        this.addStaticMethodsImport(parserContext, DateUtils.class, methodName);
        methodName = "setYear";
        this.addStaticMethodsImport(parserContext, DateUtils.class, methodName);
        methodName = "currentDateTime";
        this.addStaticMethodsImport(parserContext, DateUtils.class, methodName);
        methodName = "currentDate";
        this.addStaticMethodsImport(parserContext, DateUtils.class, methodName);
        methodName = "currentTime";
        this.addStaticMethodsImport(parserContext, DateUtils.class, methodName);
        methodName = "currentTimestamp";
        this.addStaticMethodsImport(parserContext, DateUtils.class, methodName);
    }

    static {
        OptimizerFactory.setDefaultOptimizer((String)OptimizerFactory.SAFE_REFLECTIVE);
    }
}

