/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.util.eval;

import com.sqlapp.data.parameter.ParametersContext;
import com.sqlapp.exceptions.ExpressionExecutionException;
import com.sqlapp.util.MessageReader;
import com.sqlapp.util.eval.EvalExecutor;

public abstract class AbstractEvalExecutor
implements EvalExecutor {
    private String expression = null;

    public AbstractEvalExecutor(String expression) {
        this.expression = expression;
    }

    @Override
    public String getExpression() {
        return this.expression;
    }

    protected void setExpression(String expression) {
        this.expression = expression;
    }

    @Override
    public Object eval(ParametersContext bindings) {
        try {
            return this.doEval(bindings);
        }
        catch (Exception e) {
            throw this.handleException(e);
        }
    }

    protected abstract Object doEval(ParametersContext var1) throws Exception;

    @Override
    public <T> T eval(ParametersContext bindings, Class<T> clazz) {
        try {
            return this.doEval(bindings, clazz);
        }
        catch (Exception e) {
            throw this.handleException(e);
        }
    }

    protected abstract <T> T doEval(ParametersContext var1, Class<T> var2) throws Exception;

    @Override
    public Object eval(Object val) {
        try {
            return this.doEval(val);
        }
        catch (Exception e) {
            throw this.handleException(e);
        }
    }

    protected abstract Object doEval(Object var1) throws Exception;

    @Override
    public boolean evalBoolean(Object val) {
        try {
            return this.doEvalBoolean(val);
        }
        catch (Exception e) {
            throw this.handleException(e);
        }
    }

    public abstract boolean doEvalBoolean(Object var1) throws Exception;

    @Override
    public boolean evalBoolean(ParametersContext bindings) {
        try {
            return this.doEvalBoolean(bindings);
        }
        catch (Exception e) {
            throw this.handleException(e);
        }
    }

    public abstract boolean doEvalBoolean(ParametersContext var1) throws Exception;

    private ExpressionExecutionException handleException(Exception e) {
        String message = MessageReader.getInstance().getMessage("E0000003", this.getExpression());
        throw new ExpressionExecutionException(message, e);
    }
}

