/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.util.eval;

import com.sqlapp.util.eval.CachedEvaluator;
import com.sqlapp.util.eval.EvalExecutor;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public abstract class AbstractCachedEvaluator
implements CachedEvaluator {
    private Map<String, EvalExecutor> evaluatorMap = new ConcurrentHashMap<String, EvalExecutor>();

    @Override
    public EvalExecutor getEvalExecutor(String expression) {
        EvalExecutor evaluator = this.getEvaluatorMap().get(expression);
        if (evaluator == null) {
            try {
                evaluator = this.createEvalExecutor(expression);
                EvalExecutor oldValue = this.putIfAbsent(expression, evaluator);
                return oldValue == null ? evaluator : oldValue;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return evaluator;
    }

    protected EvalExecutor putIfAbsent(String expression, EvalExecutor evaluator) {
        if (this.getEvaluatorMap() instanceof ConcurrentMap) {
            return ((ConcurrentMap)this.getEvaluatorMap()).putIfAbsent(expression, evaluator);
        }
        this.getEvaluatorMap().put(expression, evaluator);
        return evaluator;
    }

    @Override
    public void clearEvalExecutor(String expression) {
        if (this.getEvaluatorMap().containsKey(expression)) {
            this.getEvaluatorMap().remove(expression);
        }
    }

    protected abstract EvalExecutor createEvalExecutor(String var1) throws Exception;

    public Map<String, EvalExecutor> getEvaluatorMap() {
        return this.evaluatorMap;
    }

    public void setEvaluatorMap(ConcurrentMap<String, EvalExecutor> evaluatorMap) {
        this.evaluatorMap = evaluatorMap;
    }
}

