/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.util;

import com.sqlapp.util.AbstractResourceSearcher;
import com.sqlapp.util.CommonUtils;
import com.sqlapp.util.ResourceFinder;
import com.sqlapp.util.VfsUtils;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Array;
import java.net.URL;
import java.net.URLConnection;
import java.util.List;

public class VfsResourceSearcher
extends AbstractResourceSearcher {
    private static final String[] PROTOCOLS = new String[]{"vfs"};

    @Override
    public <T> List<ResourceFinder.ResourceInfo> search(String packageName, URL url, boolean recursive) {
        URLConnection urlConnection;
        List<ResourceFinder.ResourceInfo> classes = CommonUtils.list();
        try {
            urlConnection = url.openConnection();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        Object virtualFile = VfsUtils.getContent(urlConnection);
        if (VfsUtils.isFile(virtualFile)) {
            File file = VfsUtils.getPhisicalFile(virtualFile);
            if (!this.isClassFile(file.getAbsolutePath())) {
                return classes;
            }
            ResourceFinder.ResourceInfo resourceInfo = new ResourceFinder.ResourceInfo(file.toURI(), this.getClassLoader(), packageName, file.getName());
            if (this.getFilter().test(resourceInfo)) {
                classes.add(resourceInfo);
            }
        }
        Object children = VfsUtils.getChildren(virtualFile);
        int length = Array.getLength(children);
        for (int i = 0; i < length; ++i) {
            Object child = Array.get(children, i);
            File file = VfsUtils.getPhisicalFile(child);
            if (file.isFile()) {
                if (!this.isResourceFile(file.getName())) continue;
                ResourceFinder.ResourceInfo resourceInfo = new ResourceFinder.ResourceInfo(file.toURI(), this.getClassLoader(), packageName, file.getName());
                if (!this.getFilter().test(resourceInfo)) continue;
                classes.add(resourceInfo);
                continue;
            }
            if (!recursive) continue;
            List<ResourceFinder.ResourceInfo> cls = this.search(packageName + "." + file.getName(), VfsUtils.toURL(child), recursive);
            classes.addAll(cls);
        }
        return classes;
    }

    @Override
    public String[] supportProtocols() {
        return PROTOCOLS;
    }
}

