/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.util;

import com.sqlapp.util.CommonUtils;
import com.sqlapp.util.HashCodeBuilder;
import com.sqlapp.util.SeparatedStringBuilder;
import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import java.util.stream.Collectors;

public class UniqueList<T>
implements List<T>,
Serializable,
Cloneable {
    private static final long serialVersionUID = 1L;
    private Set<T> innerSet = CommonUtils.set();
    protected List<T> inner = CommonUtils.list();

    @Override
    public boolean add(T obj) {
        if (this.innerSet.contains(obj)) {
            return false;
        }
        boolean ret = this.inner.add(obj);
        this.validate();
        return ret;
    }

    @Override
    public void add(int i, T obj) {
        if (this.innerSet.contains(obj)) {
            return;
        }
        this.inner.add(i, obj);
        this.validate();
    }

    @Override
    public boolean addAll(Collection<? extends T> args) {
        args = args.stream().filter(a -> !this.innerSet.contains(a)).collect(Collectors.toList());
        for (Object arg : args) {
            if (!this.innerSet.contains(arg)) continue;
        }
        boolean ret = this.inner.addAll(args);
        this.validate();
        return ret;
    }

    @Override
    public boolean addAll(int i, Collection<? extends T> args) {
        args = args.stream().filter(a -> !this.innerSet.contains(a)).collect(Collectors.toList());
        for (Object arg : args) {
            if (!this.innerSet.contains(arg)) continue;
        }
        boolean ret = this.inner.addAll(i, args);
        this.validate();
        return ret;
    }

    protected void validate() {
        this.innerSet.clear();
        for (T arg : this) {
            this.innerSet.add(arg);
        }
    }

    @Override
    public int size() {
        return this.inner.size();
    }

    @Override
    public boolean isEmpty() {
        return this.inner.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.innerSet.contains(o);
    }

    @Override
    public Iterator<T> iterator() {
        return this.inner.iterator();
    }

    @Override
    public Object[] toArray() {
        return this.inner.toArray();
    }

    @Override
    public <S> S[] toArray(S[] a) {
        return this.inner.toArray(a);
    }

    @Override
    public boolean remove(Object o) {
        boolean bool = this.inner.remove(o);
        if (bool) {
            this.validate();
        }
        return bool;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.innerSet.containsAll(c);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        boolean bool = this.inner.removeAll(c);
        this.validate();
        return bool;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        boolean bool = this.inner.retainAll(c);
        this.validate();
        return bool;
    }

    @Override
    public void clear() {
        this.inner.clear();
        this.innerSet.clear();
    }

    @Override
    public T get(int index) {
        return this.inner.get(index);
    }

    @Override
    public T set(int index, T element) {
        T obj = this.inner.set(index, element);
        this.validate();
        return obj;
    }

    @Override
    public T remove(int index) {
        T obj = this.inner.remove(index);
        this.validate();
        return obj;
    }

    @Override
    public int indexOf(Object o) {
        return this.inner.indexOf(o);
    }

    @Override
    public int lastIndexOf(Object o) {
        return this.inner.lastIndexOf(o);
    }

    @Override
    public ListIterator<T> listIterator() {
        return this.inner.listIterator();
    }

    @Override
    public ListIterator<T> listIterator(int index) {
        return this.inner.listIterator();
    }

    @Override
    public List<T> subList(int fromIndex, int toIndex) {
        return this.inner.subList(fromIndex, toIndex);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(this instanceof UniqueList)) {
            return false;
        }
        UniqueList cst = (UniqueList)obj;
        return CommonUtils.eq(this.inner, cst.inner);
    }

    @Override
    public int hashCode() {
        HashCodeBuilder builder = new HashCodeBuilder();
        builder.append(this.inner);
        builder.append(this.innerSet);
        return builder.hashCode();
    }

    public String toString() {
        SeparatedStringBuilder builder = new SeparatedStringBuilder(",");
        builder.setStart("(").setEnd(")");
        builder.add(this);
        return builder.toString();
    }

    public UniqueList<T> clone() {
        try {
            UniqueList clone = (UniqueList)super.clone();
            clone.inner = CommonUtils.list();
            clone.innerSet = CommonUtils.set();
            clone.addAll(this);
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }
}

