/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.util;

import com.sqlapp.util.CommonUtils;
import com.sqlapp.util.DoubleKeyMap;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;

public class TripleKeyMap<S, T, U, V>
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 1L;
    private Map<S, DoubleKeyMap<T, U, V>> innerMap = CommonUtils.linkedMap();

    public V get(S key1, T key2, U key3) {
        DoubleKeyMap<U, U, V> map2 = this.innerMap.get(key1);
        if (map2 == null) {
            return null;
        }
        return map2.get(key2, key3);
    }

    public void put(S key1, T key2, U key3, V value) {
        DoubleKeyMap<Object, Object, Object> map2 = this.innerMap.get(key1);
        if (map2 == null) {
            map2 = new DoubleKeyMap();
            this.innerMap.put(key1, map2);
        }
        map2.put(key2, key3, value);
    }

    public boolean containsKey(S key1, T key2, U key3) {
        DoubleKeyMap<U, U, V> map2 = this.innerMap.get(key1);
        if (map2 != null) {
            return map2.containsKey(key2, key3);
        }
        return false;
    }

    public V remove(S key1, T key2, U key3) {
        DoubleKeyMap<U, U, V> map2 = this.innerMap.get(key1);
        if (map2 == null) {
            return null;
        }
        return map2.remove(key2, key3);
    }

    public Set<S> keySet() {
        return this.innerMap.keySet();
    }

    public Set<T> secondKeySet() {
        Set result = CommonUtils.linkedSet();
        for (Map.Entry<S, DoubleKeyMap<T, U, V>> entry : this.entrySet()) {
            result.addAll(entry.getValue().keySet());
        }
        return result;
    }

    public Set<U> thirdKeySet() {
        Set result = CommonUtils.linkedSet();
        for (Map.Entry<S, DoubleKeyMap<T, U, V>> entry : this.entrySet()) {
            result.addAll(entry.getValue().secondKeySet());
        }
        return result;
    }

    public Set<Map.Entry<S, DoubleKeyMap<T, U, V>>> entrySet() {
        return this.innerMap.entrySet();
    }

    public void clear() {
        this.innerMap.clear();
    }

    public void clear(S key1) {
        DoubleKeyMap<T, U, V> map2 = this.innerMap.get(key1);
        if (map2 == null) {
            return;
        }
        map2.clear();
    }

    public void clear(S key1, T key2) {
        DoubleKeyMap<T, U, V> map2 = this.innerMap.get(key1);
        if (map2 == null) {
            return;
        }
        map2.clear(key2);
    }

    public List<V> toList() {
        List list = CommonUtils.list();
        for (Map.Entry<S, DoubleKeyMap<T, U, V>> entry : this.entrySet()) {
            for (Map.Entry<T, Map<U, V>> entry1 : entry.getValue().entrySet()) {
                for (Map.Entry<U, V> entry2 : entry1.getValue().entrySet()) {
                    list.add(entry2.getValue());
                }
            }
        }
        return list;
    }

    public DoubleKeyMap<S, T, List<V>> toDoubleKeyMapList() {
        DoubleKeyMap dKeyMap = CommonUtils.doubleKeyMap();
        for (Map.Entry<S, DoubleKeyMap<T, U, V>> entry : this.entrySet()) {
            for (Map.Entry<T, Map<U, V>> entry1 : entry.getValue().entrySet()) {
                List list = CommonUtils.list();
                for (Map.Entry<U, V> entry2 : entry1.getValue().entrySet()) {
                    list.add(entry2.getValue());
                }
                dKeyMap.put(entry.getKey(), entry1.getKey(), list);
            }
        }
        return dKeyMap;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("[");
        boolean first = true;
        for (Map.Entry<S, DoubleKeyMap<T, U, V>> entry : this.entrySet()) {
            for (Map.Entry<T, Map<U, V>> entry1 : entry.getValue().entrySet()) {
                for (Map.Entry<U, V> entry2 : entry1.getValue().entrySet()) {
                    if (!first) {
                        builder.append(", ");
                    }
                    builder.append("{");
                    builder.append("(");
                    builder.append(entry.getKey());
                    builder.append(", ");
                    builder.append(entry1.getKey());
                    builder.append(", ");
                    builder.append(entry2.getKey());
                    builder.append(")=");
                    builder.append(entry2.getValue());
                    builder.append("}");
                    first = false;
                }
            }
        }
        builder.append("]");
        return builder.toString();
    }

    public int size() {
        int ret = 0;
        for (Map.Entry<S, DoubleKeyMap<T, U, V>> entry : this.innerMap.entrySet()) {
            ret += entry.getValue().size();
        }
        return ret;
    }

    public TripleKeyMap<S, T, U, V> clone() {
        TripleKeyMap<S, T, U, V> clone = new TripleKeyMap<S, T, U, V>();
        for (Map.Entry<S, DoubleKeyMap<T, U, V>> entry : this.innerMap.entrySet()) {
            clone.innerMap.put(entry.getKey(), (DoubleKeyMap<T, U, Object>)entry.getValue().clone());
        }
        return clone;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof TripleKeyMap)) {
            return false;
        }
        TripleKeyMap cst = (TripleKeyMap)obj;
        return this.innerMap.equals(cst.innerMap);
    }

    public int hashCode() {
        return CommonUtils.hashCode(this.innerMap);
    }

    public static <S, T, U, V> TripleKeyMap<S, T, U, V> toMap(Collection<V> c, Function<V, S> func1, Function<V, T> func2, Function<V, U> func3) {
        if (c == null) {
            return CommonUtils.tripleKeyMap();
        }
        TripleKeyMap result = CommonUtils.tripleKeyMap();
        c.forEach(v -> {
            Object key1 = func1.apply(v);
            Object key2 = func2.apply(v);
            Object key3 = func3.apply(v);
            result.put(key1, key2, key3, v);
        });
        return result;
    }

    public static <S, T, U, V> TripleKeyMap<S, T, U, List<V>> toListMap(Collection<V> c, Function<V, S> func1, Function<V, T> func2, Function<V, U> func3) {
        if (c == null) {
            return CommonUtils.tripleKeyMap();
        }
        TripleKeyMap result = CommonUtils.tripleKeyMap();
        c.forEach(v -> {
            Object key3;
            Object key2;
            Object key1 = func1.apply(v);
            List list = (List)result.get(key1, key2 = func2.apply(v), key3 = func3.apply(v));
            if (list == null) {
                list = CommonUtils.list();
                result.put(key1, key2, key3, list);
            }
            list.add(v);
        });
        return result;
    }
}

