/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.util;

import com.sqlapp.util.CommonUtils;
import java.lang.ref.SoftReference;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class StringUtils {
    private static final Pattern PASCAL_PATTERN = Pattern.compile("[A-Z]+[^a-z]*[a-z0-9]*");
    private static final Map<String, SoftReference<String>> PASCAL_TO_UNDERSCORE_CACHE = new HashMap<String, SoftReference<String>>();
    private static final String[] EMPTY_STRING_ARRAY = new String[0];

    private StringUtils() {
    }

    public static String transposition(String value) {
        return StringUtils.transposition(value, " ");
    }

    public static String transposition(String value, String space) {
        String[] args = value.split("\n");
        int maxCodePointCount = 0;
        for (String arg : args) {
            int val = arg.codePointCount(0, arg.length());
            if (val <= maxCodePointCount) continue;
            maxCodePointCount = val;
        }
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < maxCodePointCount; ++i) {
            for (int j = 0; j < args.length; ++j) {
                String arg;
                arg = args[j];
                if (i < arg.codePointCount(0, arg.length())) {
                    int codePoint = arg.codePointAt(i);
                    builder.appendCodePoint(codePoint);
                    continue;
                }
                builder.append(space);
            }
            builder.append("\n");
        }
        return builder.substring(0, builder.length() - 1);
    }

    @Deprecated
    public static String snakeToCamelCase(String val) {
        return StringUtils.snakeToCamel(val);
    }

    public static String snakeToCamel(String val) {
        if (CommonUtils.isEmpty(val)) {
            return val;
        }
        String[] splits = val.split("_");
        StringBuilder builder = new StringBuilder(val.length() - splits.length + 1);
        if (CommonUtils.isEmpty(splits)) {
            return "";
        }
        builder.append(splits[0].toLowerCase());
        for (int i = 1; i < splits.length; ++i) {
            if (splits[i].length() > 0) {
                builder.append(splits[i].substring(0, 1).toUpperCase());
            }
            if (splits[i].length() <= 1) continue;
            builder.append(splits[i].substring(1).toLowerCase());
        }
        return builder.toString();
    }

    @Deprecated
    public static String camelToSnakeCase(String val) {
        return StringUtils.camelToSnake(val);
    }

    public static String camelToSnake(String val) {
        String camel = StringUtils.pascalToUnderscore(StringUtils.camelToPascal(val));
        return camel;
    }

    public static String camelToPascal(String val) {
        if (CommonUtils.isEmpty(val)) {
            return val;
        }
        if (val.length() == 1) {
            return val.toUpperCase();
        }
        return val.substring(0, 1).toUpperCase() + val.substring(1);
    }

    public static String pascalToCamel(String val) {
        if (CommonUtils.isEmpty(val)) {
            return val;
        }
        if (val.length() == 1) {
            return val;
        }
        return val.substring(0, 1).toLowerCase() + val.substring(1);
    }

    public static String snakeToPascal(String val) {
        if (CommonUtils.isEmpty(val)) {
            return val;
        }
        String[] splits = val.split("_");
        if (CommonUtils.isEmpty(splits)) {
            return "";
        }
        StringBuilder builder = new StringBuilder(val.length() - splits.length + 1);
        if (splits[0].length() > 0) {
            builder.append(splits[0].substring(0, 1).toUpperCase());
        }
        if (splits[0].length() > 1) {
            builder.append(splits[0].substring(1).toLowerCase());
        }
        for (int i = 1; i < splits.length; ++i) {
            if (splits[i].length() > 0) {
                builder.append(splits[i].substring(0, 1).toUpperCase());
            }
            if (splits[i].length() <= 1) continue;
            builder.append(splits[i].substring(1).toLowerCase());
        }
        return builder.toString();
    }

    public static String capitalize(String text) {
        if (text == null || text.length() == 0) {
            return text;
        }
        return Character.toTitleCase(text.charAt(0)) + text.substring(1);
    }

    public static String uncapitalize(String text) {
        if (text == null || text.length() == 0) {
            return text;
        }
        return Character.toLowerCase(text.charAt(0)) + text.substring(1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String pascalToUnderscore(String val) {
        if (CommonUtils.isEmpty(val)) {
            return val;
        }
        if (val.length() == 1) {
            return val;
        }
        SoftReference<String> ref = PASCAL_TO_UNDERSCORE_CACHE.get(val);
        if (ref != null) {
            String ret = ref.get();
            if (ret != null) {
                return ret;
            }
            Map<String, SoftReference<String>> map = PASCAL_TO_UNDERSCORE_CACHE;
            synchronized (map) {
                Set<String> set = CommonUtils.set();
                for (Map.Entry<String, SoftReference<String>> entry : PASCAL_TO_UNDERSCORE_CACHE.entrySet()) {
                    if (entry.getValue() == null || entry.getValue().get() != null) continue;
                    set.add(entry.getKey());
                }
                for (String key : set) {
                    PASCAL_TO_UNDERSCORE_CACHE.remove(key);
                }
            }
        }
        StringBuilder buf = new StringBuilder(val.length() * 2);
        Matcher matcher = PASCAL_PATTERN.matcher(val);
        boolean first = true;
        while (matcher.find()) {
            if (!first) {
                buf.append('_');
            }
            first = false;
            buf.append(matcher.group());
        }
        String result = buf.toString().toUpperCase();
        ref = new SoftReference<String>(result);
        PASCAL_TO_UNDERSCORE_CACHE.putIfAbsent(val, ref);
        return result;
    }

    public static String printf(String text, Object ... args) {
        StringBuilder buf = new StringBuilder(text);
        for (int i = 0; i < args.length; ++i) {
            String serchStr = "{" + i + "}";
            int pos = buf.indexOf(serchStr);
            if (pos < 0) continue;
            buf.replace(pos, pos + serchStr.length(), StringUtils.convertNullToString(args[i]));
        }
        return buf.toString();
    }

    public static String printfCsv(Object ... args) {
        StringBuilder buf = new StringBuilder("");
        buf.append(StringUtils.convertNullToString(args[0]));
        for (int i = 1; i < args.length; ++i) {
            buf.append(',');
            buf.append(StringUtils.convertNullToString(args[i]));
        }
        return buf.toString();
    }

    private static String convertNullToString(Object arg) {
        if (arg == null) {
            return "";
        }
        return arg.toString();
    }

    public static boolean containsLowerCase(String value) {
        return StringUtils.containsRange(value, 'a', 'z');
    }

    public static boolean containsRange(String value, char cStart, char cEnd) {
        if (value == null) {
            return false;
        }
        int size = value.length();
        for (int i = 0; i < size; ++i) {
            char c = value.charAt(i);
            if (cStart > c || c > cEnd) continue;
            return true;
        }
        return false;
    }

    public static boolean inRange(String value, char cStart, char cEnd) {
        if (value == null) {
            return true;
        }
        int size = value.length();
        for (int i = 0; i < size; ++i) {
            char c = value.charAt(i);
            if (c >= cStart && c <= cEnd) continue;
            return false;
        }
        return true;
    }

    public static boolean containsUpperCase(String value) {
        return StringUtils.containsRange(value, 'A', 'Z');
    }

    public static String getGroupString(Pattern pattern, String value, int groupNo) {
        if (value == null) {
            return value;
        }
        Matcher matcher = pattern.matcher(value);
        if (matcher.matches()) {
            return StringUtils.getGroupString(matcher, groupNo);
        }
        return null;
    }

    public static String getGroupString(Matcher matcher, int groupNo) {
        if (matcher.groupCount() < groupNo) {
            return null;
        }
        return matcher.group(groupNo);
    }

    public static final String[] split(String value, String regex) {
        if (value == null || value.length() == 0) {
            return EMPTY_STRING_ARRAY;
        }
        return value.split(regex);
    }

    public static final String[] split(String value) {
        return StringUtils.trim(StringUtils.split(value, "[ ,;]"));
    }

    public static final String[] trim(String ... args) {
        if (CommonUtils.isEmpty(args)) {
            return args;
        }
        List<String> result = CommonUtils.list(args.length);
        int size = args.length;
        for (int i = 0; i < size; ++i) {
            String tr = CommonUtils.trim(args[i]);
            if (CommonUtils.isEmpty(tr)) continue;
            result.add(tr);
        }
        return result.toArray(EMPTY_STRING_ARRAY);
    }

    public static int getDisplayWidth(String val) {
        if (val == null) {
            return 0;
        }
        int count = 0;
        int i = 0;
        int codePointLen = val.codePointCount(0, val.length());
        while (i < codePointLen) {
            int codePoint;
            if (StringUtils.isHalf(codePoint = val.codePointAt(i++))) {
                ++count;
                continue;
            }
            count += 2;
        }
        return count;
    }

    public static int getDisplayWidth(StringBuilder val) {
        if (val == null) {
            return 0;
        }
        int count = 0;
        int i = 0;
        int codePointLen = val.codePointCount(0, val.length());
        while (i < codePointLen) {
            int codePoint;
            if (StringUtils.isHalf(codePoint = val.codePointAt(i++))) {
                ++count;
                continue;
            }
            count += 2;
        }
        return count;
    }

    public static boolean isHalf(int codePoint) {
        Character.UnicodeBlock unicodeBlock = Character.UnicodeBlock.of(codePoint);
        if (Character.UnicodeBlock.BASIC_LATIN.equals(unicodeBlock)) {
            return true;
        }
        if (Character.UnicodeBlock.ARROWS.equals(unicodeBlock)) {
            return true;
        }
        if (Character.UnicodeBlock.LATIN_1_SUPPLEMENT.equals(unicodeBlock)) {
            return true;
        }
        return codePoint >= 65377 && codePoint <= 65439;
    }

    public static String substringCodePoint(String target, int startIndex, int endIndex) {
        if (target == null) {
            return target;
        }
        char[] charArray = target.toCharArray();
        int start = target.offsetByCodePoints(0, startIndex);
        int end = target.offsetByCodePoints(0, endIndex);
        int codePoint = 0;
        StringBuilder builder = new StringBuilder(endIndex);
        for (int i = start; i < end; i += Character.charCount(codePoint)) {
            codePoint = Character.codePointAt(charArray, i);
            builder.append(String.valueOf(Character.toChars(codePoint)));
        }
        return builder.toString();
    }
}

