/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.util;

import com.sqlapp.data.converter.Base64Converter;
import com.sqlapp.data.converter.Converter;
import com.sqlapp.data.converter.Converters;
import com.sqlapp.data.schemas.DbInfo;
import com.sqlapp.data.schemas.SchemaProperties;
import com.sqlapp.util.CommonUtils;
import com.sqlapp.util.SeparatedStringBuilder;
import com.sqlapp.util.xml.SimpleXMLStreamWriter;
import java.io.OutputStream;
import java.io.Writer;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;

public class StaxWriter {
    private final XMLStreamWriter writer;
    public static final String LIST_ELEMENT = "list";
    public static final String MAP_ELEMENT = "map";
    public static final String ENTRY_ELEMENT = "entry";
    public static final String SET_ELEMENT = "set";
    public static final String KEY_ELEMENT = "key";
    public static final String VALUE_ELEMENT = "value";
    public static final String VALUES_ELEMENT = "values";
    public static final String NULL_ELEMENT = "null";
    private Converter<byte[]> binaryConverter = new Base64Converter();
    private boolean writeEmptyTag = true;
    private String lineSeparator = "\n";
    private int indentLevel = 0;
    private String indentString = "\t";
    private String currentIndentString = null;
    private ValueHandler valueHandler = null;
    private long writeElementCount = 0L;
    private long writeAttributeCount = 0L;
    private long writeValueCount = 0L;
    private long writeCommentCount = 0L;
    private boolean writePreserveSpace = true;
    private boolean writeAutoStartDocument = true;
    private static Converters converters = Converters.getNewBooleanTrueInstance();
    private boolean writeStartDocument = false;

    public StaxWriter(Writer writer) throws XMLStreamException {
        this.writer = new SimpleXMLStreamWriter(writer);
    }

    public StaxWriter setHtmlMode() {
        this.setWriteAutoStartDocument(false);
        this.setWritePreserveSpace(false);
        return this;
    }

    public StaxWriter(XMLStreamWriter writer) throws XMLStreamException {
        this.writer = writer;
    }

    public StaxWriter(OutputStream outputStream) throws XMLStreamException {
        this.writer = new SimpleXMLStreamWriter(outputStream);
    }

    public Converter<byte[]> getBinaryConverter() {
        return this.binaryConverter;
    }

    public void setBinaryConverter(Converter<byte[]> binaryConverter) {
        this.binaryConverter = binaryConverter;
    }

    protected void addElementCount() throws XMLStreamException {
        if (this.writeElementCount == 0L && this.writePreserveSpace) {
            this.writer.writeAttribute("xml:space", "preserve");
        }
        ++this.writeElementCount;
    }

    protected void addAttributeCount() throws XMLStreamException {
        ++this.writeAttributeCount;
    }

    protected void addValueCount() throws XMLStreamException {
        ++this.writeValueCount;
    }

    protected void addCommentCount() throws XMLStreamException {
        ++this.writeCommentCount;
    }

    public long getWriteElementCount() throws XMLStreamException {
        return this.writeElementCount;
    }

    public long getWriteAttributeCount() {
        return this.writeAttributeCount;
    }

    public long getWriteValueCount() {
        return this.writeValueCount;
    }

    public long getWriteCommentCount() {
        return this.writeCommentCount;
    }

    public boolean isWritePreserveSpace() {
        return this.writePreserveSpace;
    }

    public StaxWriter setWritePreserveSpace(boolean writePreserveSpace) {
        this.writePreserveSpace = writePreserveSpace;
        return this;
    }

    public StaxWriter setHandleValue(ValueHandler valueHandler) {
        this.valueHandler = valueHandler;
        return this;
    }

    protected XMLOutputFactory newXMLOutputFactory() {
        XMLOutputFactory factory = XMLOutputFactory.newInstance();
        return factory;
    }

    protected <T> T handleValue(String prefix, String namespaceURI, String localName, Object value) {
        if (this.valueHandler == null) {
            return (T)value;
        }
        return (T)this.valueHandler.convert(prefix, namespaceURI, localName, value);
    }

    public StaxWriter writeAttribute(String localName, String value) throws XMLStreamException {
        if ((value = (String)this.handleValue(null, null, localName, value)) != null) {
            this.writer.writeAttribute(localName, value);
            this.addAttributeCount();
        }
        return this;
    }

    public StaxWriter writeAttribute(SchemaProperties prop, Object value) throws XMLStreamException {
        return this.writeAttribute(prop.getLabel(), prop.getValue(value));
    }

    public StaxWriter writeAttribute(String localName, Object value) throws XMLStreamException {
        if ((value = this.handleValue(null, null, localName, value)) != null) {
            String text = this.getConverters().convertString(value, value.getClass());
            return this.writeAttribute(localName, text);
        }
        return this;
    }

    protected boolean isWriteStartDocument() {
        return this.writeStartDocument;
    }

    protected void setWriteStartDocument(boolean writeStartDocument) {
        this.writeStartDocument = writeStartDocument;
    }

    protected Converters getConverters() {
        return converters;
    }

    public StaxWriter writeAttribute(String namespaceURI, String localName, String value) throws XMLStreamException {
        if ((value = (String)this.handleValue(null, namespaceURI, localName, value)) != null) {
            this.writer.writeAttribute(namespaceURI, localName, value);
            this.addAttributeCount();
        }
        return this;
    }

    public StaxWriter writeAttribute(String prefix, String namespaceURI, String localName, String value) throws XMLStreamException {
        if ((value = (String)this.handleValue(prefix, namespaceURI, localName, value)) != null) {
            this.writer.writeAttribute(prefix, namespaceURI, localName, value);
            this.addAttributeCount();
        }
        return this;
    }

    public StaxWriter writeCData(String data) throws XMLStreamException {
        if (data != null) {
            this.writer.writeCData(data);
            this.addValueCount();
        }
        return this;
    }

    public StaxWriter writeComment(String data) throws XMLStreamException {
        if (data != null) {
            this.writer.writeComment(data);
            this.addCommentCount();
        }
        return this;
    }

    public StaxWriter writeCharacters(String text) throws XMLStreamException {
        if (text != null) {
            this.writer.writeCharacters(text);
            this.addValueCount();
        }
        return this;
    }

    public StaxWriter writeCharacters(Object obj) throws XMLStreamException {
        if (obj != null) {
            if (obj instanceof byte[]) {
                this.writer.writeCharacters(this.getBinaryConverter().convertString((byte[])obj));
                this.addValueCount();
            } else {
                String text = this.getConverters().convertString(obj, obj.getClass());
                this.writer.writeCharacters(text);
                this.addValueCount();
            }
        }
        return this;
    }

    public StaxWriter writeStartElement(String namespaceURI, String localName) throws XMLStreamException {
        this.writeStartDocument();
        this.writer.writeStartElement(namespaceURI, localName);
        this.addElementCount();
        return this;
    }

    public StaxWriter writeStartElement(String localName) throws XMLStreamException {
        this.writeStartDocument();
        this.writer.writeStartElement(localName);
        this.addElementCount();
        return this;
    }

    public StaxWriter writeElement(String localName, RunWithException run) throws XMLStreamException {
        this.writeStartElement(localName);
        run.run();
        this.writeEndElement();
        return this;
    }

    public StaxWriter writeEmptyElement(String namespaceURI, String localName) throws XMLStreamException {
        this.writeStartDocument();
        this.writer.writeEmptyElement(localName);
        this.addElementCount();
        return this;
    }

    public StaxWriter writeEmptyElement(String localName) throws XMLStreamException {
        this.writeStartDocument();
        this.writer.writeEmptyElement(localName);
        this.addElementCount();
        return this;
    }

    public StaxWriter writeEndElement() throws XMLStreamException {
        this.writer.writeEndElement();
        return this;
    }

    public StaxWriter writeStartDocument() throws XMLStreamException {
        return this.writeStartDocument("utf-8", "1.0");
    }

    public StaxWriter writeStartDocument(String encoding, String version) throws XMLStreamException {
        if (!this.writeAutoStartDocument) {
            return this;
        }
        if (this.isWriteStartDocument()) {
            return this;
        }
        this.writer.writeStartDocument(encoding, version);
        this.writeStartDocument = true;
        return this.newLine();
    }

    public StaxWriter writeDocument(String encoding, String version, RunWithException run) throws XMLStreamException {
        this.writeStartDocument(encoding, version);
        run.run();
        return this.writeEndDocument();
    }

    public StaxWriter writeEndDocument() throws XMLStreamException {
        this.writer.writeEndDocument();
        return this;
    }

    public StaxWriter writeElement(String localName, String value) throws XMLStreamException {
        if (value != null) {
            this.writeStartElement(localName);
            this.writeCharacters(value);
            this.writeEndElement();
        } else if (this.writeEmptyTag) {
            this.writeEmptyElement(localName);
        }
        return this;
    }

    public StaxWriter writeCData(String localName, String value) throws XMLStreamException {
        if ((value = (String)this.handleValue(null, null, localName, value)) != null) {
            this.writeStartElement(localName);
            this.writeCData(value);
            this.writeEndElement();
        } else if (this.writeEmptyTag) {
            this.writeEmptyElement(localName);
        }
        return this;
    }

    public StaxWriter writeElement(String localName, Object value) throws XMLStreamException {
        if ((value = this.handleValue(null, null, localName, value)) != null) {
            this.writeStartElement(localName);
            this.writeCharacters(value);
            this.writeEndElement();
        } else if (this.writeEmptyTag) {
            this.writeEmptyElement(localName);
        }
        return this;
    }

    public StaxWriter writeElement(String localName, List<String> values) throws XMLStreamException {
        if (!CommonUtils.isEmpty(values = (List)this.handleValue(null, null, localName, values))) {
            this.writeStartElement(localName);
            SeparatedStringBuilder builder = new SeparatedStringBuilder("\n");
            builder.add(values);
            this.writeCharacters(builder.toString());
            this.writeEndElement();
        } else if (this.writeEmptyTag) {
            this.writeEmptyElement(localName);
        }
        return this;
    }

    public StaxWriter writeElement(String localName, DbInfo value) throws XMLStreamException {
        if ((value = (DbInfo)this.handleValue(null, null, localName, value)) == null || value.isEmpty()) {
            if (this.writeEmptyTag) {
                this.writeEmptyElement(localName);
            }
        } else {
            this.writeStartElement(localName);
            for (Map.Entry<String, String> entry : value.entrySet()) {
                this.writeElement(ENTRY_ELEMENT, () -> {
                    String key = (String)entry.getKey();
                    Object val = entry.getValue();
                    this.writeAttribute(KEY_ELEMENT, key);
                    if (!CommonUtils.isEmpty(val)) {
                        this.writeAttribute(VALUE_ELEMENT, (String)val);
                    }
                });
            }
            this.writeEndElement();
        }
        return this;
    }

    protected StaxWriter write(Object obj) throws XMLStreamException {
        if (obj instanceof List) {
            return this.write((List)obj);
        }
        if (obj instanceof Set) {
            return this.write((Set)obj);
        }
        if (obj instanceof Map) {
            return this.write((Map)obj);
        }
        return this.writeCharacters(obj);
    }

    protected StaxWriter write(List<?> list) throws XMLStreamException {
        this.writeCollection(LIST_ELEMENT, list);
        return this;
    }

    protected StaxWriter write(Set<?> set) throws XMLStreamException {
        this.writeCollection(SET_ELEMENT, set);
        return this;
    }

    public StaxWriter write(Map<?, ?> map) throws XMLStreamException {
        if (map != null) {
            this.writeStartElement(MAP_ELEMENT);
            for (Map.Entry<?, ?> entry : map.entrySet()) {
                this.writeStartElement(ENTRY_ELEMENT);
                this.writeAttribute(KEY_ELEMENT, entry.getKey());
                this.writeAttribute(VALUE_ELEMENT, entry.getValue());
                this.writeEndElement();
            }
            this.writeEndElement();
        }
        return this;
    }

    protected void writeCollection(String localName, Collection<?> c) throws XMLStreamException {
        c = (Collection)this.handleValue(null, null, localName, c);
        this.writeStartElement(localName);
        for (Object val : c) {
            if (val == null) {
                this.writeEmptyElement(VALUE_ELEMENT);
                continue;
            }
            this.writeStartElement(VALUE_ELEMENT);
            this.writeCharacters(val);
            this.writeEndElement();
        }
        this.writeEndElement();
    }

    public StaxWriter writeElement(String localName, Set<?> set) throws XMLStreamException {
        if ((set = (Set)this.handleValue(null, null, localName, set)) == null) {
            if (this.writeEmptyTag) {
                this.writeEmptyElement(localName);
            }
        } else {
            this.writeStartElement(localName);
            this.writeCollection(SET_ELEMENT, set);
            this.writeEndElement();
        }
        return this;
    }

    public StaxWriter writeElementValues(String localName, Collection<?> c) throws XMLStreamException {
        if ((c = (Collection)this.handleValue(null, null, localName, c)) == null) {
            if (this.writeEmptyTag) {
                this.writeEmptyElement(localName);
            }
        } else {
            this.writeStartElement(localName);
            for (Object obj : c) {
                this.writeElement(VALUE_ELEMENT, obj);
            }
            this.writeEndElement();
        }
        return this;
    }

    public StaxWriter writeElement(String localName, Map<?, ?> map) throws XMLStreamException {
        if ((map = (Map)this.handleValue(null, null, localName, map)) != null) {
            this.writeStartElement(localName);
            this.write(map);
            this.writeEndElement();
        } else if (this.writeEmptyTag) {
            this.writeEmptyElement(localName);
        }
        return this;
    }

    public boolean isWriteEmptyTag() {
        return this.writeEmptyTag;
    }

    public StaxWriter setWriteEmptyTag(boolean writeEmptyTag) {
        this.writeEmptyTag = writeEmptyTag;
        return this;
    }

    public boolean isWriteAutoStartDocument() {
        return this.writeAutoStartDocument;
    }

    public StaxWriter setWriteAutoStartDocument(boolean writeAutoStartDocument) {
        this.writeAutoStartDocument = writeAutoStartDocument;
        return this;
    }

    public StaxWriter newLine() throws XMLStreamException {
        this.writeStartDocument();
        return this.writeCharacters(this.lineSeparator);
    }

    public String getLineSeparator() {
        return this.lineSeparator;
    }

    public StaxWriter setLineSeparator(String lineSeparator) {
        this.lineSeparator = lineSeparator;
        return this;
    }

    public int getIndentLevel() {
        return this.indentLevel;
    }

    public StaxWriter setIndentLevel(int indentLevel) {
        if (indentLevel >= 0) {
            this.indentLevel = indentLevel;
            this.currentIndentString = CommonUtils.getString(this.indentString, indentLevel);
        }
        return this;
    }

    public StaxWriter addIndentLevel(int addCount) {
        this.setIndentLevel(this.getIndentLevel() + addCount);
        return this;
    }

    public StaxWriter indent(int addCount, RunWithException run) throws XMLStreamException {
        this.addIndentLevel(addCount);
        run.run();
        this.addIndentLevel(-addCount);
        return this;
    }

    public StaxWriter indent(RunWithException run) throws XMLStreamException {
        return this.indent(1, run);
    }

    public String getIndentString() {
        return this.indentString;
    }

    public StaxWriter setIndentString(String indentString) {
        this.indentString = indentString;
        return this.setIndentLevel(this.getIndentLevel());
    }

    public StaxWriter indent() throws XMLStreamException {
        this.writeCharacters(this.currentIndentString);
        return this;
    }

    public long getWriteCount() {
        return this.writeAttributeCount + this.writeCommentCount + this.writeElementCount + this.writeValueCount;
    }

    @FunctionalInterface
    public static interface RunWithException {
        public void run() throws XMLStreamException;
    }

    public static interface ValueHandler {
        public Object convert(String var1, String var2, String var3, Object var4);
    }
}

