/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.util;

import com.sqlapp.util.CommonUtils;
import com.sqlapp.util.MessageReader;
import com.sqlapp.util.ToStringBuilder;
import java.io.InputStream;
import java.io.Reader;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.stream.Location;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

public class StaxReader
implements AutoCloseable {
    private XMLStreamReader reader = null;
    private Location currentLocation = null;
    private Set<Integer> supportEvents = CommonUtils.set(new Integer[]{10, 12, 4, 1, 2});
    private static final Map<Integer, String> EVENT_NAME_MAP = CommonUtils.map(12, 1.0f);

    public StaxReader(Reader reader) throws XMLStreamException {
        XMLInputFactory factory = XMLInputFactory.newInstance();
        factory.setProperty("javax.xml.stream.isCoalescing", true);
        this.reader = factory.createXMLStreamReader(reader);
    }

    public StaxReader(InputStream stream) throws XMLStreamException {
        XMLInputFactory factory = XMLInputFactory.newInstance();
        factory.setProperty("javax.xml.stream.isCoalescing", true);
        this.reader = factory.createXMLStreamReader(stream);
    }

    public StaxReader(InputStream stream, String encoding) throws XMLStreamException {
        XMLInputFactory factory = XMLInputFactory.newInstance();
        factory.setProperty("javax.xml.stream.isCoalescing", true);
        this.reader = factory.createXMLStreamReader(stream, encoding);
    }

    public StaxReader(XMLStreamReader reader) {
        this.reader = reader;
    }

    public String getLocalName() {
        return this.reader.getLocalName();
    }

    public QName getName() {
        return this.reader.getName();
    }

    public String getPrefix() {
        return this.reader.getPrefix();
    }

    public String getNamespaceURI() {
        return this.reader.getNamespaceURI();
    }

    public String getText() {
        return this.reader.getText();
    }

    public boolean isStartElement() {
        return this.reader.isStartElement();
    }

    public boolean isEndElement() {
        return this.reader.isEndElement();
    }

    public boolean isWhiteSpace() {
        return this.reader.isWhiteSpace();
    }

    public boolean isCharacters() {
        return this.reader.isCharacters();
    }

    public boolean isStartDocument() {
        return this.reader.getEventType() == 7;
    }

    public boolean isEndDocument() {
        return this.reader.getEventType() == 8;
    }

    public boolean isComment() {
        return this.reader.getEventType() == 5;
    }

    public boolean hasNext() throws XMLStreamException {
        return this.reader.hasNext();
    }

    public void raiseElementException(String elementName) throws XMLStreamException {
        String message = null;
        message = this.currentLocation == null ? MessageReader.getInstance().getMessage("E0000001", elementName, this.getLocalName(this.reader), "", "") : MessageReader.getInstance().getMessage("E0000001", elementName, this.getLocalName(this.reader), this.currentLocation.getLineNumber(), this.currentLocation.getColumnNumber());
        XMLStreamException e = new XMLStreamException(message);
        throw e;
    }

    private String getLocalName(XMLStreamReader reader) {
        try {
            return reader.getLocalName();
        }
        catch (IllegalStateException e) {
            return "";
        }
    }

    public void raiseAttributeNotFoundException(String attributeName) throws XMLStreamException {
        String message = MessageReader.getInstance().getMessage("E0000002", attributeName, this.currentLocation.getLineNumber(), this.currentLocation.getColumnNumber());
        XMLStreamException e = new XMLStreamException(message);
        throw e;
    }

    public int next() throws XMLStreamException {
        while (this.hasNext()) {
            Location location;
            int result = this.reader.next();
            if (!this.supportEvents.contains(result)) continue;
            this.currentLocation = location = this.reader.getLocation();
            return result;
        }
        return 0;
    }

    public Location getLocation() throws XMLStreamException {
        return this.reader.getLocation();
    }

    public int getAttributeCount() {
        return this.reader.getAttributeCount();
    }

    public String getAttributeLocalName(int index) {
        return this.reader.getAttributeLocalName(index);
    }

    public String getAttributeValue(int index) {
        return this.reader.getAttributeValue(index);
    }

    public Set<Integer> getSupportEvents() {
        return this.supportEvents;
    }

    public void setSupportEvents(Set<Integer> supportEvents) {
        this.supportEvents = supportEvents;
    }

    public void setSupportEvents(Integer ... supportEvents) {
        this.supportEvents = CommonUtils.set(supportEvents);
    }

    public int nextFristStartElement() throws XMLStreamException {
        int result = 0;
        while (this.hasNext()) {
            result = this.next();
            if (!this.isStartElement()) continue;
            return result;
        }
        return result;
    }

    public String toString() {
        ToStringBuilder builder = new ToStringBuilder(StaxReader.class);
        builder.add("eventType", EVENT_NAME_MAP.get(this.reader.getEventType()));
        if (this.reader.isStartElement() || this.reader.isEndElement()) {
            builder.add("localName", this.reader.getLocalName());
            builder.add("prefix", this.reader.getPrefix());
            builder.add("namespaceURI", this.reader.getNamespaceURI());
        }
        if (this.reader.isStartElement()) {
            int size = this.reader.getAttributeCount();
            for (int i = 0; i < size; ++i) {
                String name = this.reader.getAttributeLocalName(i);
                String value = this.reader.getAttributeValue(i);
                builder.add(name, value);
            }
        }
        if (this.reader.isCharacters()) {
            builder.add("value", this.reader.getText());
        }
        return builder.toString();
    }

    @Override
    public void close() throws Exception {
        if (this.reader != null) {
            this.reader.close();
            this.reader = null;
        }
    }

    static {
        EVENT_NAME_MAP.put(12, "CDATA");
        EVENT_NAME_MAP.put(10, "ATTRIBUTE");
        EVENT_NAME_MAP.put(4, "CHARACTERS");
        EVENT_NAME_MAP.put(5, "COMMENT");
        EVENT_NAME_MAP.put(6, "SPACE");
        EVENT_NAME_MAP.put(7, "START_DOCUMENT");
        EVENT_NAME_MAP.put(8, "END_DOCUMENT");
        EVENT_NAME_MAP.put(1, "START_ELEMENT");
        EVENT_NAME_MAP.put(2, "END_ELEMENT");
        EVENT_NAME_MAP.put(11, "DTD");
        EVENT_NAME_MAP.put(15, "ENTITY_DECLARATION");
        EVENT_NAME_MAP.put(9, "ENTITY_REFERENCE");
    }
}

