/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.util;

import com.sqlapp.util.DoubleKeyMap;
import com.sqlapp.util.FileUtils;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Locale;
import java.util.Properties;

public class PropertyUtils {
    private static final DoubleKeyMap<Class<?>, Locale, Properties> PROPERTIES_CHACHE = new DoubleKeyMap();

    public static <T extends Enum<T>> String getPropertyValue(Class<?> clazz, String propertyFileName, String key, Locale locale) {
        try {
            Properties properties = PropertyUtils.getProperty(clazz, propertyFileName, locale);
            String value = properties.getProperty(key);
            if (value == null) {
                properties = PropertyUtils.getProperty(clazz, propertyFileName, null);
                value = properties.getProperty(key);
            }
            return value;
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Properties getProperty(Class<?> clazz, String name, Locale locale) throws FileNotFoundException {
        Properties properties = PROPERTIES_CHACHE.get(clazz, locale);
        if (properties != null) {
            return properties;
        }
        InputStream in = PropertyUtils.getInputStream(clazz, name, locale);
        if (in == null) {
            throw new FileNotFoundException(PropertyUtils.getPropertyPath(clazz, name));
        }
        try {
            properties = new Properties();
            properties.load(in);
            PROPERTIES_CHACHE.put(clazz, locale, properties);
            Properties properties2 = properties;
            return properties2;
        }
        catch (IOException e) {
            Properties properties3 = null;
            return properties3;
        }
        finally {
            FileUtils.close(in);
        }
    }

    private static InputStream getInputStream(Class<?> clazz, String name, Locale locale) {
        InputStream stream = null;
        if (locale != null) {
            stream = FileUtils.getInputStream(clazz, name + "_" + locale.toString() + ".properties");
            if (stream != null) {
                return stream;
            }
            stream = FileUtils.getInputStream(clazz, name + "_" + locale.getLanguage() + ".properties");
            if (stream != null) {
                return stream;
            }
        }
        return FileUtils.getInputStream(clazz, name + ".properties");
    }

    private static String getPropertyPath(Class<?> clazz, String name) {
        String result = "/" + clazz.getPackage().getName().replace(".", "/") + "/" + name + ".properties";
        return result;
    }
}

