/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.util;

import com.sqlapp.util.StringUtils;
import java.lang.invoke.MethodHandles;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MessageReader {
    protected static Logger log = LogManager.getLogger(MethodHandles.lookup().lookupClass());
    private ResourceBundle bundle = null;
    private final String path = this.getClass().getPackage().getName() + ".messages";

    protected MessageReader() {
    }

    private ResourceBundle getResourceBundle() {
        if (this.bundle != null) {
            return this.bundle;
        }
        try {
            this.bundle = ResourceBundle.getBundle(this.getResourceName());
        }
        catch (MissingResourceException e1) {
            try {
                this.bundle = ResourceBundle.getBundle(this.getResourceName(), Locale.getDefault(), Thread.currentThread().getContextClassLoader());
            }
            catch (MissingResourceException e2) {
                log.error("MessagePropertyReader.getInstance()", (Throwable)e2);
                throw e2;
            }
        }
        return this.bundle;
    }

    public static MessageReader getInstance() {
        return LazyHolder.singleton;
    }

    protected String getResourceName() {
        return this.path;
    }

    public String getMessage(String messageID) {
        String value = this.getResourceBundle().getString(messageID);
        return value;
    }

    public String getMessage(String messageID, Object ... args) {
        return StringUtils.printf(this.getMessage(messageID), args);
    }

    private static class LazyHolder {
        public static MessageReader singleton = new MessageReader();

        private LazyHolder() {
        }
    }
}

