/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public enum MessageDigests {
    MD2("MD2"),
    MD5("MD5"),
    SHA("SHA"),
    SHA224("SHA-224"),
    SHA256("SHA-256"),
    SHA384("SHA-384"),
    SHA512("SHA-512");

    private String value;

    private MessageDigests(String value) {
        this.value = value;
    }

    public String getValue() {
        return this.value;
    }

    public byte[] checksum(File file) {
        byte[] byArray;
        FileInputStream in = new FileInputStream(file);
        try {
            byArray = this.checksum(in);
        }
        catch (Throwable throwable) {
            try {
                try {
                    in.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (FileNotFoundException e) {
                throw new RuntimeException(e);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        in.close();
        return byArray;
    }

    public String checksumAsString(File file) {
        return MessageDigests.toHex(this.checksum(file));
    }

    public byte[] checksum(InputStream in) {
        try {
            int length;
            MessageDigest digester = MessageDigest.getInstance(this.getValue());
            byte[] block = new byte[4096];
            while ((length = in.read(block)) > 0) {
                digester.update(block, 0, length);
            }
            return digester.digest();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    public String checksumAsString(InputStream in) {
        return MessageDigests.toHex(this.checksum(in));
    }

    public byte[] checksum(byte[] bytes) {
        try {
            MessageDigest digester = MessageDigest.getInstance(this.getValue());
            digester.update(bytes, 0, bytes.length);
            return digester.digest();
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    public byte[] checksum(String ... args) {
        try {
            MessageDigest digester = MessageDigest.getInstance(this.getValue());
            for (String arg : args) {
                digester.update(arg.getBytes("UTF8"));
            }
            return digester.digest();
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public String checksumAsString(byte[] bytes) {
        return MessageDigests.toHex(this.checksum(bytes));
    }

    public static String toHex(byte[] bytes) {
        if (bytes == null) {
            return null;
        }
        StringBuilder buf = new StringBuilder(bytes.length * 2);
        for (int i = 0; i < bytes.length; ++i) {
            int b = bytes[i];
            if (b < 0) {
                b += 256;
            }
            if (b < 16) {
                buf.append("0");
            }
            buf.append(Integer.toString(b, 16));
        }
        return buf.toString();
    }
}

