/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.util;

import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.DeserializationConfig;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.deser.Deserializers;
import com.fasterxml.jackson.databind.deser.std.EnumDeserializer;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.util.EnumResolver;
import com.sqlapp.data.converter.EnumConvertable;
import com.sqlapp.util.AbstractJsonConverter;
import com.sqlapp.util.EnumUtils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.ZonedDateTime;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class JsonConverter
extends AbstractJsonConverter<ObjectMapper>
implements Cloneable {
    protected static final Logger LOGGER = LogManager.getLogger(JsonConverter.class);
    protected final ObjectMapper objectMapper = this.createObjectMapper();
    private boolean failOnUnknownProperties = false;
    private boolean indentOutput;

    public JsonConverter() {
        this.initialize(this.objectMapper);
    }

    public JsonConverter(boolean utc) {
        super(utc);
        this.initialize(this.objectMapper);
    }

    protected ObjectMapper createObjectMapper() {
        return new ObjectMapper();
    }

    protected void initialize(ObjectMapper objectMapper) {
        this.initializeEnum();
        SimpleModule instantModule = new SimpleModule("InstantModule", new Version(1, 0, 0, null, null, null)).addSerializer(Instant.class, (JsonSerializer)new InstantSerializer()).addDeserializer(Instant.class, (JsonDeserializer)new InstantDeserializer());
        objectMapper.registerModule((Module)instantModule);
        SimpleModule localDateTimeModule = new SimpleModule("LocalDateTimeModule", new Version(1, 0, 0, null, null, null)).addSerializer(LocalDateTime.class, (JsonSerializer)new LocalDateTimeSerializer()).addDeserializer(LocalDateTime.class, (JsonDeserializer)new LocalDateTimeDeserializer());
        objectMapper.registerModule((Module)localDateTimeModule);
        SimpleModule offsetDateTimeModule = new SimpleModule("offsetDateTimeModule", new Version(1, 0, 0, null, null, null)).addSerializer(OffsetDateTime.class, (JsonSerializer)new OffsetDateTimeSerializer()).addDeserializer(OffsetDateTime.class, (JsonDeserializer)new OffsetDateTimeDeserializer());
        objectMapper.registerModule((Module)offsetDateTimeModule);
        SimpleModule zonedDateTimeModule = new SimpleModule("zonedDateTimeModule", new Version(1, 0, 0, null, null, null)).addSerializer(ZonedDateTime.class, (JsonSerializer)new ZonedDateTimeSerializer()).addDeserializer(ZonedDateTime.class, (JsonDeserializer)new ZonedDateTimeDeserializer());
        objectMapper.registerModule((Module)zonedDateTimeModule);
        SimpleModule calendarModule = new SimpleModule("CalendarModule", new Version(1, 0, 0, null, null, null)).addSerializer(Calendar.class, (JsonSerializer)new CalendarSerializer()).addDeserializer(Calendar.class, (JsonDeserializer)new CalendarDeserializer());
        objectMapper.registerModule((Module)calendarModule);
        SimpleModule dateModule = new SimpleModule("DateModule", new Version(1, 0, 0, null, null, null)).addSerializer(Date.class, (JsonSerializer)new DateSerializer()).addDeserializer(Date.class, (JsonDeserializer)new DateDeserializer());
        objectMapper.registerModule((Module)dateModule);
        this.setFailOnUnknownProperties(this.failOnUnknownProperties);
        this.setIndentOutput(this.indentOutput);
    }

    protected void initializeEnum() {
        this.objectMapper.getDeserializationConfig().with(DeserializationFeature.ACCEPT_EMPTY_STRING_AS_NULL_OBJECT);
        this.objectMapper.registerModule((Module)new EnumMapperModule());
    }

    @Override
    public ObjectMapper getObjectMapper() {
        return this.objectMapper;
    }

    @Override
    public String toJsonString(Object value) {
        try {
            String result = this.getObjectMapper().writeValueAsString(value);
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace("value=" + value);
            }
            return result;
        }
        catch (JsonGenerationException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public <S> S fromJsonString(String value, Class<S> clazz) {
        try {
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace("value=" + value);
            }
            return (S)this.getObjectMapper().readValue(value, clazz);
        }
        catch (JsonGenerationException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public <S> S fromJsonString(String value, TypeReference<S> type) {
        try {
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace("value=" + value);
            }
            return (S)this.getObjectMapper().readValue(value, type);
        }
        catch (JsonGenerationException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public <T> T fromJsonString(InputStream value, Class<T> clazz) {
        try {
            if (LOGGER.isTraceEnabled()) {
                String val = this.inputStreamToString(value);
                return this.fromJsonString(val, clazz);
            }
            return (T)this.getObjectMapper().readValue(value, clazz);
        }
        catch (JsonGenerationException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public <T> T fromJsonString(InputStream value, TypeReference<T> type) {
        try {
            if (LOGGER.isTraceEnabled()) {
                String val = this.inputStreamToString(value);
                return this.fromJsonString(val, type);
            }
            return (T)this.getObjectMapper().readValue(value, type);
        }
        catch (JsonGenerationException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public <T> T fromJsonString(File file, TypeReference<T> clazz) {
        try {
            return (T)this.getObjectMapper().readValue(file, clazz);
        }
        catch (JsonGenerationException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public <T> T fromJsonString(File file, Class<T> clazz) {
        try {
            return (T)this.getObjectMapper().readValue(file, clazz);
        }
        catch (JsonGenerationException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void writeJsonValue(OutputStream ostream, Object value) {
        try {
            this.getObjectMapper().writeValue(ostream, value);
        }
        catch (JsonGenerationException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void writeJsonValue(File file, Object value) {
        try {
            this.getObjectMapper().writeValue(file, value);
        }
        catch (JsonGenerationException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void setFailOnUnknownProperties(boolean failOnUnknownProperties) {
        this.failOnUnknownProperties = failOnUnknownProperties;
        this.objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, this.failOnUnknownProperties);
    }

    public void setIndentOutput(boolean indentOutput) {
        this.indentOutput = indentOutput;
        this.objectMapper.configure(SerializationFeature.INDENT_OUTPUT, this.indentOutput);
    }

    public boolean isFailOnUnknownProperties() {
        return this.failOnUnknownProperties;
    }

    public JsonConverter clone() {
        JsonConverter clone = new JsonConverter(this.isUtc());
        clone.setFailOnUnknownProperties(this.isFailOnUnknownProperties());
        clone.setIndentOutput(this.indentOutput);
        return clone;
    }

    static class ZonedDateTimeDeserializer
    extends JsonDeserializer<ZonedDateTime> {
        ZonedDateTimeDeserializer() {
        }

        public ZonedDateTime deserialize(JsonParser jsonParser, DeserializationContext paramDeserializationContext) throws IOException, JsonProcessingException {
            if (jsonParser.getText() == null || jsonParser.getText().length() == 0) {
                return null;
            }
            ZonedDateTime dateTime = AbstractJsonConverter.toDateTime(jsonParser.getText());
            return dateTime;
        }
    }

    class ZonedDateTimeSerializer
    extends JsonSerializer<ZonedDateTime> {
        ZonedDateTimeSerializer() {
        }

        public void serialize(ZonedDateTime value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonProcessingException {
            jgen.writeString(JsonConverter.this.format(value));
        }
    }

    static class OffsetDateTimeDeserializer
    extends JsonDeserializer<OffsetDateTime> {
        OffsetDateTimeDeserializer() {
        }

        public OffsetDateTime deserialize(JsonParser jsonParser, DeserializationContext paramDeserializationContext) throws IOException, JsonProcessingException {
            if (jsonParser.getText() == null || jsonParser.getText().length() == 0) {
                return null;
            }
            ZonedDateTime dateTime = AbstractJsonConverter.toDateTime(jsonParser.getText());
            return dateTime.toOffsetDateTime();
        }
    }

    class OffsetDateTimeSerializer
    extends JsonSerializer<OffsetDateTime> {
        OffsetDateTimeSerializer() {
        }

        public void serialize(OffsetDateTime value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonProcessingException {
            jgen.writeString(JsonConverter.this.format(value));
        }
    }

    static class LocalDateTimeDeserializer
    extends JsonDeserializer<LocalDateTime> {
        LocalDateTimeDeserializer() {
        }

        public LocalDateTime deserialize(JsonParser jsonParser, DeserializationContext paramDeserializationContext) throws IOException, JsonProcessingException {
            if (jsonParser.getText() == null || jsonParser.getText().length() == 0) {
                return null;
            }
            ZonedDateTime dateTime = AbstractJsonConverter.toDateTime(jsonParser.getText());
            return dateTime.toLocalDateTime();
        }
    }

    class LocalDateTimeSerializer
    extends JsonSerializer<LocalDateTime> {
        LocalDateTimeSerializer() {
        }

        public void serialize(LocalDateTime value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonProcessingException {
            jgen.writeString(JsonConverter.this.format(value));
        }
    }

    static class InstantDeserializer
    extends JsonDeserializer<Instant> {
        InstantDeserializer() {
        }

        public Instant deserialize(JsonParser jsonParser, DeserializationContext paramDeserializationContext) throws IOException, JsonProcessingException {
            if (jsonParser.getText() == null || jsonParser.getText().length() == 0) {
                return null;
            }
            ZonedDateTime dateTime = AbstractJsonConverter.toDateTime(jsonParser.getText());
            return dateTime.toInstant();
        }
    }

    class InstantSerializer
    extends JsonSerializer<Instant> {
        InstantSerializer() {
        }

        public void serialize(Instant value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonProcessingException {
            jgen.writeString(JsonConverter.this.format(value));
        }
    }

    static class CalendarDeserializer
    extends JsonDeserializer<Calendar> {
        CalendarDeserializer() {
        }

        public Calendar deserialize(JsonParser jsonParser, DeserializationContext paramDeserializationContext) throws IOException, JsonProcessingException {
            if (jsonParser.getText() == null || jsonParser.getText().length() == 0) {
                return null;
            }
            return AbstractJsonConverter.toCalendar(jsonParser.getText());
        }
    }

    class CalendarSerializer
    extends JsonSerializer<Calendar> {
        CalendarSerializer() {
        }

        public void serialize(Calendar value, JsonGenerator paramJsonGenerator, SerializerProvider paramSerializerProvider) throws IOException, JsonGenerationException {
            paramJsonGenerator.writeString(JsonConverter.this.format(value));
        }
    }

    static class DateDeserializer
    extends JsonDeserializer<Date> {
        DateDeserializer() {
        }

        public Date deserialize(JsonParser jsonParser, DeserializationContext paramDeserializationContext) throws IOException, JsonProcessingException {
            if (jsonParser.getText() == null || jsonParser.getText().length() == 0) {
                return null;
            }
            Date date = AbstractJsonConverter.toDate(jsonParser.getText());
            return date;
        }
    }

    class DateSerializer
    extends JsonSerializer<Date> {
        DateSerializer() {
        }

        public void serialize(Date value, JsonGenerator paramJsonGenerator, SerializerProvider paramSerializerProvider) throws IOException, JsonGenerationException {
            String text = JsonConverter.this.format(value);
            paramJsonGenerator.writeString(text);
        }
    }

    static class ExEnumResolver
    extends EnumResolver {
        private static final long serialVersionUID = 1L;

        protected ExEnumResolver(Class<Enum<?>> enumClass, Enum<?>[] enums, HashMap<String, Enum<?>> map, Enum<?> defaultValue, boolean isIgnoreCase, boolean isFromIntValue) {
            super(enumClass, (Enum[])enums, map, defaultValue, isIgnoreCase, isFromIntValue);
        }

        protected ExEnumResolver(Class<Enum<?>> enumClass, Enum<?>[] enums, HashMap<String, Enum<?>> map) {
            super(enumClass, (Enum[])enums, map, null, false, false);
        }

        public Enum<?> findEnum(String key) {
            return EnumUtils.parse(this.getEnumClass(), key);
        }

        public Enum<?> getEnum(int index) {
            return EnumUtils.parse(this.getEnumClass(), index);
        }
    }

    static class ExEnumDeserializer
    extends EnumDeserializer {
        private static final long serialVersionUID = 1L;

        public ExEnumDeserializer(Class<?> res) {
            super(ExEnumDeserializer.createResolver(res), Boolean.valueOf(false));
        }

        private static EnumResolver createResolver(Class<?> cls) {
            Class<Enum<?>> enumCls = cls;
            Enum[] enumValues = (Enum[])enumCls.getEnumConstants();
            HashMap map = new HashMap();
            int i = enumValues.length;
            while (--i >= 0) {
                Enum e = enumValues[i];
                map.put(e.toString(), e);
                if (!(e instanceof EnumConvertable)) continue;
                map.put(((EnumConvertable)((Object)e)).getValue().toString(), e);
            }
            return new ExEnumResolver(enumCls, enumValues, map);
        }

        public Object deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            String name;
            JsonToken curr = jp.getCurrentToken();
            if ((curr == JsonToken.VALUE_STRING || curr == JsonToken.FIELD_NAME) && "".equals(name = jp.getText())) {
                return null;
            }
            return super.deserialize(jp, ctxt);
        }
    }

    public class EnumMapperModule
    extends Module {
        public String getModuleName() {
            return "EnumMapper";
        }

        public Version version() {
            return new Version(2, 0, 0, null, null, null);
        }

        public void setupModule(Module.SetupContext context) {
            context.addDeserializers((Deserializers)new Deserializers.Base(){

                public JsonDeserializer<?> findEnumDeserializer(Class<?> type, DeserializationConfig config, BeanDescription beanDesc) throws JsonMappingException {
                    return new ExEnumDeserializer(type);
                }
            });
        }
    }
}

