/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.util;

public class JavaVmInfo {
    private Version version = new Version();
    private String home = System.getProperty("java.home");
    private static JavaVmInfo instance = new JavaVmInfo();

    public static JavaVmInfo getInstance() {
        return instance;
    }

    private JavaVmInfo() {
    }

    public String getHome() {
        return this.home;
    }

    public Version getVersion() {
        return this.version;
    }

    public static class Version {
        private int minor = 0;
        private String maintenance = null;
        private Specification specification = new Specification();

        Version() {
            String val = System.getProperty("java.version");
            String[] splits = val.split("\\.");
            int i = 0;
            this.specification.setBase(Integer.valueOf(splits[i++]));
            this.specification.setMajor(Integer.valueOf(splits[i++]));
            String last = splits[i++];
            this.setMaintenance(last);
        }

        public Specification getSpecification() {
            return this.specification;
        }

        public int getMinor() {
            return this.minor;
        }

        public void setMinor(int minor) {
            this.minor = minor;
        }

        public String getMaintenance() {
            return this.maintenance;
        }

        public void setMaintenance(String maintenance) {
            this.maintenance = maintenance;
        }

        public static class Specification {
            private int base = 0;
            private int major = 0;

            public int getBase() {
                return this.base;
            }

            protected void setBase(int base) {
                this.base = base;
            }

            public int getMajor() {
                return this.major;
            }

            protected void setMajor(int major) {
                this.major = major;
            }

            public boolean gt(int base, int major) {
                if (this.getBase() > base) {
                    return true;
                }
                if (this.getBase() < base) {
                    return false;
                }
                return this.getMajor() > major;
            }

            public boolean gte(int base, int major) {
                if (this.gt(base, major)) {
                    return true;
                }
                return this.getBase() == base && this.getMajor() == major;
            }

            public boolean lt(int base, int major) {
                if (this.getBase() < base) {
                    return true;
                }
                if (this.getBase() > base) {
                    return false;
                }
                return this.getMajor() < major;
            }

            public boolean lte(int base, int major) {
                if (this.lt(base, major)) {
                    return true;
                }
                return this.getBase() == base && this.getMajor() == major;
            }
        }
    }
}

