/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.util;

import com.sqlapp.util.CommonUtils;
import java.time.DayOfWeek;
import java.time.Duration;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.Month;
import java.time.MonthDay;
import java.time.OffsetDateTime;
import java.time.Year;
import java.time.YearMonth;
import java.time.ZonedDateTime;
import java.time.chrono.ChronoLocalDate;
import java.time.chrono.HijrahDate;
import java.time.chrono.JapaneseDate;
import java.time.chrono.MinguoDate;
import java.time.chrono.ThaiBuddhistDate;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoField;
import java.time.temporal.ChronoUnit;
import java.time.temporal.Temporal;
import java.util.List;
import java.util.Map;

public final class Java8DateUtils {
    public static final String DEFAULT_DATETIME_FORMAT = "yyyy-MM-dd HH:mm:ss";
    public static final String DEFAULT_TIME_FORMAT = "HH:mm:ss";
    public static final String DEFAULT_DATE_FORMAT = "yyyy-MM-dd";
    private static Map<String, DateTimeFormatter> formatters = CommonUtils.map();

    private Java8DateUtils() {
    }

    public static LocalDate currentDate() {
        return LocalDate.now();
    }

    public static LocalDateTime currentDateTime() {
        return LocalDateTime.now();
    }

    public static LocalDateTime currentTimestamp() {
        return LocalDateTime.now();
    }

    public static LocalTime currentTime() {
        return LocalTime.now();
    }

    public static LocalTime truncateMilisecond(LocalTime date) {
        if (date == null) {
            return null;
        }
        return date.truncatedTo(ChronoUnit.SECONDS);
    }

    public static LocalDateTime truncateMilisecond(LocalDateTime date) {
        if (date == null) {
            return null;
        }
        return date.truncatedTo(ChronoUnit.SECONDS);
    }

    public static OffsetDateTime truncateMilisecond(OffsetDateTime date) {
        if (date == null) {
            return null;
        }
        return date.truncatedTo(ChronoUnit.SECONDS);
    }

    public static ZonedDateTime truncateMilisecond(ZonedDateTime date) {
        if (date == null) {
            return null;
        }
        return date.truncatedTo(ChronoUnit.SECONDS);
    }

    public static OffsetDateTime truncateTime(OffsetDateTime date) {
        if (date == null) {
            return null;
        }
        return date.truncatedTo(ChronoUnit.DAYS);
    }

    public static ZonedDateTime truncateTime(ZonedDateTime date) {
        if (date == null) {
            return null;
        }
        return date.truncatedTo(ChronoUnit.DAYS);
    }

    public static LocalDateTime truncateTime(LocalDateTime date) {
        if (date == null) {
            return null;
        }
        return date.truncatedTo(ChronoUnit.DAYS);
    }

    public static <T extends Temporal> T addSeconds(T date, int seconds) {
        if (date == null) {
            return null;
        }
        return (T)date.plus(Duration.ofSeconds(seconds));
    }

    public static <T extends Temporal> T addMinutes(T date, int minutes) {
        if (date == null) {
            return null;
        }
        return (T)date.plus(Duration.ofMinutes(minutes));
    }

    public static <T extends Temporal> T addHours(T date, int hours) {
        if (date == null) {
            return null;
        }
        return (T)date.plus(Duration.ofHours(hours));
    }

    public static <T extends Temporal> T addDays(T date, int days) {
        if (date == null) {
            return null;
        }
        if (date instanceof ChronoLocalDate) {
            if (date instanceof LocalDate) {
                LocalDate localDate = (LocalDate)date;
                return (T)localDate.plus(days, ChronoUnit.DAYS);
            }
            if (date instanceof HijrahDate) {
                HijrahDate localDate = (HijrahDate)date;
                return (T)localDate.plus(days, ChronoUnit.DAYS);
            }
            if (date instanceof JapaneseDate) {
                JapaneseDate localDate = (JapaneseDate)date;
                return (T)localDate.plus(days, ChronoUnit.DAYS);
            }
            if (date instanceof MinguoDate) {
                MinguoDate localDate = (MinguoDate)date;
                return (T)localDate.plus(days, ChronoUnit.DAYS);
            }
            if (date instanceof ThaiBuddhistDate) {
                ThaiBuddhistDate localDate = (ThaiBuddhistDate)date;
                return (T)localDate.plus(days, ChronoUnit.DAYS);
            }
        }
        return (T)date.plus(Duration.ofDays(days));
    }

    public static MonthDay addDays(MonthDay date, int days) {
        if (date == null) {
            return null;
        }
        return MonthDay.of(date.getMonthValue(), date.getDayOfMonth() + days);
    }

    public static <T extends Temporal> T addMonths(T date, int months) {
        if (date == null) {
            return null;
        }
        if (date instanceof ChronoLocalDate) {
            if (date instanceof LocalDate) {
                return (T)((LocalDate)date).plusMonths(months);
            }
            if (date instanceof HijrahDate) {
                HijrahDate localDate = (HijrahDate)date;
                return (T)localDate.plus(months, ChronoUnit.MONTHS);
            }
            if (date instanceof JapaneseDate) {
                JapaneseDate localDate = (JapaneseDate)date;
                return (T)localDate.plus(months, ChronoUnit.MONTHS);
            }
            if (date instanceof MinguoDate) {
                MinguoDate localDate = (MinguoDate)date;
                return (T)localDate.plus(months, ChronoUnit.MONTHS);
            }
            if (date instanceof ThaiBuddhistDate) {
                ThaiBuddhistDate localDate = (ThaiBuddhistDate)date;
                return (T)localDate.plus(months, ChronoUnit.MONTHS);
            }
        } else {
            if (date instanceof LocalDateTime) {
                return (T)((LocalDateTime)date).plusMonths(months);
            }
            if (date instanceof OffsetDateTime) {
                return (T)((OffsetDateTime)date).plusMonths(months);
            }
            if (date instanceof ZonedDateTime) {
                return (T)((ZonedDateTime)date).plusMonths(months);
            }
            if (date instanceof YearMonth) {
                return (T)((YearMonth)date).plusMonths(months);
            }
        }
        return (T)date.plus(Duration.of(months, ChronoUnit.MONTHS));
    }

    public static YearMonth addMonths(YearMonth date, int months) {
        if (date == null) {
            return null;
        }
        return date.plusMonths(months);
    }

    public static Month addMonths(Month date, int months) {
        if (date == null) {
            return null;
        }
        return date.plus(months);
    }

    public static MonthDay addMonths(MonthDay date, int months) {
        if (date == null) {
            return null;
        }
        return MonthDay.of(date.getMonthValue() + months, date.getDayOfMonth());
    }

    public static <T extends Temporal> T addYears(T date, int years) {
        if (date == null) {
            return null;
        }
        if (date instanceof LocalDate) {
            return (T)((LocalDate)date).plusYears(years);
        }
        if (date instanceof LocalDateTime) {
            return (T)((LocalDateTime)date).plusYears(years);
        }
        if (date instanceof OffsetDateTime) {
            return (T)((OffsetDateTime)date).plusYears(years);
        }
        if (date instanceof ZonedDateTime) {
            return (T)((ZonedDateTime)date).plusYears(years);
        }
        if (date instanceof YearMonth) {
            return (T)((YearMonth)date).plusYears(years);
        }
        return (T)date.plus(Duration.of(years, ChronoUnit.YEARS));
    }

    public static YearMonth addYears(YearMonth date, int years) {
        if (date == null) {
            return null;
        }
        return date.plusYears(years);
    }

    public static Year addYears(Year date, int years) {
        if (date == null) {
            return null;
        }
        return date.plusYears(years);
    }

    public static <T extends Temporal> String format(T date, String format) {
        DateTimeFormatter dateFormat = Java8DateUtils.getDateTimeFormatter(format);
        return dateFormat.format(date);
    }

    public static DateTimeFormatter getDateTimeFormatter(String format) {
        DateTimeFormatter dateFormat = formatters.get(format);
        if (dateFormat == null) {
            dateFormat = DateTimeFormatter.ofPattern(format);
            formatters.put(format, dateFormat);
        }
        return dateFormat;
    }

    public static DateTimeFormatter[] getDateTimeFormatters(String ... formats) {
        if (CommonUtils.isEmpty(formats)) {
            return new DateTimeFormatter[0];
        }
        List<DateTimeFormatter> results = CommonUtils.list();
        for (String format : CommonUtils.linkedSet(formats)) {
            DateTimeFormatter formatter = Java8DateUtils.getDateTimeFormatter(format);
            results.add(formatter);
        }
        return results.toArray(new DateTimeFormatter[0]);
    }

    public static ZonedDateTime beginningOfQuarter(ZonedDateTime date, int accountingPeriod) {
        ZonedDateTime cal = date.withMonth(accountingPeriod);
        cal = cal.plusMonths(1L);
        cal = cal.withDayOfMonth(1);
        if ((cal = Java8DateUtils.truncateTime(cal)).compareTo(date) == 0) {
            return date;
        }
        if (cal.compareTo(date) < 0) {
            cal = cal.plusYears(1L);
        }
        for (int i = 0; i < 8; ++i) {
            if (cal.compareTo(date) <= 0) {
                return cal;
            }
            cal = cal.plusMonths(-3L);
        }
        return null;
    }

    public static <T extends Temporal> T beginningOfYear(T date) {
        return (T)date.with(ChronoField.DAY_OF_MONTH, 1L).with(ChronoField.MONTH_OF_YEAR, 1L);
    }

    public static ZonedDateTime beginningOfYear(ZonedDateTime date) {
        return date.withDayOfMonth(1).withMonth(1);
    }

    public static ZonedDateTime beginningOfMonth(ZonedDateTime date) {
        return date.withDayOfMonth(1);
    }

    public static <T extends Temporal> T sunday(T date) {
        return (T)date.with(ChronoField.DAY_OF_WEEK, DayOfWeek.SUNDAY.getValue());
    }

    public static <T extends Temporal> T monday(T date) {
        return (T)date.with(ChronoField.DAY_OF_WEEK, DayOfWeek.MONDAY.getValue());
    }
}

