/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.util;

import com.sqlapp.util.AbstractJarHandler;
import com.sqlapp.util.AbstractResourceSearcher;
import com.sqlapp.util.ResourceFinder;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.List;
import java.util.jar.JarEntry;

public class JarResourceSearcher
extends AbstractResourceSearcher {
    private static final String[] PROTOCOLS = new String[]{"jar", "zip", "vfszip"};

    @Override
    public <T> List<ResourceFinder.ResourceInfo> search(String rootPackageName, URL url, boolean recursive) {
        AbstractJarHandler<ResourceFinder.ResourceInfo, ResourceFinder.ResourceInfo> jarHandler = new AbstractJarHandler<ResourceFinder.ResourceInfo, ResourceFinder.ResourceInfo>(this.getClassLoader(), this.getFilter()){

            @Override
            protected void handleJarEntry(JarEntry jarEntry, String packageNameAsResourceName, boolean recursive, List<ResourceFinder.ResourceInfo> resources) {
                if (recursive) {
                    if (jarEntry.getName().startsWith(packageNameAsResourceName) && JarResourceSearcher.this.isResourceFile(jarEntry.getName())) {
                        URI uri;
                        try {
                            uri = this.getClassLoader().getResource(jarEntry.getName()).toURI();
                        }
                        catch (URISyntaxException e) {
                            throw new RuntimeException(e);
                        }
                        ResourceFinder.ResourceInfo resourceInfo = new ResourceFinder.ResourceInfo(uri, this.getClassLoader(), JarResourceSearcher.this.getPackage(jarEntry.getName()), JarResourceSearcher.this.getFileName(jarEntry.getName()));
                        if (this.getFilter().test(resourceInfo)) {
                            resources.add(resourceInfo);
                        }
                    }
                } else {
                    if (!this.equalsPackage(jarEntry, packageNameAsResourceName)) {
                        return;
                    }
                    if (JarResourceSearcher.this.isResourceFile(jarEntry.getName())) {
                        URI uri;
                        try {
                            uri = this.getClassLoader().getResource(jarEntry.getName()).toURI();
                        }
                        catch (URISyntaxException e) {
                            throw new RuntimeException(e);
                        }
                        ResourceFinder.ResourceInfo resourceInfo = new ResourceFinder.ResourceInfo(uri, this.getClassLoader(), JarResourceSearcher.this.getPackage(jarEntry.getName()), JarResourceSearcher.this.getFileName(jarEntry.getName()));
                        if (this.getFilter().test(resourceInfo)) {
                            resources.add(resourceInfo);
                        }
                    }
                }
            }
        };
        return jarHandler.search(rootPackageName, url, recursive);
    }

    @Override
    public String[] supportProtocols() {
        return PROTOCOLS;
    }
}

