/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.util;

import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class HashCodeBuilder
implements Serializable {
    private static final long serialVersionUID = 1752507174479245520L;
    private int multiplier = 37;
    private int seed = 53;
    private boolean caseSensitive = true;

    public HashCodeBuilder(boolean caseSensitive) {
        this(53, true);
    }

    public HashCodeBuilder() {
    }

    public HashCodeBuilder(int seed) {
        this(seed, true);
    }

    public HashCodeBuilder(int seed, boolean caseSensitive) {
        this.seed = seed;
        this.caseSensitive = caseSensitive;
    }

    public HashCodeBuilder append(int val) {
        this.seed = this.seed * this.multiplier + val;
        return this;
    }

    private HashCodeBuilder append() {
        this.seed *= this.multiplier;
        return this;
    }

    public HashCodeBuilder append(int[] vals) {
        for (int i = 0; i < vals.length; ++i) {
            this.append(vals[i]);
        }
        return this;
    }

    public HashCodeBuilder append(Integer[] vals) {
        for (int i = 0; i < vals.length; ++i) {
            this.append(vals[i]);
        }
        return this;
    }

    public HashCodeBuilder append(Integer val) {
        if (val == null) {
            return this.append();
        }
        return this.append((int)val);
    }

    public HashCodeBuilder append(long val) {
        this.seed = this.seed * this.multiplier + (int)(val ^ val >>> 32);
        return this;
    }

    public HashCodeBuilder append(Long val) {
        if (val == null) {
            return this.append();
        }
        return this.append((long)val);
    }

    public HashCodeBuilder append(long[] vals) {
        for (int i = 0; i < vals.length; ++i) {
            this.append(vals[i]);
        }
        return this;
    }

    public HashCodeBuilder append(Long[] vals) {
        for (int i = 0; i < vals.length; ++i) {
            this.append(vals[i]);
        }
        return this;
    }

    public HashCodeBuilder append(short val) {
        return this.append((int)val);
    }

    public HashCodeBuilder append(Short val) {
        if (val == null) {
            return this.append();
        }
        return this.append(val.intValue());
    }

    public HashCodeBuilder append(short[] vals) {
        for (int i = 0; i < vals.length; ++i) {
            this.append(vals[i]);
        }
        return this;
    }

    public HashCodeBuilder append(Short[] vals) {
        for (int i = 0; i < vals.length; ++i) {
            this.append(vals[i]);
        }
        return this;
    }

    public HashCodeBuilder append(float val) {
        return this.append(Float.floatToIntBits(val));
    }

    public HashCodeBuilder append(Float val) {
        if (val == null) {
            return this.append();
        }
        return this.append(val.floatValue());
    }

    public HashCodeBuilder append(float[] vals) {
        for (int i = 0; i < vals.length; ++i) {
            this.append(vals[i]);
        }
        return this;
    }

    public HashCodeBuilder append(Float[] vals) {
        for (int i = 0; i < vals.length; ++i) {
            this.append(vals[i]);
        }
        return this;
    }

    public HashCodeBuilder append(double val) {
        return this.append(Double.doubleToLongBits(val));
    }

    public HashCodeBuilder append(Double val) {
        if (val == null) {
            return this.append();
        }
        return this.append((double)val);
    }

    public HashCodeBuilder append(double[] vals) {
        for (int i = 0; i < vals.length; ++i) {
            this.append(vals[i]);
        }
        return this;
    }

    public HashCodeBuilder append(Double[] vals) {
        for (int i = 0; i < vals.length; ++i) {
            this.append(vals[i]);
        }
        return this;
    }

    public HashCodeBuilder append(boolean val) {
        return this.append(val ? 1 : 0);
    }

    public HashCodeBuilder append(Boolean val) {
        if (val == null) {
            return this.append();
        }
        return this.append((boolean)val);
    }

    public HashCodeBuilder append(boolean[] vals) {
        for (int i = 0; i < vals.length; ++i) {
            this.append(vals[i]);
        }
        return this;
    }

    public HashCodeBuilder append(Boolean[] vals) {
        for (int i = 0; i < vals.length; ++i) {
            this.append(vals[i]);
        }
        return this;
    }

    public HashCodeBuilder append(Object val) {
        if (val == null) {
            return this.append();
        }
        this.append(val.hashCode());
        return this;
    }

    public HashCodeBuilder append(Object[] vals) {
        if (vals == null) {
            return this.append();
        }
        for (int i = 0; i < vals.length; ++i) {
            this.append(vals[i]);
        }
        return this;
    }

    public HashCodeBuilder append(Collection<Object> vals) {
        if (vals == null) {
            return this.append();
        }
        for (Object val : vals) {
            this.append(val);
        }
        return this;
    }

    public HashCodeBuilder append(List<Object> vals) {
        if (vals == null) {
            return this.append();
        }
        int size = vals.size();
        for (int i = 0; i < size; ++i) {
            this.append(vals.get(i));
        }
        return this;
    }

    public HashCodeBuilder append(String val) {
        if (val == null) {
            return this.append();
        }
        if (this.caseSensitive) {
            return this.append(val.hashCode());
        }
        return this.append(val.toUpperCase().hashCode());
    }

    public HashCodeBuilder append(String[] vals) {
        for (int i = 0; i < vals.length; ++i) {
            this.append(vals[i]);
        }
        return this;
    }

    public int hashCode() {
        return this.seed;
    }
}

