/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.util;

import com.sqlapp.util.CommonUtils;
import com.sqlapp.util.ToStringBuilder;
import java.util.Comparator;
import java.util.List;
import java.util.Map;

public class Diff<T> {
    protected final List<T> list1;
    protected final List<T> list2;
    protected final List<T> lcs = CommonUtils.list();
    protected Comparator<T> comparator;
    private final Map<Integer, T> map1 = CommonUtils.linkedMap();
    private final Map<Integer, T> map2 = CommonUtils.linkedMap();

    public Diff(List<T> list1, List<T> list2, Comparator<T> comp) {
        this.list1 = list1;
        this.list2 = list2;
        this.comparator = comp;
        this.initLongestCommonSubSequences(this.list1, this.list2);
    }

    public Diff(List<T> a, List<T> b) {
        this(a, b, null);
    }

    public Map<Integer, T> getLcs1() {
        return this.map1;
    }

    public Map<Integer, T> getLcs2() {
        return this.map2;
    }

    private void initLongestCommonSubSequences(List<T> list1, List<T> list2) {
        T obj2;
        int i;
        int size1 = list1.size();
        int size2 = list2.size();
        int[][] lengths = new int[size1 + 1][size2 + 1];
        for (i = size1 - 1; i >= 0; --i) {
            T obj1 = list1.get(i);
            for (int j = size2 - 1; j >= 0; --j) {
                obj2 = list2.get(j);
                lengths[i][j] = this.eq(obj1, obj2) ? lengths[i + 1][j + 1] + 1 : Math.max(lengths[i + 1][j], lengths[i][j + 1]);
            }
        }
        i = 0;
        int j = 0;
        while (i < size1 && j < size2) {
            T obj1 = list1.get(i);
            if (this.eq(obj1, obj2 = list2.get(j))) {
                this.lcs.add(obj1);
                this.map1.put(i, obj1);
                this.map2.put(j, obj2);
                ++i;
                ++j;
                continue;
            }
            if (lengths[i + 1][j] >= lengths[i][j + 1]) {
                ++i;
                continue;
            }
            ++j;
        }
    }

    public List<T> getLcs() {
        return this.lcs;
    }

    protected boolean eq(T a, T b) {
        if (this.comparator != null) {
            return this.comparator.compare(a, b) == 0;
        }
        if (a == null) {
            return b == null;
        }
        return a.equals(b);
    }

    public String toString() {
        ToStringBuilder builder = new ToStringBuilder(this.getClass());
        builder.add("lcs1", this.getLcs1());
        builder.add("lcs2", this.getLcs2());
        return builder.toString();
    }
}

