/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.util;

import com.sqlapp.data.converter.Converters;
import com.sqlapp.data.db.dialect.Dialect;
import com.sqlapp.data.db.dialect.DialectResolver;
import com.sqlapp.data.db.sql.SqlOperation;
import com.sqlapp.data.schemas.Column;
import com.sqlapp.data.schemas.ProductVersionInfo;
import com.sqlapp.data.schemas.SchemaProperties;
import com.sqlapp.data.schemas.Table;
import com.sqlapp.util.CommonUtils;
import com.sqlapp.util.FlexList;
import com.sqlapp.util.SqlExecuter;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.Reader;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DbUtils {
    public static final String CATALOG_NAME = "catalogName";
    public static final String SCHEMA_NAME = "schemaName";
    public static final String TABLE_NAME = "tableName";
    private static final Pattern MARIADB_PATTERN = Pattern.compile(".*?-(?<version>.*)-MariaDB.*");

    public static DatabaseMetaData getDatabaseMetaData(Connection connection) {
        try {
            return connection.getMetaData();
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    public static Connection getConnection(DatabaseMetaData databaseMetaData) {
        try {
            return databaseMetaData.getConnection();
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    public static Set<String> getSystemFunctions(DatabaseMetaData databaseMetaData) {
        String functions = null;
        try {
            functions = databaseMetaData.getSystemFunctions();
            Set<String[]> ret = CommonUtils.set(CommonUtils.split(functions, ","));
            return ret;
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    public static Set<String> getNumericFunctions(DatabaseMetaData databaseMetaData) {
        String functions = null;
        try {
            functions = databaseMetaData.getNumericFunctions();
            Set<String[]> ret = CommonUtils.set(CommonUtils.split(functions, ","));
            return ret;
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    public static Set<String> getStringFunctions(DatabaseMetaData databaseMetaData) {
        String functions = null;
        try {
            functions = databaseMetaData.getStringFunctions();
            Set<String[]> ret = CommonUtils.set(CommonUtils.split(functions, ","));
            return ret;
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    public static Set<String> getTimeDateFunctions(DatabaseMetaData databaseMetaData) {
        String functions = null;
        try {
            functions = databaseMetaData.getTimeDateFunctions();
            Set<String[]> ret = CommonUtils.set(CommonUtils.split(functions, ","));
            return ret;
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    public static Set<String> getFunctions(DatabaseMetaData databaseMetaData) {
        Set<String> ret = CommonUtils.set();
        ret.addAll(DbUtils.getTimeDateFunctions(databaseMetaData));
        ret.addAll(DbUtils.getStringFunctions(databaseMetaData));
        ret.addAll(DbUtils.getNumericFunctions(databaseMetaData));
        ret.addAll(DbUtils.getSystemFunctions(databaseMetaData));
        return ret;
    }

    public static String getDatabaseProductName(DatabaseMetaData databaseMetaData) {
        String result = null;
        try {
            result = databaseMetaData.getDatabaseProductName();
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
        return result;
    }

    public static String getDatabaseProductVersion(DatabaseMetaData databaseMetaData) {
        String result = null;
        try {
            result = databaseMetaData.getDatabaseProductVersion();
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
        return result;
    }

    public static ProductVersionInfo getProductVersionInfo(DatabaseMetaData databaseMetaData) {
        ProductVersionInfo productVersionInfo = new ProductVersionInfo();
        String dbProductVersion = DbUtils.getDatabaseProductVersion(databaseMetaData);
        Matcher matcher = MARIADB_PATTERN.matcher(dbProductVersion);
        if (matcher.matches()) {
            String version = matcher.group("version");
            String[] args = version.split("\\.");
            productVersionInfo.setName("MariaDB");
            int pos = 0;
            productVersionInfo.setMajorVersion(Converters.getDefault().convertObject(CommonUtils.get(args, pos++), Integer.class));
            productVersionInfo.setMinorVersion(Converters.getDefault().convertObject(CommonUtils.get(args, pos++), Integer.class));
            productVersionInfo.setRevision(Converters.getDefault().convertObject(CommonUtils.get(args, pos++), Integer.class));
            return productVersionInfo;
        }
        String name = DbUtils.getDatabaseProductName(databaseMetaData);
        productVersionInfo.setName(name);
        int majorVersion = DbUtils.getDatabaseMajorVersion(databaseMetaData);
        productVersionInfo.setMajorVersion(majorVersion);
        int minorVersion = DbUtils.getDatabaseMinorVersion(databaseMetaData);
        productVersionInfo.setMinorVersion(minorVersion);
        Pattern pattern = Pattern.compile(".*" + majorVersion + "\\.0*" + minorVersion + "\\.([0-9]+).*");
        matcher = pattern.matcher(dbProductVersion);
        Integer revision = null;
        if (matcher.matches()) {
            revision = Integer.valueOf(matcher.group(1));
            productVersionInfo.setRevision(revision);
        }
        return productVersionInfo;
    }

    public static ProductVersionInfo getProductVersionInfo(Connection connection) {
        return DbUtils.getProductVersionInfo(DbUtils.getDatabaseMetaData(connection));
    }

    public static String getDatabaseProductName(Connection connection) {
        return DbUtils.getDatabaseProductName(DbUtils.getDatabaseMetaData(connection));
    }

    public static int getDatabaseMajorVersion(DatabaseMetaData databaseMetaData) {
        int result = 0;
        try {
            result = databaseMetaData.getDatabaseMajorVersion();
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
        return result;
    }

    public static int getDatabaseMajorVersion(Connection connection) {
        return DbUtils.getDatabaseMajorVersion(DbUtils.getDatabaseMetaData(connection));
    }

    public static int getDatabaseMinorVersion(DatabaseMetaData databaseMetaData) {
        int result = 0;
        try {
            result = databaseMetaData.getDatabaseMinorVersion();
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
        return result;
    }

    public static int getDatabaseMinorVersion(Connection connection) {
        return DbUtils.getDatabaseMinorVersion(DbUtils.getDatabaseMetaData(connection));
    }

    public static List<String> getTableNames(DatabaseMetaData databaseMetaData, String catalog, String schemaPattern, String tableNamePattern) {
        return DbUtils.getTableNames(databaseMetaData, catalog, schemaPattern, tableNamePattern, "TABLE");
    }

    public static List<String> getTableNames(DatabaseMetaData databaseMetaData, String catalog, String schema, String tableNamePattern, String ... tableTypes) {
        ArrayList<String> result = new ArrayList<String>();
        ResultSet resultSet = null;
        try {
            resultSet = databaseMetaData.getTables(CommonUtils.emptyToNull(catalog), CommonUtils.emptyToNull(schema), tableNamePattern, tableTypes);
            while (resultSet.next()) {
                String tableName = resultSet.getString("TABLE_NAME");
                result.add(tableName);
            }
        }
        catch (SQLException e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                DbUtils.close(resultSet);
                throw throwable;
            }
        }
        DbUtils.close(resultSet);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void executeSql(Connection connection, Collection<SqlOperation> sqlList) throws SQLException {
        Statement statement = null;
        try {
            statement = connection.createStatement();
            for (SqlOperation commandText : sqlList) {
                if (CommonUtils.isEmpty(commandText.getSqlText())) continue;
                statement.execute(commandText.getSqlText());
            }
        }
        finally {
            DbUtils.close(statement);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void executeSql(Connection connection, String ... sqlList) throws SQLException {
        Statement statement = null;
        try {
            statement = connection.createStatement();
            for (String sql : sqlList) {
                if (CommonUtils.isEmpty(sql)) continue;
                statement.execute(sql);
            }
        }
        finally {
            DbUtils.close(statement);
        }
    }

    public static List<String> getViewNames(Connection connection, String catalog, String schemaPattern, String tableNamePattern) {
        return DbUtils.getTableNames(DbUtils.getDatabaseMetaData(connection), catalog, schemaPattern, tableNamePattern, "VIEW");
    }

    public static List<String> getViewNames(DatabaseMetaData databaseMetaData, String catalog, String schemaPattern, String tableNamePattern) {
        return DbUtils.getTableNames(databaseMetaData, catalog, schemaPattern, tableNamePattern, "VIEW");
    }

    public static List<String> getTableNames(Connection connection, String catalog, String schemaPattern, String tableNamePattern) {
        return DbUtils.getTableNames(DbUtils.getDatabaseMetaData(connection), catalog, schemaPattern, tableNamePattern);
    }

    public static void close(Connection connection) {
        if (connection == null) {
            return;
        }
        try {
            if (!connection.isClosed()) {
                connection.close();
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public static void close(AutoCloseable autoCloseable) {
        if (autoCloseable == null) {
            return;
        }
        try {
            autoCloseable.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void close(Statement statement) {
        if (statement == null) {
            return;
        }
        try {
            if (!statement.isClosed()) {
                statement.close();
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public static void close(PreparedStatement statement) {
        if (statement == null) {
            return;
        }
        try {
            if (!statement.isClosed()) {
                statement.close();
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public static void close(Closeable closeable) {
        if (closeable == null) {
            return;
        }
        try {
            closeable.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void close(ResultSet resultSet) {
        if (resultSet == null) {
            return;
        }
        try {
            resultSet.close();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public static void setPrimaryKeyInfo(Connection connection, Table table) {
        if (table.getName() == null) {
            return;
        }
        FlexList<String> keys = new FlexList<String>();
        ResultSet rs = null;
        try {
            DatabaseMetaData databaseMetaData = connection.getMetaData();
            rs = databaseMetaData.getPrimaryKeys(table.getCatalogName(), table.getSchemaName(), table.getName());
            String pkName = null;
            while (rs.next()) {
                pkName = rs.getString("PK_NAME");
                String columnName = rs.getString("COLUMN_NAME");
                short keySeq = rs.getShort("KEY_SEQ");
                if (!table.getColumns().contains(columnName)) break;
                keys.set(keySeq - 1, columnName);
            }
            if (keys.size() > 0 && table.getPrimaryKeyConstraint() == null) {
                table.setPrimaryKey(pkName, table.getColumns().getAll((List<String>)keys).toArray(new Column[0]));
            }
        }
        catch (SQLException e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                DbUtils.close(rs);
                throw throwable;
            }
        }
        DbUtils.close(rs);
    }

    public static List<Map<String, Object>> getResultSetMetadata(ResultSet resultset) throws SQLException {
        ResultSetMetaData metadata = resultset.getMetaData();
        int count = metadata.getColumnCount();
        List<Map<String, Object>> result = CommonUtils.list();
        for (int i = 1; i <= count; ++i) {
            Map map = CommonUtils.caseInsensitiveLinkedMap();
            map.put(SchemaProperties.CATALOG_NAME.getLabel(), metadata.getCatalogName(i));
            map.put(SchemaProperties.SCHEMA_NAME.getLabel(), metadata.getSchemaName(i));
            map.put(SchemaProperties.COLUMN_NAME.getLabel(), metadata.getColumnName(i));
            map.put("columnType", metadata.getColumnType(i));
            map.put("columnTypeName", metadata.getColumnTypeName(i));
            map.put("precision", metadata.getPrecision(i));
            map.put("scale", metadata.getScale(i));
            map.put(SchemaProperties.TABLE_NAME.getLabel(), metadata.getTableName(i));
            map.put("columnClassName", metadata.getColumnClassName(i));
            map.put("columnDisplaySize", metadata.getColumnDisplaySize(i));
            map.put("autoIncrement", metadata.isAutoIncrement(i));
            map.put("caseSensitive", metadata.isCaseSensitive(i));
            map.put("currency", metadata.isCurrency(i));
            map.put("nullable", metadata.isNullable(i));
            map.put("readOnly", metadata.isReadOnly(i));
            map.put("searchable", metadata.isSearchable(i));
            map.put("writable", metadata.isWritable(i));
            map.put("definitelyWritable", metadata.isDefinitelyWritable(i));
            result.add(map);
        }
        return result;
    }

    public static void setColumnMetadataFromSql(Connection connection, Table table) {
        Statement statement = null;
        ResultSet resultSet = null;
        Dialect dialect = DialectResolver.getInstance().getDialect(connection);
        try {
            statement = connection.createStatement();
            StringBuilder sql = new StringBuilder();
            sql.append("SELECT * FROM ");
            if (!CommonUtils.isEmpty(table.getSchemaName())) {
                sql.append(table.getSchemaName());
                sql.append(".");
            }
            sql.append(table.getName());
            sql.append(" WHERE 0=1");
            resultSet = statement.executeQuery(sql.toString());
            DbUtils.setColumnMetadata(dialect, resultSet, table);
        }
        catch (SQLException e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                DbUtils.close(resultSet);
                DbUtils.close(statement);
                throw throwable;
            }
        }
        DbUtils.close(resultSet);
        DbUtils.close(statement);
    }

    public static void setColumnMetadata(Dialect dialect, ResultSet resultSet, Table table) {
        try {
            ResultSetMetaData metaData = resultSet.getMetaData();
            int colCount = metaData.getColumnCount();
            String catalogName = null;
            String schemaName = null;
            String tableName = null;
            for (int i = 1; i <= colCount; ++i) {
                String columnName;
                if (!CommonUtils.isEmpty(metaData.getCatalogName(i))) {
                    catalogName = metaData.getCatalogName(i);
                }
                if (!CommonUtils.isEmpty(metaData.getSchemaName(i))) {
                    schemaName = metaData.getSchemaName(i);
                }
                if (!CommonUtils.isEmpty(metaData.getTableName(i))) {
                    tableName = metaData.getTableName(i);
                }
                if ((columnName = metaData.getColumnLabel(i)) == null) {
                    columnName = metaData.getColumnName(i);
                }
                Column column = null;
                if (table.getColumns().contains(columnName)) {
                    column = (Column)table.getColumns().get(columnName);
                    continue;
                }
                column = new Column(columnName);
                int sqlType = metaData.getColumnType(i);
                String productDataType = metaData.getColumnTypeName(i);
                long precision = metaData.getPrecision(i);
                int scale = metaData.getScale(i);
                boolean autoIncrement = metaData.isAutoIncrement(i);
                int nullable = metaData.isNullable(i);
                boolean allowDBNull = false;
                if (nullable != 2 && nullable == 1) {
                    allowDBNull = true;
                }
                dialect.setDbType(sqlType, productDataType, (Long)precision, (Integer)scale, column);
                column.setNullable(allowDBNull);
                column.setIdentity(autoIncrement);
                table.getColumns().add(column);
            }
            table.setCatalogName(catalogName);
            table.setSchemaName(schemaName);
            table.setName(tableName);
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    public static String readerToString(Reader reader) {
        BufferedReader bufferedReader = new BufferedReader(reader);
        StringBuilder buf = new StringBuilder();
        try {
            String line = null;
            line = bufferedReader.readLine();
            if (line != null) {
                buf.append(line);
            }
            while ((line = bufferedReader.readLine()) != null) {
                buf.append('\n');
                buf.append(line);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            DbUtils.close(reader);
        }
        return buf.toString();
    }

    public static String getStringValue(Connection connection, String sql) {
        return DbUtils.executeScalar(connection, sql, String.class);
    }

    public static <T> T executeScalar(Connection connection, String sql, Class<T> clazz) {
        return DbUtils.executeScalar(connection, sql, clazz, 1);
    }

    public static <T> T executeScalar(Connection connection, String sql, Class<T> clazz, int columnIndex) {
        T t;
        ResultSet rs;
        PreparedStatement statement;
        block5: {
            SqlExecuter sqlExec = new SqlExecuter(sql);
            statement = null;
            rs = null;
            statement = sqlExec.createPreparedStatement(connection);
            rs = statement.executeQuery();
            if (!rs.next()) break block5;
            Object object = rs.getObject(columnIndex);
            DbUtils.close(rs);
            DbUtils.close(statement);
            return (T)object;
        }
        try {
            t = null;
        }
        catch (SQLException e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                DbUtils.close(rs);
                DbUtils.close(statement);
                throw throwable;
            }
        }
        DbUtils.close(rs);
        DbUtils.close(statement);
        return t;
    }
}

